/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.webservices;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.webservices.PostHandlerChain;
import org.wildfly.swarm.config.webservices.PostHandlerChainConsumer;
import org.wildfly.swarm.config.webservices.PostHandlerChainSupplier;
import org.wildfly.swarm.config.webservices.PreHandlerChain;
import org.wildfly.swarm.config.webservices.PreHandlerChainConsumer;
import org.wildfly.swarm.config.webservices.PreHandlerChainSupplier;
import org.wildfly.swarm.config.webservices.Property;
import org.wildfly.swarm.config.webservices.PropertyConsumer;
import org.wildfly.swarm.config.webservices.PropertySupplier;

@Address(value="/subsystem=webservices/endpoint-config=*")
@ResourceType(value="endpoint-config")
public class EndpointConfig<T extends EndpointConfig<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    private EndpointConfigResources subresources = new EndpointConfigResources();

    public EndpointConfig(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public EndpointConfigResources subresources() {
        return this.subresources;
    }

    public T postHandlerChains(List<PostHandlerChain> value) {
        this.subresources.postHandlerChains = value;
        return (T)this;
    }

    public T postHandlerChain(PostHandlerChain value) {
        this.subresources.postHandlerChains.add(value);
        return (T)this;
    }

    public T postHandlerChain(String childKey, PostHandlerChainConsumer consumer) {
        PostHandlerChain child = new PostHandlerChain(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.postHandlerChain(child);
        return (T)this;
    }

    public T postHandlerChain(String childKey) {
        this.postHandlerChain(childKey, null);
        return (T)this;
    }

    public T postHandlerChain(PostHandlerChainSupplier supplier) {
        this.postHandlerChain(supplier.get());
        return (T)this;
    }

    public T preHandlerChains(List<PreHandlerChain> value) {
        this.subresources.preHandlerChains = value;
        return (T)this;
    }

    public T preHandlerChain(PreHandlerChain value) {
        this.subresources.preHandlerChains.add(value);
        return (T)this;
    }

    public T preHandlerChain(String childKey, PreHandlerChainConsumer consumer) {
        PreHandlerChain child = new PreHandlerChain(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.preHandlerChain(child);
        return (T)this;
    }

    public T preHandlerChain(String childKey) {
        this.preHandlerChain(childKey, null);
        return (T)this;
    }

    public T preHandlerChain(PreHandlerChainSupplier supplier) {
        this.preHandlerChain(supplier.get());
        return (T)this;
    }

    public T properties(List<Property> value) {
        this.subresources.properties = value;
        return (T)this;
    }

    public T property(Property value) {
        this.subresources.properties.add(value);
        return (T)this;
    }

    public T property(String childKey, PropertyConsumer consumer) {
        Property child = new Property(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.property(child);
        return (T)this;
    }

    public T property(String childKey) {
        this.property(childKey, null);
        return (T)this;
    }

    public T property(PropertySupplier supplier) {
        this.property(supplier.get());
        return (T)this;
    }

    public static class EndpointConfigResources {
        @ResourceDocumentation(value="Endpoint configuration POST handler chain")
        @SubresourceInfo(value="postHandlerChain")
        private List<PostHandlerChain> postHandlerChains = new ArrayList<PostHandlerChain>();
        @ResourceDocumentation(value="Endpoint configuration PRE handler chain")
        @SubresourceInfo(value="preHandlerChain")
        private List<PreHandlerChain> preHandlerChains = new ArrayList<PreHandlerChain>();
        @ResourceDocumentation(value="Endpoint configuration property")
        @SubresourceInfo(value="property")
        private List<Property> properties = new ArrayList<Property>();

        @Subresource
        public List<PostHandlerChain> postHandlerChains() {
            return this.postHandlerChains;
        }

        public PostHandlerChain postHandlerChain(String key) {
            return this.postHandlerChains.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<PreHandlerChain> preHandlerChains() {
            return this.preHandlerChains;
        }

        public PreHandlerChain preHandlerChain(String key) {
            return this.preHandlerChains.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<Property> properties() {
            return this.properties;
        }

        public Property property(String key) {
            return this.properties.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

