/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.enterprise.inject.Vetoed;
import org.jboss.modules.ModuleLoadException;
import org.wildfly.swarm.container.config.ClassLoaderConfigLocator;
import org.wildfly.swarm.container.config.ConfigLocator;
import org.wildfly.swarm.container.config.ConfigNode;
import org.wildfly.swarm.container.config.ConfigViewImpl;
import org.wildfly.swarm.container.config.EnvironmentConstructor;
import org.wildfly.swarm.container.config.FilesystemConfigLocator;
import org.wildfly.swarm.container.config.MapConfigNodeFactory;
import org.wildfly.swarm.container.config.PropertiesConfigNodeFactory;
import org.wildfly.swarm.spi.api.ConfigurationFilter;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;
import org.yaml.snakeyaml.resolver.Resolver;

@Vetoed
public class ConfigViewFactory {
    private static final String STAGES = "stages";
    private final ConfigViewImpl configView;
    private List<ConfigLocator> locators = new ArrayList<ConfigLocator>();
    private List<String> profiles = new ArrayList<String>();
    private static final String PROJECT_PREFIX = "project";
    private static final String STAGE = "stage";
    private static final String DEFAULT = "default";

    public static ConfigViewFactory defaultFactory() throws ModuleLoadException {
        return ConfigViewFactory.defaultFactory(null, System.getenv());
    }

    public static ConfigViewFactory defaultFactory(Properties properties, Map<String, String> environment) throws ModuleLoadException {
        return new ConfigViewFactory(properties, environment, new FilesystemConfigLocator(), ClassLoaderConfigLocator.system(), ClassLoaderConfigLocator.forApplication());
    }

    public ConfigViewFactory(Properties properties) {
        this.configView = new ConfigViewImpl().withProperties(properties).withEnvironment(System.getenv());
    }

    public ConfigViewFactory(Properties properties, Map<String, String> environment) {
        this.configView = new ConfigViewImpl().withProperties(properties).withEnvironment(environment);
    }

    public ConfigViewFactory(Properties properties, Map<String, String> environment, ConfigLocator ... locators) {
        this(properties, environment);
        for (ConfigLocator locator : locators) {
            this.addLocator(locator);
        }
    }

    public void addLocator(ConfigLocator locator) {
        this.locators.add(locator);
    }

    public ConfigViewFactory load(String profileName) {
        this.profiles.add(profileName);
        this.locators.stream().flatMap(locator -> {
            try {
                return locator.locate(profileName);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).filter(Objects::nonNull).forEach(url -> {
            try {
                this.load(profileName, (URL)url);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        return this;
    }

    public void load(String profileName, URL url) throws IOException {
        if (url.getPath().endsWith(".properties")) {
            this.loadProperties(profileName, url);
        } else if (url.getPath().endsWith(".yml") || url.getPath().endsWith(".yaml")) {
            this.loadYaml(profileName, url);
        }
    }

    protected void loadProperties(String profileName, URL url) throws IOException {
        Properties props = new Properties();
        props.load(url.openStream());
        ConfigNode configNode = PropertiesConfigNodeFactory.load(props);
        this.configView.register(profileName, configNode);
        this.configView.withProfile(profileName);
    }

    protected void loadYaml(String profileName, URL url) throws IOException {
        if (profileName.equals(STAGES) || url.getPath().endsWith("-stages.yml") || url.getPath().endsWith("-stages.yaml")) {
            this.loadProjectStages(url);
            return;
        }
        this.loadYamlProjectConfig(profileName, url);
    }

    public ConfigViewImpl get() {
        return this.configView;
    }

    public ConfigViewImpl get(boolean activate) {
        for (String profile : this.profiles) {
            this.configView.withProfile(profile);
        }
        this.configView.activate();
        return this.configView;
    }

    private void loadProjectStages(URL url) throws IOException {
        this.loadProjectStages(url.openStream());
    }

    private void loadProjectStages(InputStream inputStream) {
        Yaml yaml = ConfigViewFactory.newYaml(System.getenv());
        Iterable docs = yaml.loadAll(inputStream);
        for (Object item : docs) {
            Map doc = (Map)item;
            String name = DEFAULT;
            if (doc.get(PROJECT_PREFIX) != null) {
                name = (String)((Map)doc.get(PROJECT_PREFIX)).get(STAGE);
                doc.remove(PROJECT_PREFIX);
            }
            ConfigNode node = MapConfigNodeFactory.load(doc);
            if (name.equals(DEFAULT)) {
                this.configView.withDefaults(node);
                continue;
            }
            this.configView.register(name, node);
        }
    }

    private void loadYamlProjectConfig(String name, URL url) throws IOException {
        this.loadYamlProjectConfig(name, url.openStream());
    }

    private void loadYamlProjectConfig(String name, InputStream inputStream) {
        Map<String, ?> doc = ConfigViewFactory.loadYaml(inputStream);
        ConfigNode node = MapConfigNodeFactory.load(doc);
        this.configView.register(name, node);
        this.configView.withProfile(name);
    }

    static Map<String, ?> loadYaml(InputStream input, Map<String, String> environment) {
        Yaml yaml = ConfigViewFactory.newYaml(environment);
        return (Map)yaml.load(input);
    }

    static Map<String, ?> loadYaml(InputStream input) {
        return ConfigViewFactory.loadYaml(input, System.getenv());
    }

    private static Yaml newYaml(Map<String, String> environment) {
        return new Yaml((BaseConstructor)new EnvironmentConstructor(environment), new Representer(), new DumperOptions(), new Resolver(){

            public Tag resolve(NodeId kind, String value, boolean implicit) {
                if (value != null) {
                    if (value.startsWith("${env.")) {
                        return new Tag("!env");
                    }
                    if (value.equalsIgnoreCase("on") || value.equalsIgnoreCase("off") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("no")) {
                        return Tag.STR;
                    }
                }
                return super.resolve(kind, value, implicit);
            }
        });
    }

    public void withProfile(String name) {
        this.configView.withProfile(name);
    }

    public void withProperty(String name, String value) {
        this.configView.withProperty(name, value);
    }

    public void withFilter(ConfigurationFilter filter) {
        this.configView.withFilter(filter);
    }
}

