/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.config;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.constructor.AbstractConstruct;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.Tag;

public class EnvironmentConstructor
extends Constructor {
    private final Map<String, String> environment;
    private final Pattern pattern = Pattern.compile("\\$\\{env.(.*?)\\}");

    public EnvironmentConstructor(Map<String, String> environment) {
        this.environment = environment;
        this.yamlConstructors.put(new Tag("!env"), new ConstructEnvironmentVariable());
    }

    Object getValue(String value) {
        Matcher matcher = this.pattern.matcher(value);
        if (this.environment != null && matcher.find()) {
            String result;
            String variableName = matcher.group(1);
            String defaultValue = null;
            if (variableName.contains(":")) {
                String[] variableSplit = variableName.split(":", 2);
                defaultValue = variableSplit[1];
                variableName = variableSplit[0];
            }
            if ((result = this.environment.get(variableName)) != null) {
                return result;
            }
            if (defaultValue != null) {
                return defaultValue;
            }
        }
        return value;
    }

    private class ConstructEnvironmentVariable
    extends AbstractConstruct {
        private ConstructEnvironmentVariable() {
        }

        public Object construct(Node node) {
            String value = (String)EnvironmentConstructor.this.constructScalar((ScalarNode)node);
            return EnvironmentConstructor.this.getValue(value);
        }
    }
}

