/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime.cdi;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.literal.NamedLiteral;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Named;
import org.wildfly.swarm.container.Interface;
import org.wildfly.swarm.container.runtime.cdi.AbstractNetworkExtension;
import org.wildfly.swarm.spi.api.cdi.CommonBean;
import org.wildfly.swarm.spi.api.cdi.CommonBeanBuilder;
import org.wildfly.swarm.spi.api.config.ConfigKey;
import org.wildfly.swarm.spi.api.config.ConfigView;
import org.wildfly.swarm.spi.api.config.SimpleKey;

public class InterfaceExtension
extends AbstractNetworkExtension<Interface> {
    private static ConfigKey ROOT = ConfigKey.of((String[])new String[]{"thorntail", "network", "interfaces"});

    public InterfaceExtension(ConfigView configView) {
        super(configView);
    }

    @Override
    protected void applyConfiguration(Interface instance) {
        ConfigKey key = ROOT.append(new String[]{instance.getName().replace("-interface", "")});
        this.applyConfiguration(key.append(new String[]{"bind"}), bind -> instance.setExpression(bind.toString()));
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery abd, BeanManager beanManager) throws Exception {
        List configuredInterfaces = this.configView.simpleSubkeys(ROOT);
        for (SimpleKey interfaceName : configuredInterfaces) {
            Set ifaces = beanManager.getBeans(Interface.class, new Annotation[]{Any.Literal.INSTANCE});
            if (!ifaces.stream().noneMatch(e -> e.getQualifiers().stream().anyMatch(anno -> anno instanceof Named && ((Named)anno).value().equals(interfaceName + "-interface")))) continue;
            Interface iface = new Interface(interfaceName.name(), "0.0.0.0");
            this.applyConfiguration(iface);
            CommonBean interfaceBean = CommonBeanBuilder.newBuilder(Interface.class).beanClass(InterfaceExtension.class).scope(ApplicationScoped.class).addQualifier((Annotation)Any.Literal.INSTANCE).addQualifier((Annotation)NamedLiteral.of((String)(interfaceName.name() + "-interface"))).createSupplier(() -> iface).addType(Interface.class).addType(Object.class).build();
            abd.addBean((Bean)interfaceBean);
        }
    }
}

