/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime.cdi;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.literal.NamedLiteral;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Named;
import org.wildfly.swarm.container.runtime.cdi.AbstractNetworkExtension;
import org.wildfly.swarm.spi.api.SocketBindingGroup;
import org.wildfly.swarm.spi.api.cdi.CommonBean;
import org.wildfly.swarm.spi.api.cdi.CommonBeanBuilder;
import org.wildfly.swarm.spi.api.config.ConfigKey;
import org.wildfly.swarm.spi.api.config.ConfigView;
import org.wildfly.swarm.spi.api.config.SimpleKey;

public class SocketBindingGroupExtension
extends AbstractNetworkExtension<SocketBindingGroup> {
    private static ConfigKey ROOT = ConfigKey.of((String[])new String[]{"thorntail", "network", "socket-binding-groups"});

    public SocketBindingGroupExtension(ConfigView configView) {
        super(configView);
    }

    @Override
    protected void applyConfiguration(SocketBindingGroup instance) {
        ConfigKey key = ROOT.append(new String[]{instance.name()});
        this.applyConfiguration(key.append(new String[]{"port-offset"}), offset -> instance.portOffset(offset.toString()));
        this.applyConfiguration(key.append(new String[]{"default-interface"}), offset -> instance.portOffset(offset.toString()));
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery abd, BeanManager beanManager) throws Exception {
        List configuredGroups = this.configView.simpleSubkeys(ROOT);
        for (SimpleKey groupName : configuredGroups) {
            Set groups = beanManager.getBeans(SocketBindingGroup.class, new Annotation[]{Any.Literal.INSTANCE});
            AtomicBoolean producerRequired = new AtomicBoolean(false);
            if (!groups.stream().noneMatch(e -> e.getQualifiers().stream().anyMatch(anno -> anno instanceof Named && ((Named)anno).value().equals(groupName)))) continue;
            SocketBindingGroup group = new SocketBindingGroup(groupName.name(), null, "0");
            this.applyConfiguration(group);
            if (!producerRequired.get()) continue;
            CommonBean interfaceBean = CommonBeanBuilder.newBuilder(SocketBindingGroup.class).beanClass(SocketBindingGroupExtension.class).scope(ApplicationScoped.class).addQualifier((Annotation)Any.Literal.INSTANCE).addQualifier((Annotation)NamedLiteral.of((String)group.name())).createSupplier(() -> group).addType(SocketBindingGroup.class).addType(Object.class).build();
            abd.addBean((Bean)interfaceBean);
        }
    }
}

