/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime.wildfly;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.as.repository.ContentReference;
import org.jboss.as.repository.ContentRepository;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.spi.FileSystem;
import org.wildfly.swarm.bootstrap.util.TempFileManager;
import org.wildfly.swarm.container.runtime.wildfly.ShrinkWrapFileSystem;

@ApplicationScoped
public class SwarmContentRepository
implements ContentRepository,
Service<ContentRepository> {
    private Map<String, URI> index = new HashMap<String, URI>();
    private VirtualFile fsMount;
    @Inject
    private ShrinkWrapFileSystem fs;
    private Closeable fsCloseable;

    public static void addService(ServiceTarget serviceTarget, SwarmContentRepository repository) {
        serviceTarget.addService(SERVICE_NAME, (Service)repository).setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    public byte[] addContent(InputStream stream) throws IOException {
        try {
            byte[] sha1Bytes;
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            Path tmp = TempFileManager.INSTANCE.newTempFile("content", ".tmp").toPath();
            try (OutputStream fos = Files.newOutputStream(tmp, new OpenOption[0]);
                 BufferedInputStream bis = new BufferedInputStream(stream);){
                messageDigest.reset();
                try (DigestOutputStream dos = new DigestOutputStream(fos, messageDigest);){
                    int read;
                    byte[] bytes = new byte[8192];
                    while ((read = bis.read(bytes)) > -1) {
                        dos.write(bytes, 0, read);
                    }
                    fos.flush();
                }
                sha1Bytes = messageDigest.digest();
            }
            String key = SwarmContentRepository.toKey(sha1Bytes);
            this.index.put(key, tmp.toUri());
            return sha1Bytes;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
    }

    public byte[] addContent(Archive<?> archive) throws IOException, URISyntaxException {
        try {
            int read;
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            messageDigest.reset();
            BufferedInputStream bis = new BufferedInputStream(((ZipExporter)archive.as(ZipExporter.class)).exportAsInputStream());
            byte[] bytes = new byte[8192];
            while ((read = bis.read(bytes)) > -1) {
                messageDigest.update(bytes, 0, read);
            }
            byte[] sha1Bytes = messageDigest.digest();
            String key = SwarmContentRepository.toKey(sha1Bytes);
            this.fs.addArchive(archive.getName(), archive);
            this.index.put(key, this.fsMount.getChild(archive.getName()).toURI());
            return sha1Bytes;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
    }

    public void addContentReference(ContentReference contentReference) {
    }

    public VirtualFile getContent(byte[] sha1Bytes) {
        String key = SwarmContentRepository.toKey(sha1Bytes);
        VirtualFile result = VFS.getChild((URI)this.index.get(key));
        return result;
    }

    public boolean hasContent(byte[] sha1Bytes) {
        String key = SwarmContentRepository.toKey(sha1Bytes);
        boolean result = this.index.containsKey(key);
        return result;
    }

    public static String toKey(byte[] hash) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < hash.length; ++i) {
            int bit = Math.abs(hash[i]);
            str.append(Integer.toHexString(bit));
        }
        return str.toString();
    }

    public boolean syncContent(ContentReference contentReference) {
        return true;
    }

    public void removeContent(ContentReference contentReference) {
    }

    public void removeAllContent() throws IOException {
        for (URI uri : this.index.values()) {
            VirtualFile file = VFS.getChild((URI)uri);
            file.delete();
        }
    }

    public Map<String, Set<String>> cleanObsoleteContent() {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        result.put("marked-contents", Collections.emptySet());
        result.put("deleted-contents", Collections.emptySet());
        return result;
    }

    public void start(StartContext startContext) throws StartException {
        this.fsMount = VFS.getChild((String)"wildfly-swarm-deployments");
        try {
            this.fsCloseable = VFS.mount((VirtualFile)this.fsMount, (FileSystem)this.fs);
        }
        catch (IOException e) {
            throw new StartException((Throwable)e);
        }
    }

    public void stop(StopContext stopContext) {
        try {
            this.fsCloseable.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ContentRepository getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }
}

