/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.internal;

import java.lang.reflect.Constructor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.UUID;
import org.jboss.logging.Logger;
import org.wildfly.swarm.internal.GradleFileSystemLayout;
import org.wildfly.swarm.internal.MavenArgsParser;
import org.wildfly.swarm.internal.MavenFileSystemLayout;
import org.wildfly.swarm.internal.SwarmMessages;

public abstract class FileSystemLayout {
    public static final String CUSTOM_LAYOUT_CLASS = "thorntail.filesystem.layout.class";
    public static final String MAVEN_CMD_LINE_ARGS = "MAVEN_CMD_LINE_ARGS";
    private static final String POM_XML = "pom.xml";
    private static final String BUILD_GRADLE = "build.gradle";
    private static final String USER_DIR = "user.dir";
    private static final String JAR = ".jar";
    private static final String TARGET_CLASSES = "target/classes";
    private static final String BUILD_CLASSES_MAIN = "build/classes/main";
    private static final String BUILD_CLASSES_JAVA_MAIN = "build/classes/java/main";
    private static final String BUILD_RESOURCES_MAIN = "build/resources/main";
    private static final Logger LOG = Logger.getLogger((String)"org.wildfly.swarm");
    protected static final String TYPE_JAR = "jar";
    protected static final String TYPE_WAR = "war";
    protected final Path rootPath;

    public abstract String determinePackagingType();

    public abstract Path resolveBuildClassesDir();

    public abstract Path resolveBuildResourcesDir();

    public abstract Path resolveSrcWebAppDir();

    public static String archiveNameForClassesDir(Path path) {
        if (path.endsWith(TARGET_CLASSES)) {
            return path.subpath(path.getNameCount() - 3, path.getNameCount() - 2).toString() + JAR;
        }
        if (path.endsWith(BUILD_CLASSES_MAIN) || path.endsWith(BUILD_RESOURCES_MAIN)) {
            return path.subpath(path.getNameCount() - 4, path.getNameCount() - 3).toString() + JAR;
        }
        return UUID.randomUUID().toString() + JAR;
    }

    public static FileSystemLayout create() {
        String userDir = System.getProperty(USER_DIR);
        if (null == userDir) {
            throw SwarmMessages.MESSAGES.systemPropertyNotFound(USER_DIR);
        }
        return FileSystemLayout.create(userDir);
    }

    public static FileSystemLayout create(String root) {
        String mavenBuildFile;
        String implClassName = System.getProperty(CUSTOM_LAYOUT_CLASS);
        if (implClassName != null) {
            if (!(implClassName = implClassName.trim()).isEmpty()) {
                FileSystemLayout layout = null;
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                try {
                    Class<?> clazz = loader.loadClass(implClassName);
                    if (FileSystemLayout.class.isAssignableFrom(clazz)) {
                        Class<FileSystemLayout> implClazz = clazz.asSubclass(FileSystemLayout.class);
                        Constructor<FileSystemLayout> ctor = implClazz.getDeclaredConstructor(String.class);
                        layout = ctor.newInstance(root);
                    } else {
                        String msg = String.format("%s does not subclass %s", implClassName, FileSystemLayout.class.getName());
                        LOG.warn((Object)SwarmMessages.MESSAGES.invalidFileSystemLayoutProvided(msg));
                    }
                }
                catch (ReflectiveOperationException e) {
                    Throwable cause = e.getCause();
                    String msg = String.format("Unable to instantiate layout class (%s) due to: %s", implClassName, cause != null ? cause.getMessage() : e.getMessage());
                    LOG.warn((Object)SwarmMessages.MESSAGES.invalidFileSystemLayoutProvided(msg));
                    LOG.debug((Object)SwarmMessages.MESSAGES.invalidFileSystemLayoutProvided(msg), (Throwable)e);
                    throw SwarmMessages.MESSAGES.cannotIdentifyFileSystemLayout(msg);
                }
                if (layout != null) {
                    return layout;
                }
            } else {
                LOG.warn((Object)SwarmMessages.MESSAGES.invalidFileSystemLayoutProvided("Implementation class name is empty."));
            }
        }
        if (Files.exists(Paths.get(root, mavenBuildFile = FileSystemLayout.resolveMavenBuildFileName()), new LinkOption[0])) {
            return new MavenFileSystemLayout(root);
        }
        if (Files.exists(Paths.get(root, BUILD_GRADLE), new LinkOption[0])) {
            return new GradleFileSystemLayout(root);
        }
        throw SwarmMessages.MESSAGES.cannotIdentifyFileSystemLayout(root);
    }

    public static String resolveMavenBuildFileName() {
        MavenArgsParser args;
        Optional<String> f_arg;
        String cmdLine = System.getenv(MAVEN_CMD_LINE_ARGS);
        String buildFileName = POM_XML;
        if (cmdLine != null && (f_arg = (args = MavenArgsParser.parse(cmdLine)).get(MavenArgsParser.ARG.F)).isPresent()) {
            buildFileName = f_arg.get();
        }
        return buildFileName;
    }

    protected FileSystemLayout(String path) {
        this.rootPath = Paths.get(path, new String[0]);
    }

    public abstract Path getRootPath();
}

