/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.resource;

import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.server.handlers.resource.URLResource;
import java.io.IOException;
import java.net.URL;

public class ClassPathResourceManager
implements ResourceManager {
    private final ClassLoader classLoader;
    private final String prefix;

    public ClassPathResourceManager(ClassLoader loader, Package p) {
        this(loader, p.getName().replace(".", "/"));
    }

    public ClassPathResourceManager(ClassLoader classLoader, String prefix) {
        this.classLoader = classLoader;
        this.prefix = prefix.equals("") ? "" : (prefix.endsWith("/") ? prefix : prefix + "/");
    }

    @Override
    public Resource getResource(String path) throws IOException {
        String realPath;
        URL resource;
        String modPath = path;
        if (modPath.startsWith("/")) {
            modPath = path.substring(1);
        }
        if ((resource = this.classLoader.getResource(realPath = this.prefix + modPath)) == null) {
            return null;
        }
        return new URLResource(resource, resource.openConnection());
    }
}

