/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HttpString;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class AllowedMethodsHandler
implements HttpHandler {
    private final Set<HttpString> allowedMethods;
    private final HttpHandler next;

    public AllowedMethodsHandler(HttpHandler next, Set<HttpString> allowedMethods) {
        this.allowedMethods = new HashSet<HttpString>(allowedMethods);
        this.next = next;
    }

    public AllowedMethodsHandler(HttpHandler next, HttpString ... allowedMethods) {
        this.allowedMethods = new HashSet<HttpString>(Arrays.asList(allowedMethods));
        this.next = next;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (this.allowedMethods.contains(exchange.getRequestMethod())) {
            this.next.handleRequest(exchange);
        } else {
            exchange.setResponseCode(405);
            exchange.endExchange();
        }
    }
}

