/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.UndertowMessages;
import io.undertow.util.HeaderToken;
import java.util.LinkedHashMap;
import java.util.Map;

public class HeaderTokenParser<E extends HeaderToken> {
    private static final char EQUALS = '=';
    private static final char COMMA = ',';
    private static final char QUOTE = '\"';
    private final Map<String, E> expectedTokens;

    public HeaderTokenParser(Map<String, E> expectedTokens) {
        this.expectedTokens = expectedTokens;
    }

    public Map<E, String> parseHeader(String header) {
        char[] headerChars = header.toCharArray();
        LinkedHashMap<HeaderToken, String> response = new LinkedHashMap<HeaderToken, String>();
        SearchingFor searchingFor = SearchingFor.START_OF_NAME;
        int nameStart = 0;
        HeaderToken currentToken = null;
        int valueStart = 0;
        block7: for (int i = 0; i < headerChars.length; ++i) {
            switch (searchingFor) {
                case START_OF_NAME: {
                    if (headerChars[i] == ',' || Character.isWhitespace(headerChars[i])) continue block7;
                    nameStart = i;
                    searchingFor = SearchingFor.EQUALS_SIGN;
                    continue block7;
                }
                case EQUALS_SIGN: {
                    if (headerChars[i] != '=') continue block7;
                    String paramName = String.valueOf(headerChars, nameStart, i - nameStart);
                    currentToken = (HeaderToken)this.expectedTokens.get(paramName);
                    if (currentToken == null) {
                        throw UndertowMessages.MESSAGES.unexpectedTokenInHeader(paramName);
                    }
                    searchingFor = SearchingFor.START_OF_VALUE;
                    continue block7;
                }
                case START_OF_VALUE: {
                    if (Character.isWhitespace(headerChars[i])) continue block7;
                    if (headerChars[i] == '\"' && currentToken.isAllowQuoted()) {
                        valueStart = i + 1;
                        searchingFor = SearchingFor.LAST_QUOTE;
                        continue block7;
                    }
                    valueStart = i;
                    searchingFor = SearchingFor.END_OF_VALUE;
                    continue block7;
                }
                case LAST_QUOTE: {
                    if (headerChars[i] != '\"') continue block7;
                    String value = String.valueOf(headerChars, valueStart, i - valueStart);
                    response.put(currentToken, value);
                    searchingFor = SearchingFor.START_OF_NAME;
                    continue block7;
                }
                case END_OF_VALUE: {
                    if (headerChars[i] != ',' && !Character.isWhitespace(headerChars[i])) continue block7;
                    String value = String.valueOf(headerChars, valueStart, i - valueStart);
                    response.put(currentToken, value);
                    searchingFor = SearchingFor.START_OF_NAME;
                }
            }
        }
        if (searchingFor == SearchingFor.END_OF_VALUE) {
            String value = String.valueOf(headerChars, valueStart, headerChars.length - valueStart);
            response.put(currentToken, value);
        } else if (searchingFor != SearchingFor.START_OF_NAME) {
            throw UndertowMessages.MESSAGES.invalidHeader();
        }
        return response;
    }

    static enum SearchingFor {
        START_OF_NAME,
        EQUALS_SIGN,
        START_OF_VALUE,
        LAST_QUOTE,
        END_OF_VALUE;

    }
}

