/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class QValueParser {
    private QValueParser() {
    }

    public static List<List<QValueResult>> parse(List<String> headers) {
        ArrayList<QValueResult> found = new ArrayList<QValueResult>();
        QValueResult current = null;
        for (String header : headers) {
            int l = header.length();
            int stringStart = 0;
            block6: for (int i = 0; i < l; ++i) {
                char c = header.charAt(i);
                switch (c) {
                    case ',': {
                        if (current != null && i - stringStart > 2 && header.charAt(stringStart) == 'q' && header.charAt(stringStart + 1) == '=') {
                            current.qvalue = header.substring(stringStart + 2, i);
                            current = null;
                        } else if (stringStart != i) {
                            current = QValueParser.handleNewEncoding(found, header, stringStart, i);
                        }
                        stringStart = i + 1;
                        continue block6;
                    }
                    case ';': {
                        if (stringStart == i) continue block6;
                        current = QValueParser.handleNewEncoding(found, header, stringStart, i);
                        stringStart = i + 1;
                        continue block6;
                    }
                    case ' ': {
                        if (stringStart != i) {
                            if (current != null && i - stringStart > 2 && header.charAt(stringStart) == 'q' && header.charAt(stringStart + 1) == '=') {
                                current.qvalue = header.substring(stringStart + 2, i);
                            } else {
                                current = QValueParser.handleNewEncoding(found, header, stringStart, i);
                            }
                        }
                        stringStart = i + 1;
                    }
                }
            }
            if (stringStart == l) continue;
            if (current != null && l - stringStart > 2 && header.charAt(stringStart) == 'q' && header.charAt(stringStart + 1) == '=') {
                current.qvalue = header.substring(stringStart + 2, l);
                continue;
            }
            current = QValueParser.handleNewEncoding(found, header, stringStart, l);
        }
        Collections.sort(found, Collections.reverseOrder());
        String currentQValue = null;
        ArrayList<List<QValueResult>> values = new ArrayList<List<QValueResult>>();
        ArrayList<QValueResult> currentSet = null;
        for (QValueResult val : found) {
            if (!val.qvalue.equals(currentQValue)) {
                currentQValue = val.qvalue;
                currentSet = new ArrayList<QValueResult>();
                values.add(currentSet);
            }
            currentSet.add(val);
        }
        return values;
    }

    private static QValueResult handleNewEncoding(List<QValueResult> found, String header, int stringStart, int i) {
        QValueResult current = new QValueResult();
        current.value = header.substring(stringStart, i);
        found.add(current);
        return current;
    }

    public static class QValueResult
    implements Comparable<QValueResult> {
        private String value;
        private String qvalue = "1";

        public String getValue() {
            return this.value;
        }

        public String getQvalue() {
            return this.qvalue;
        }

        @Override
        public int compareTo(QValueResult other) {
            String t = this.qvalue;
            String o = other.qvalue;
            if (t == null && o == null) {
                return 0;
            }
            if (o == null) {
                return 1;
            }
            if (t == null) {
                return -1;
            }
            int tl = t.length();
            int ol = o.length();
            for (int i = 0; i < 5; ++i) {
                char oc;
                char tc;
                int res;
                if (tl == i || ol == i) {
                    return ol - tl;
                }
                if (i == 1 || (res = (tc = t.charAt(i)) - (oc = o.charAt(i))) == 0) continue;
                return res;
            }
            return 0;
        }

        public boolean isQValueZero() {
            if (this.qvalue != null) {
                int length = Math.min(5, this.qvalue.length());
                boolean zero = true;
                for (int j = 0; j < length; ++j) {
                    if (j == 1 || this.qvalue.charAt(j) == '0') continue;
                    zero = false;
                    break;
                }
                return zero;
            }
            return false;
        }
    }
}

