/*
 * Decompiled with CFR 0.152.
 */
package io.undertow;

import io.undertow.predicate.Predicate;
import io.undertow.predicate.PredicateParser;
import io.undertow.predicate.PredicatesHandler;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.DateHandler;
import io.undertow.server.handlers.HttpContinueReadHandler;
import io.undertow.server.handlers.HttpTraceHandler;
import io.undertow.server.handlers.IPAddressAccessControlHandler;
import io.undertow.server.handlers.NameVirtualHostHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.PredicateContextHandler;
import io.undertow.server.handlers.PredicateHandler;
import io.undertow.server.handlers.RedirectHandler;
import io.undertow.server.handlers.SetAttributeHandler;
import io.undertow.server.handlers.SetHeaderHandler;
import io.undertow.server.handlers.URLDecodingHandler;
import io.undertow.server.handlers.builder.PredicatedHandler;
import io.undertow.server.handlers.resource.ResourceHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.websockets.core.handler.WebSocketConnectionCallback;
import io.undertow.websockets.core.handler.WebSocketProtocolHandshakeHandler;
import java.util.List;

public class Handlers {
    public static PathHandler path(HttpHandler defaultHandler) {
        return new PathHandler(defaultHandler);
    }

    public static PathHandler path() {
        return new PathHandler();
    }

    public static NameVirtualHostHandler virtualHost() {
        return new NameVirtualHostHandler();
    }

    public static NameVirtualHostHandler virtualHost(HttpHandler defaultHandler) {
        return new NameVirtualHostHandler().setDefaultHandler(defaultHandler);
    }

    public static NameVirtualHostHandler virtualHost(HttpHandler hostHandler, String ... hostnames) {
        NameVirtualHostHandler handler = new NameVirtualHostHandler();
        for (String host : hostnames) {
            handler.addHost(host, hostHandler);
        }
        return handler;
    }

    public static NameVirtualHostHandler virtualHost(HttpHandler defaultHandler, HttpHandler hostHandler, String ... hostnames) {
        return Handlers.virtualHost(hostHandler, hostnames).setDefaultHandler(defaultHandler);
    }

    public static WebSocketProtocolHandshakeHandler websocket(WebSocketConnectionCallback sessionHandler) {
        return new WebSocketProtocolHandshakeHandler(sessionHandler);
    }

    public static WebSocketProtocolHandshakeHandler websocket(WebSocketConnectionCallback sessionHandler, HttpHandler next) {
        return new WebSocketProtocolHandshakeHandler(sessionHandler, next);
    }

    public static ResourceHandler resource(ResourceManager resourceManager) {
        return new ResourceHandler().setResourceManager(resourceManager).setDirectoryListingEnabled(false);
    }

    public static RedirectHandler redirect(String location) {
        return new RedirectHandler(location);
    }

    public static HttpTraceHandler trace(HttpHandler next) {
        return new HttpTraceHandler(next);
    }

    public static DateHandler date(HttpHandler next) {
        return new DateHandler(next);
    }

    public static PredicateHandler predicate(Predicate predicate, HttpHandler trueHandler, HttpHandler falseHandler) {
        return new PredicateHandler(predicate, trueHandler, falseHandler);
    }

    public static HttpHandler predicateContext(HttpHandler next) {
        return new PredicateContextHandler(next);
    }

    public static PredicatesHandler predicates(List<PredicatedHandler> handlers, HttpHandler next) {
        PredicatesHandler predicatesHandler = new PredicatesHandler(next);
        for (PredicatedHandler handler : handlers) {
            predicatesHandler.addPredicatedHandler(handler);
        }
        return predicatesHandler;
    }

    public static SetHeaderHandler header(HttpHandler next, String headerName, String headerValue) {
        return new SetHeaderHandler(next, headerName, headerValue);
    }

    public static final IPAddressAccessControlHandler ipAccessControl(HttpHandler next, boolean defaultAllow) {
        return new IPAddressAccessControlHandler(next).setDefaultAllow(defaultAllow);
    }

    public static final HttpContinueReadHandler httpContinueRead(HttpHandler next) {
        return new HttpContinueReadHandler(next);
    }

    public static final URLDecodingHandler urlDecoding(HttpHandler next, String charset) {
        return new URLDecodingHandler(next, charset);
    }

    public static SetAttributeHandler setAttribute(HttpHandler next, String attribute, String value, ClassLoader classLoader) {
        return new SetAttributeHandler(next, attribute, value, classLoader);
    }

    public static HttpHandler rewrite(String condition, String target, ClassLoader classLoader, HttpHandler next) {
        return Handlers.predicateContext(Handlers.predicate(PredicateParser.parse(condition, classLoader), Handlers.setAttribute(next, "%R", target, classLoader), next));
    }

    private Handlers() {
    }
}

