/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.security.impl;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.idm.PasswordCredential;
import io.undertow.server.DefaultResponseListener;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.CookieImpl;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import java.io.IOException;
import java.util.Map;

public class FormAuthenticationMechanism
implements AuthenticationMechanism {
    public static final String LOCATION_COOKIE = "FORM_AUTH_ORIGINAL_URL";
    public static final String DEFAULT_POST_LOCATION = "/j_security_check";
    private final String name;
    private final String loginPage;
    private final String errorPage;
    private final String postLocation;
    private final FormParserFactory formParserFactory;

    public FormAuthenticationMechanism(String name, String loginPage, String errorPage) {
        this(FormParserFactory.builder().build(), name, loginPage, errorPage);
    }

    public FormAuthenticationMechanism(String name, String loginPage, String errorPage, String postLocation) {
        this(FormParserFactory.builder().build(), name, loginPage, errorPage, postLocation);
    }

    public FormAuthenticationMechanism(FormParserFactory formParserFactory, String name, String loginPage, String errorPage) {
        this(formParserFactory, name, loginPage, errorPage, DEFAULT_POST_LOCATION);
    }

    public FormAuthenticationMechanism(FormParserFactory formParserFactory, String name, String loginPage, String errorPage, String postLocation) {
        this.name = name;
        this.loginPage = loginPage;
        this.errorPage = errorPage;
        this.postLocation = postLocation;
        this.formParserFactory = formParserFactory;
    }

    @Override
    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        if (exchange.getRequestURI().endsWith(this.postLocation) && exchange.getRequestMethod().equals(Methods.POST)) {
            return this.runFormAuth(exchange, securityContext);
        }
        return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthenticationMechanism.AuthenticationMechanismOutcome runFormAuth(HttpServerExchange exchange, SecurityContext securityContext) {
        FormDataParser parser = this.formParserFactory.createParser(exchange);
        if (parser == null) {
            UndertowLogger.REQUEST_LOGGER.debug("Could not authenticate as no form parser is present");
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
        try {
            FormData data = parser.parseBlocking();
            FormData.FormValue jUsername = data.getFirst("j_username");
            FormData.FormValue jPassword = data.getFirst("j_password");
            if (jUsername == null || jPassword == null) {
                UndertowLogger.REQUEST_LOGGER.debug("Could not authenticate as username or password was not present in the posted result");
                return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
            }
            String userName = jUsername.getValue();
            String password = jPassword.getValue();
            AuthenticationMechanism.AuthenticationMechanismOutcome outcome = null;
            PasswordCredential credential = new PasswordCredential(password.toCharArray());
            try {
                IdentityManager identityManager = securityContext.getIdentityManager();
                Account account = identityManager.verify(userName, credential);
                if (account != null) {
                    securityContext.authenticationComplete(account, this.name, true);
                    outcome = AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
                } else {
                    securityContext.authenticationFailed(UndertowMessages.MESSAGES.authenticationFailed(userName), this.name);
                }
                if (outcome == AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED) {
                    this.handleRedirectBack(exchange);
                    exchange.endExchange();
                }
                return outcome != null ? outcome : AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
            }
            catch (Throwable throwable) {
                if (outcome == AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED) {
                    this.handleRedirectBack(exchange);
                    exchange.endExchange();
                }
                return outcome != null ? outcome : AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void handleRedirectBack(HttpServerExchange exchange) {
        Map<String, Cookie> cookies = exchange.getRequestCookies();
        if (cookies != null && cookies.containsKey(LOCATION_COOKIE)) {
            final String location = cookies.get(LOCATION_COOKIE).getValue();
            exchange.addDefaultResponseListener(new DefaultResponseListener(){

                @Override
                public boolean handleDefaultResponse(HttpServerExchange exchange) {
                    FormAuthenticationMechanism.sendRedirect(exchange, location);
                    exchange.setResponseCode(302);
                    exchange.endExchange();
                    return true;
                }
            });
            CookieImpl cookie = new CookieImpl(LOCATION_COOKIE);
            cookie.setMaxAge(0);
            exchange.setResponseCookie(cookie);
        }
    }

    @Override
    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        if (exchange.getRequestURI().endsWith(this.postLocation) && exchange.getRequestMethod().equals(Methods.POST)) {
            Integer code = this.servePage(exchange, this.errorPage);
            return new AuthenticationMechanism.ChallengeResult(true, code);
        }
        this.storeInitialLocation(exchange);
        Integer code = this.servePage(exchange, this.loginPage);
        return new AuthenticationMechanism.ChallengeResult(true, code);
    }

    protected void storeInitialLocation(HttpServerExchange exchange) {
        exchange.setResponseCookie(new CookieImpl(LOCATION_COOKIE, exchange.getRequestURI()));
    }

    protected Integer servePage(HttpServerExchange exchange, String location) {
        FormAuthenticationMechanism.sendRedirect(exchange, location);
        return 307;
    }

    static void sendRedirect(HttpServerExchange exchange, String location) {
        String loc = exchange.getRequestScheme() + "://" + exchange.getHostAndPort() + location;
        exchange.getResponseHeaders().put(Headers.LOCATION, loc);
    }
}

