/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HttpString;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class DisallowedMethodsHandler
implements HttpHandler {
    private final Set<HttpString> disallowedMethods;
    private final HttpHandler next;

    public DisallowedMethodsHandler(HttpHandler next, Set<HttpString> disallowedMethods) {
        this.disallowedMethods = new HashSet<HttpString>(disallowedMethods);
        this.next = next;
    }

    public DisallowedMethodsHandler(HttpHandler next, HttpString ... disallowedMethods) {
        this.disallowedMethods = new HashSet<HttpString>(Arrays.asList(disallowedMethods));
        this.next = next;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (this.disallowedMethods.contains(exchange.getRequestMethod())) {
            exchange.setResponseCode(405);
            exchange.endExchange();
        } else {
            this.next.handleRequest(exchange);
        }
    }
}

