/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core;

import io.undertow.websockets.core.SendChannel;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketFrameType;
import io.undertow.websockets.core.WebSocketLogger;
import io.undertow.websockets.core.WebSocketMessages;
import io.undertow.websockets.core.WebSocketUtils;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.xnio.Buffers;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Option;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.Channels;
import org.xnio.channels.FixedLengthOverflowException;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public abstract class StreamSinkFrameChannel
implements StreamSinkChannel,
SendChannel {
    private final WebSocketFrameType type;
    protected final StreamSinkChannel channel;
    protected final WebSocketChannel wsChannel;
    private final ChannelListener.SimpleSetter<StreamSinkFrameChannel> closeSetter = new ChannelListener.SimpleSetter();
    private final ChannelListener.SimpleSetter<StreamSinkFrameChannel> writeSetter = new ChannelListener.SimpleSetter();
    protected final long payloadSize;
    private long written;
    private final Object writeWaitLock = new Object();
    private int waiters;
    private volatile boolean writesSuspended = true;
    private int rsv;
    private boolean finalFragment = true;
    private ByteBuffer start;
    private ByteBuffer end;
    private boolean frameStartWritten;
    private boolean frameEndWritten;
    private static final AtomicReferenceFieldUpdater<StreamSinkFrameChannel, ChannelState> stateUpdater = AtomicReferenceFieldUpdater.newUpdater(StreamSinkFrameChannel.class, ChannelState.class, "state");
    private volatile ChannelState state = ChannelState.WAITING;

    protected StreamSinkFrameChannel(StreamSinkChannel channel, WebSocketChannel wsChannel, WebSocketFrameType type, long payloadSize) {
        this.channel = channel;
        this.wsChannel = wsChannel;
        this.type = type;
        this.payloadSize = payloadSize;
    }

    public ChannelListener.SimpleSetter<? extends StreamSinkFrameChannel> getWriteSetter() {
        return this.writeSetter;
    }

    public long getPayloadSize() {
        return this.payloadSize;
    }

    public int getRsv() {
        return this.rsv;
    }

    public boolean isFinalFragment() {
        return this.finalFragment;
    }

    public void setFinalFragment(boolean finalFragment) {
        if (!this.isFragmentationSupported() && !finalFragment) {
            throw WebSocketMessages.MESSAGES.fragmentationNotSupported();
        }
        if (this.written > 0L) {
            throw WebSocketMessages.MESSAGES.writeInProgress();
        }
        this.finalFragment = finalFragment;
    }

    public void setRsv(int rsv) {
        if (!this.areExtensionsSupported() && rsv != 0) {
            throw WebSocketMessages.MESSAGES.extensionsNotSupported();
        }
        if (this.written > 0L) {
            throw WebSocketMessages.MESSAGES.writeInProgress();
        }
        this.rsv = rsv;
    }

    protected abstract ByteBuffer createFrameStart();

    protected abstract ByteBuffer createFrameEnd();

    public boolean isFragmentationSupported() {
        return false;
    }

    public boolean areExtensionsSupported() {
        return false;
    }

    private ByteBuffer getFrameStart() {
        if (this.start == null) {
            this.start = this.createFrameStart();
            this.start.flip();
        }
        return this.start;
    }

    private ByteBuffer getFrameEnd() {
        if (this.end == null) {
            this.end = this.createFrameEnd();
            this.end.flip();
        }
        return this.end;
    }

    private void freeStartAndEndFrame() {
        this.freeFrameStart();
        this.freeFrameEnd();
    }

    private void freeFrameStart() {
        if (this.start != null && !this.start.hasRemaining()) {
            this.frameStartWritten = true;
            this.frameStartComplete();
        }
    }

    private void freeFrameEnd() {
        if (this.end != null && !this.end.hasRemaining()) {
            this.frameEndWritten = true;
            this.endFrameComplete();
        }
    }

    protected void frameStartComplete() {
    }

    protected void endFrameComplete() {
    }

    private ByteBuffer[] composeBuffers(ByteBuffer[] buffers, int offset, int length) {
        boolean needsEnd;
        boolean needsStart = !this.frameStartWritten;
        boolean bl = needsEnd = this.bytesToWrite() <= StreamSinkFrameChannel.maxBytes(buffers, offset, length);
        if (!needsStart && !needsEnd) {
            ByteBuffer[] bufs = new ByteBuffer[length];
            System.arraycopy(buffers, offset, bufs, 0, bufs.length);
            return bufs;
        }
        if (!needsStart && needsEnd) {
            ByteBuffer[] bufs = new ByteBuffer[length + 1];
            System.arraycopy(buffers, offset, bufs, 0, length);
            bufs[bufs.length - 1] = this.getFrameEnd();
            return bufs;
        }
        if (needsStart && !needsEnd) {
            ByteBuffer[] bufs = new ByteBuffer[length + 1];
            System.arraycopy(buffers, offset, bufs, 1, length);
            bufs[0] = this.getFrameStart();
            return bufs;
        }
        if (needsStart && needsEnd) {
            ByteBuffer[] bufs = new ByteBuffer[length + 2];
            System.arraycopy(buffers, offset, bufs, 1, length);
            bufs[0] = this.getFrameStart();
            bufs[bufs.length - 1] = this.getFrameEnd();
            return bufs;
        }
        throw new IllegalStateException();
    }

    private static long maxBytes(ByteBuffer[] buffers, int offset, int length) {
        long max = 0L;
        while (offset < length) {
            max += (long)buffers[offset].remaining();
            ++offset;
        }
        return max;
    }

    public int writeFinal(ByteBuffer src) throws IOException {
        return Channels.writeFinalBasic((StreamSinkChannel)this, (ByteBuffer)src);
    }

    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return Channels.writeFinalBasic((StreamSinkChannel)this, (ByteBuffer[])srcs, (int)offset, (int)length);
    }

    public long writeFinal(ByteBuffer[] srcs) throws IOException {
        return Channels.writeFinalBasic((StreamSinkChannel)this, (ByteBuffer[])srcs, (int)0, (int)srcs.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean flush0() throws IOException {
        if (this.payloadSize == 0L && !this.frameStartWritten) {
            ByteBuffer[] bufs = new ByteBuffer[]{this.getFrameStart(), this.getFrameEnd()};
            while (!this.frameStartWritten || !this.frameEndWritten) {
                try {
                    long w = this.channel.write(bufs);
                    if (w == -1L) {
                        throw WebSocketMessages.MESSAGES.channelClosed();
                    }
                    if (w != 0L) continue;
                    boolean bl = false;
                    return bl;
                }
                finally {
                    this.freeStartAndEndFrame();
                }
            }
            return true;
        }
        if (this.frameStartWritten) {
            if (this.getState() == ChannelState.SHUTDOWN) {
                try {
                    if (!this.frameEndWritten) {
                        ByteBuffer end = this.getFrameEnd();
                        while (end.hasRemaining()) {
                            int b = this.channel.write(end);
                            if (b == -1) {
                                throw WebSocketMessages.MESSAGES.channelClosed();
                            }
                            if (b != 0) continue;
                            boolean bl = false;
                            return bl;
                        }
                    }
                    boolean bl = true;
                    return bl;
                }
                finally {
                    this.freeStartAndEndFrame();
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void activate() {
        ChannelState old;
        Object object = this.writeWaitLock;
        synchronized (object) {
            ChannelState newState;
            do {
                if ((old = this.state) == ChannelState.WAITING) {
                    newState = ChannelState.ACTIVE;
                    continue;
                }
                if (old != ChannelState.WAITING_SHUTDOWN) break;
                newState = ChannelState.SHUTDOWN;
            } while (!stateUpdater.compareAndSet(this, old, newState));
            this.notifyWriteWaiters();
        }
        if (old == ChannelState.CLOSED) {
            this.wsChannel.complete(this);
            return;
        }
        object = this;
        synchronized (object) {
            if (this.writesSuspended) {
                this.channel.suspendWrites();
            } else if (this.channel.isOpen()) {
                this.channel.resumeWrites();
            } else {
                this.queueWriteListener();
            }
        }
    }

    private void queueWriteListener() {
        this.getWriteThread().execute(new Runnable(){

            @Override
            public void run() {
                WebSocketLogger.REQUEST_LOGGER.debugf("Invoking directly queued write listener", new Object[0]);
                ChannelListeners.invokeChannelListener((Channel)((Object)StreamSinkFrameChannel.this), (ChannelListener)StreamSinkFrameChannel.this.writeSetter.get());
            }
        });
    }

    public WebSocketFrameType getType() {
        return this.type;
    }

    public XnioWorker getWorker() {
        return this.channel.getWorker();
    }

    public XnioIoThread getIoThread() {
        return this.channel.getIoThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        Object object = this.writeWaitLock;
        synchronized (object) {
            ChannelState oldState;
            do {
                if ((oldState = this.state) != ChannelState.CLOSED) continue;
                return;
            } while (stateUpdater.compareAndSet(this, oldState, ChannelState.CLOSED));
            this.notifyWriteWaiters();
        }
        try {
            WebSocketLogger.REQUEST_LOGGER.closedBeforeFinishedWriting(this);
            this.wsChannel.markBroken();
        }
        finally {
            ChannelListeners.invokeChannelListener((Channel)((Object)this), (ChannelListener)this.closeSetter.get());
        }
    }

    private void notifyWriteWaiters() {
        assert (Thread.holdsLock(this.writeWaitLock));
        if (this.waiters > 0) {
            this.writeWaitLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        this.checkClosed();
        if (!this.isActive()) {
            return 0L;
        }
        long toWrite = this.bytesToWrite();
        if (toWrite < 1L) {
            if (Buffers.remaining((Buffer[])srcs) == 0L) {
                return 0L;
            }
            throw new FixedLengthOverflowException();
        }
        ByteBuffer[] bufs = this.composeBuffers(srcs, offset, length);
        int oldLimit = -1;
        long extra = 0L;
        int i = 0;
        int e = 0;
        if (bufs.length == length + 2) {
            i = 1;
            e = bufs.length - 1;
            extra = this.getFrameStart().remaining() + this.getFrameEnd().remaining();
        } else if (bufs.length == length + 1) {
            if (this.frameStartWritten) {
                e = bufs.length - 1;
                extra = this.getFrameEnd().remaining();
            } else {
                i = 1;
                extra = this.getFrameStart().remaining();
            }
        }
        int last = -1;
        while (i < e) {
            ByteBuffer src = bufs[i];
            if (toWrite < (long)src.remaining()) {
                oldLimit = src.limit();
                src.limit((int)toWrite);
                last = i;
                break;
            }
            toWrite -= (long)src.remaining();
            ++i;
        }
        try {
            long result = this.write0(bufs, 0, bufs.length);
            if (result < 1L) {
                long l = result;
                return l;
            }
            if ((result -= extra) < 1L) {
                long l = 0L;
                return l;
            }
            this.written += result;
            long l = result;
            return l;
        }
        finally {
            if (oldLimit != -1) {
                bufs[last].limit(oldLimit);
            }
            this.freeStartAndEndFrame();
        }
    }

    protected long write0(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return this.channel.write(srcs, offset, length);
    }

    public final long write(ByteBuffer[] srcs) throws IOException {
        return this.write(srcs, 0, srcs.length);
    }

    public final int write(ByteBuffer src) throws IOException {
        return (int)this.write(new ByteBuffer[]{src});
    }

    public final long transferFrom(FileChannel src, long position, long count) throws IOException {
        long result;
        this.checkClosed();
        if (!this.isActive()) {
            return 0L;
        }
        long toWrite = this.bytesToWrite();
        if (toWrite < 1L) {
            return -1L;
        }
        if (!this.frameStartWritten) {
            ByteBuffer start = this.getFrameStart();
            while (start.hasRemaining()) {
                int w = this.channel.write(start);
                if (w == 0) {
                    return 0L;
                }
                if (w != -1) continue;
                throw WebSocketMessages.MESSAGES.channelClosed();
            }
            this.freeFrameStart();
        }
        if (toWrite < count) {
            count = toWrite;
        }
        if ((result = this.transferFrom0(src, position, count)) > 0L) {
            this.written += result;
        }
        return result;
    }

    protected long transferFrom0(FileChannel src, long position, long count) throws IOException {
        return this.channel.transferFrom(src, position, count);
    }

    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        this.checkClosed();
        throughBuffer.clear();
        if (!this.isActive()) {
            return 0L;
        }
        long toWrite = this.bytesToWrite();
        if (toWrite < 1L) {
            return -1L;
        }
        if (toWrite < count) {
            count = toWrite;
        }
        return WebSocketUtils.transfer((ReadableByteChannel)source, count, throughBuffer, (WritableByteChannel)((Object)this));
    }

    public boolean isOpen() {
        ChannelState state = this.state;
        return state != ChannelState.CLOSED && state != ChannelState.SHUTDOWN && state != ChannelState.WAITING_SHUTDOWN;
    }

    public boolean supportsOption(Option<?> option) {
        return this.channel.supportsOption(option);
    }

    public <T> T getOption(Option<T> option) throws IOException {
        return (T)this.channel.getOption(option);
    }

    public <T> T setOption(Option<T> option, T value) throws IOException {
        return (T)this.channel.setOption(option, value);
    }

    public ChannelListener.Setter<? extends StreamSinkChannel> getCloseSetter() {
        return this.closeSetter;
    }

    public synchronized void suspendWrites() {
        this.writesSuspended = true;
        ChannelState state = this.state;
        if (state == ChannelState.ACTIVE || state == ChannelState.SHUTDOWN) {
            this.channel.suspendWrites();
        }
    }

    public synchronized void resumeWrites() {
        this.writesSuspended = false;
        ChannelState state = stateUpdater.get(this);
        if (state == ChannelState.ACTIVE || state == ChannelState.SHUTDOWN) {
            this.channel.resumeWrites();
        } else if (state == ChannelState.CLOSED) {
            this.queueWriteListener();
        }
    }

    protected final boolean isActive() {
        ChannelState state = this.state;
        return state != ChannelState.WAITING && state != ChannelState.WAITING_SHUTDOWN;
    }

    public boolean isWriteResumed() {
        return !this.writesSuspended;
    }

    public void wakeupWrites() {
        this.queueWriteListener();
        this.resumeWrites();
    }

    public void shutdownWrites() throws IOException {
        ChannelState newState;
        ChannelState oldState;
        do {
            if ((oldState = this.state) != ChannelState.SHUTDOWN && oldState != ChannelState.CLOSED && oldState != ChannelState.WAITING_SHUTDOWN) continue;
            return;
        } while (stateUpdater.compareAndSet(this, oldState, newState = oldState == ChannelState.WAITING ? ChannelState.WAITING_SHUTDOWN : ChannelState.SHUTDOWN));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitWritable() throws IOException {
        ChannelState currentState = this.state;
        if (currentState == ChannelState.ACTIVE) {
            this.channel.awaitWritable();
        } else if (currentState == ChannelState.WAITING || currentState == ChannelState.WAITING_SHUTDOWN) {
            try {
                Object object = this.writeWaitLock;
                synchronized (object) {
                    while (this.state == ChannelState.WAITING || currentState == ChannelState.WAITING_SHUTDOWN) {
                        ++this.waiters;
                        try {
                            this.writeWaitLock.wait();
                        }
                        finally {
                            --this.waiters;
                        }
                    }
                }
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
                throw new InterruptedIOException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        ChannelState currentState = this.state;
        if (currentState == ChannelState.ACTIVE) {
            this.channel.awaitWritable();
        } else if (currentState == ChannelState.WAITING) {
            try {
                Object object = this.writeWaitLock;
                synchronized (object) {
                    while (this.state == ChannelState.WAITING) {
                        ++this.waiters;
                        try {
                            this.writeWaitLock.wait(timeUnit.toMillis(time));
                        }
                        finally {
                            --this.waiters;
                        }
                    }
                }
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
                throw new InterruptedIOException();
            }
        }
    }

    protected ChannelState getState() {
        return this.state;
    }

    public XnioExecutor getWriteThread() {
        return this.channel.getWriteThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean flush() throws IOException {
        if (!this.isActive()) {
            return false;
        }
        if (this.state == ChannelState.CLOSED) {
            throw WebSocketMessages.MESSAGES.channelClosed();
        }
        boolean flushed = this.flush0();
        if (flushed && this.state == ChannelState.SHUTDOWN) {
            if (this.type == WebSocketFrameType.CLOSE) {
                this.channel.shutdownWrites();
                flushed = this.channel.flush();
                if (!flushed) {
                    return false;
                }
            }
            this.state = ChannelState.CLOSED;
            try {
                this.wsChannel.complete(this);
            }
            finally {
                ChannelListeners.invokeChannelListener((Channel)((Object)this), (ChannelListener)this.closeSetter.get());
            }
        }
        return flushed;
    }

    protected final long bytesToWrite() {
        return this.payloadSize - this.written;
    }

    protected final void checkClosed() throws IOException {
        ChannelState state = this.state;
        if (state == ChannelState.CLOSED || state == ChannelState.SHUTDOWN || state == ChannelState.WAITING_SHUTDOWN) {
            throw WebSocketMessages.MESSAGES.channelClosed();
        }
    }

    public WebSocketChannel getWebSocketChannel() {
        return this.wsChannel;
    }

    protected static enum ChannelState {
        WAITING,
        WAITING_SHUTDOWN,
        ACTIVE,
        SHUTDOWN,
        CLOSED;

    }
}

