/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core;

import io.undertow.conduits.IdleTimeoutConduit;
import io.undertow.websockets.core.CloseMessage;
import io.undertow.websockets.core.FragmentedMessageChannel;
import io.undertow.websockets.core.SendChannel;
import io.undertow.websockets.core.StreamSinkFrameChannel;
import io.undertow.websockets.core.StreamSourceFrameChannel;
import io.undertow.websockets.core.WebSocketException;
import io.undertow.websockets.core.WebSocketFrameType;
import io.undertow.websockets.core.WebSocketLogger;
import io.undertow.websockets.core.WebSocketMessages;
import io.undertow.websockets.core.WebSocketVersion;
import io.undertow.websockets.core.WebSockets;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.StreamConnection;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.ConnectedChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.PushBackStreamSourceConduit;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.StreamSourceConduit;

public abstract class WebSocketChannel
implements ConnectedChannel {
    private final boolean client;
    private final Queue<SendChannel> senders = new ArrayDeque<SendChannel>();
    private final StreamConnection channel;
    private final IdleTimeoutConduit idleTimeoutConduit;
    private final WebSocketVersion version;
    private final String wsUrl;
    private final ChannelListener.SimpleSetter<WebSocketChannel> closeSetter;
    private final ChannelListener.SimpleSetter<WebSocketChannel> receiveSetter;
    private final PushBackStreamSourceConduit pushBackConduit;
    private final Pool<ByteBuffer> bufferPool;
    private volatile StreamSourceFrameChannel receiver;
    private volatile PartialFrame partialFrame;
    private final AtomicBoolean broken = new AtomicBoolean(false);
    private boolean receivesSuspended = true;
    private boolean closeFrameReceived;
    private boolean closeFrameSent;
    private final Set<String> subProtocols;
    private final boolean extensionsSupported;
    private final ConcurrentMap<String, Object> attributes = new ConcurrentHashMap<String, Object>();

    protected WebSocketChannel(StreamConnection connectedStreamChannel, Pool<ByteBuffer> bufferPool, WebSocketVersion version, String wsUrl, Set<String> subProtocols, boolean client, boolean extensionsSupported) {
        this.client = client;
        IdleTimeoutConduit idle = new IdleTimeoutConduit(connectedStreamChannel.getSinkChannel().getConduit(), connectedStreamChannel.getSourceChannel().getConduit());
        connectedStreamChannel.getSourceChannel().setConduit((StreamSourceConduit)idle);
        connectedStreamChannel.getSinkChannel().setConduit((StreamSinkConduit)idle);
        this.idleTimeoutConduit = idle;
        this.channel = connectedStreamChannel;
        this.version = version;
        this.wsUrl = wsUrl;
        this.bufferPool = bufferPool;
        this.extensionsSupported = extensionsSupported;
        this.subProtocols = Collections.unmodifiableSet(subProtocols);
        this.closeSetter = new ChannelListener.SimpleSetter();
        this.receiveSetter = new ChannelListener.SimpleSetter();
        this.channel.getSourceChannel().getReadSetter().set(null);
        this.channel.getSourceChannel().suspendReads();
        this.pushBackConduit = new PushBackStreamSourceConduit(this.channel.getSourceChannel().getConduit());
        this.channel.getSourceChannel().setConduit((StreamSourceConduit)this.pushBackConduit);
        this.channel.getSourceChannel().getReadSetter().set((ChannelListener)new WebSocketReadListener());
        connectedStreamChannel.getSinkChannel().getWriteSetter().set((ChannelListener)new WebSocketWriteListener());
        connectedStreamChannel.getSinkChannel().getCloseSetter().set((ChannelListener)new WebSocketCloseListener());
    }

    public final boolean setAttribute(String key, Object value) {
        if (value == null) {
            return this.attributes.remove(key) != null;
        }
        return this.attributes.putIfAbsent(key, value) == null;
    }

    public final Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public boolean areExtensionsSupported() {
        return this.extensionsSupported;
    }

    public Set<String> getSubProtocols() {
        return this.subProtocols;
    }

    public Pool<ByteBuffer> getBufferPool() {
        return this.bufferPool;
    }

    private boolean isActive(StreamSinkFrameChannel channel) {
        SendChannel sender = this.senders.peek();
        if (sender == channel) {
            return true;
        }
        if (sender instanceof FragmentedMessageChannelImpl) {
            return ((FragmentedMessageChannelImpl)sender).isActive(channel);
        }
        return false;
    }

    public SocketAddress getLocalAddress() {
        return this.channel.getLocalAddress();
    }

    public <A extends SocketAddress> A getLocalAddress(Class<A> type) {
        return (A)this.channel.getLocalAddress(type);
    }

    public XnioWorker getWorker() {
        return this.channel.getWorker();
    }

    public XnioIoThread getIoThread() {
        return this.channel.getIoThread();
    }

    public boolean supportsOption(Option<?> option) {
        return this.channel.supportsOption(option);
    }

    public <T> T getOption(Option<T> option) throws IOException {
        return (T)this.channel.getOption(option);
    }

    public <T> T setOption(Option<T> option, T value) throws IOException {
        return (T)this.channel.setOption(option, value);
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public boolean isCloseFrameReceived() {
        return this.closeFrameReceived;
    }

    public boolean isCloseFrameSent() {
        return this.closeFrameSent;
    }

    public SocketAddress getPeerAddress() {
        return this.channel.getPeerAddress();
    }

    public <A extends SocketAddress> A getPeerAddress(Class<A> type) {
        return (A)this.channel.getPeerAddress(type);
    }

    public String getRequestScheme() {
        if (this.getUrl().startsWith("wss:")) {
            return "wss";
        }
        return "ws";
    }

    public boolean isSecure() {
        return "wss".equals(this.getRequestScheme());
    }

    public String getUrl() {
        return this.wsUrl;
    }

    public WebSocketVersion getVersion() {
        return this.version;
    }

    public InetSocketAddress getSourceAddress() {
        return this.getPeerAddress(InetSocketAddress.class);
    }

    public InetSocketAddress getDestinationAddress() {
        return this.getLocalAddress(InetSocketAddress.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamSourceFrameChannel receive() throws IOException {
        if (this.receiver != null) {
            return null;
        }
        Pooled pooled = this.getBufferPool().allocate();
        ByteBuffer buffer = (ByteBuffer)pooled.getResource();
        boolean free = true;
        try {
            if (this.closeFrameReceived) {
                StreamSourceFrameChannel streamSourceFrameChannel = null;
                return streamSourceFrameChannel;
            }
            PartialFrame partialFrame = this.partialFrame;
            if (partialFrame == null) {
                partialFrame = this.partialFrame = this.receiveFrame(new StreamSourceChannelControl());
            }
            while (!partialFrame.isDone()) {
                int res;
                buffer.clear();
                try {
                    res = this.channel.getSourceChannel().read(buffer);
                }
                catch (IOException e) {
                    if (WebSocketLogger.REQUEST_LOGGER.isDebugEnabled()) {
                        WebSocketLogger.REQUEST_LOGGER.debugf(e, "Connection closed with IOException", new Object[0]);
                    }
                    IoUtils.safeClose((Closeable)this.channel.getSourceChannel());
                    throw e;
                }
                if (res == 0) {
                    StreamSourceFrameChannel e = null;
                    return e;
                }
                if (res == -1) {
                    try {
                        this.channel.getSourceChannel().shutdownReads();
                    }
                    catch (IOException e) {
                        if (WebSocketLogger.REQUEST_LOGGER.isDebugEnabled()) {
                            WebSocketLogger.REQUEST_LOGGER.debugf(e, "Connection closed with IOException when attempting to shut down reads", new Object[0]);
                        }
                        IoUtils.safeClose((Closeable)this.channel.getSourceChannel());
                        throw e;
                    }
                    throw WebSocketMessages.MESSAGES.channelClosed();
                }
                buffer.flip();
                try {
                    partialFrame.handle(buffer, this.channel, this.pushBackConduit);
                }
                catch (WebSocketException e) {
                    if (WebSocketLogger.REQUEST_LOGGER.isDebugEnabled()) {
                        WebSocketLogger.REQUEST_LOGGER.debugf(e, "receive failed due to Exception", new Object[0]);
                    }
                    WebSockets.sendClose(new CloseMessage(1002, e.getMessage()).toByteBuffer(), this, null);
                    throw new IOException(e);
                }
            }
            if (buffer.hasRemaining()) {
                this.pushBackConduit.pushBack(pooled);
                free = false;
            }
            this.channel.getSourceChannel().suspendReads();
            this.partialFrame = null;
            this.receiver = partialFrame.getChannel();
            if (this.receiver.getType() == WebSocketFrameType.CLOSE) {
                this.closeFrameReceived = true;
            }
            StreamSourceFrameChannel streamSourceFrameChannel = this.receiver;
            return streamSourceFrameChannel;
        }
        finally {
            if (free) {
                pooled.free();
            }
        }
    }

    public ChannelListener.Setter<WebSocketChannel> getReceiveSetter() {
        return this.receiveSetter;
    }

    public synchronized void suspendReceives() {
        this.receivesSuspended = true;
        if (this.receiver == null) {
            this.channel.getSourceChannel().suspendReads();
        }
    }

    public boolean isClient() {
        return this.client;
    }

    public synchronized void resumeReceives() {
        this.receivesSuspended = false;
        if (this.receiver == null) {
            this.channel.getSourceChannel().resumeReads();
        }
    }

    public void close() throws IOException {
        IoUtils.safeClose((Closeable)this.channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final StreamSinkFrameChannel send(WebSocketFrameType type, long payloadSize) throws IOException {
        if (payloadSize < 0L) {
            throw WebSocketMessages.MESSAGES.negativePayloadLength();
        }
        if (this.broken.get()) {
            throw WebSocketMessages.MESSAGES.streamIsBroken();
        }
        StreamSinkFrameChannel ch = this.createStreamSinkChannel((StreamSinkChannel)this.channel.getSinkChannel(), type, payloadSize);
        WebSocketChannel webSocketChannel = this;
        synchronized (webSocketChannel) {
            if (type == WebSocketFrameType.PING || type == WebSocketFrameType.PONG || type == WebSocketFrameType.CLOSE) {
                SendChannel sch = this.senders.peek();
                if (sch instanceof FragmentedMessageChannelImpl) {
                    ((FragmentedMessageChannelImpl)sch).fragmentedSenders.add(ch);
                } else {
                    this.senders.add(ch);
                }
            } else {
                this.senders.add(ch);
            }
            if (this.isActive(ch)) {
                ch.activate();
            }
            return ch;
        }
    }

    public final synchronized FragmentedMessageChannel sendFragmentedText() {
        FragmentedMessageChannelImpl fragmentedMessageChannel = new FragmentedMessageChannelImpl(WebSocketFrameType.TEXT);
        this.senders.add(fragmentedMessageChannel);
        return fragmentedMessageChannel;
    }

    public final synchronized FragmentedMessageChannel sendFragmentedBinary() {
        FragmentedMessageChannelImpl fragmentedMessageChannel = new FragmentedMessageChannelImpl(WebSocketFrameType.BINARY);
        this.senders.add(fragmentedMessageChannel);
        return fragmentedMessageChannel;
    }

    public void sendClose() throws IOException {
        StreamSinkFrameChannel closeChannel = this.send(WebSocketFrameType.CLOSE, 0L);
        closeChannel.shutdownWrites();
        if (!closeChannel.flush()) {
            closeChannel.getWriteSetter().set(ChannelListeners.flushingChannelListener(null, (ChannelExceptionHandler)new ChannelExceptionHandler<StreamSinkFrameChannel>(){

                public void handleException(StreamSinkFrameChannel channel, IOException exception) {
                    IoUtils.safeClose((Closeable)((Object)WebSocketChannel.this));
                }
            }));
        }
    }

    public ChannelListener.Setter<? extends WebSocketChannel> getCloseSetter() {
        return this.closeSetter;
    }

    protected abstract PartialFrame receiveFrame(StreamSourceChannelControl var1);

    protected abstract StreamSinkFrameChannel createStreamSinkChannel(StreamSinkChannel var1, WebSocketFrameType var2, long var3);

    final synchronized void complete(StreamSinkFrameChannel channel) {
        boolean active = this.isActive(channel);
        if (this.senders.peek() == channel) {
            this.senders.remove(channel);
        } else {
            FragmentedMessageChannelImpl fragmented = (FragmentedMessageChannelImpl)this.senders.peek();
            if (fragmented != null && fragmented.remove(channel)) {
                this.senders.remove(fragmented);
            }
        }
        if (active) {
            if (channel.getType() == WebSocketFrameType.CLOSE) {
                this.closeFrameSent = true;
                IoUtils.safeClose((Closeable)this.channel.getSinkChannel());
            } else {
                SendChannel ch = this.senders.peek();
                if (ch != null) {
                    if (ch instanceof StreamSinkFrameChannel) {
                        ((StreamSinkFrameChannel)ch).activate();
                    } else if (ch instanceof FragmentedMessageChannelImpl) {
                        ((FragmentedMessageChannelImpl)ch).activate();
                    }
                } else {
                    WebSocketLogger.REQUEST_LOGGER.debugf("Suspending writes on %s in complete method as there is no new sender", new Object[0]);
                    channel.suspendWrites();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markBroken() {
        if (this.broken.compareAndSet(false, true)) {
            IoUtils.safeClose((Closeable)this.channel.getSourceChannel());
            StreamSourceFrameChannel receiver = this.receiver;
            if (receiver != null && receiver.isReadResumed()) {
                receiver.queueListener((ChannelListener<StreamSourceFrameChannel>)receiver.getReadSetter().get());
            }
            WebSocketChannel webSocketChannel = this;
            synchronized (webSocketChannel) {
                for (SendChannel channel : this.senders) {
                    if (channel instanceof StreamSinkFrameChannel) {
                        ((StreamSinkFrameChannel)channel).activate();
                        continue;
                    }
                    if (!(channel instanceof FragmentedMessageChannelImpl)) continue;
                    ((FragmentedMessageChannelImpl)channel).activate();
                }
            }
        }
    }

    public void setIdleTimeout(long timeout) {
        this.idleTimeoutConduit.setIdleTimeout(timeout);
    }

    public long getIdleTimeout() {
        return this.idleTimeoutConduit.getIdleTimeout();
    }

    private final class FragmentedMessageChannelImpl
    implements FragmentedMessageChannel {
        private final WebSocketFrameType type;
        private boolean first = true;
        private boolean finalSent;
        private final Queue<StreamSinkFrameChannel> fragmentedSenders = new ArrayDeque<StreamSinkFrameChannel>();

        public FragmentedMessageChannelImpl(WebSocketFrameType type) {
            this.type = type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public StreamSinkFrameChannel send(long payloadSize, boolean finalFrame) throws IOException {
            WebSocketFrameType type;
            FragmentedMessageChannelImpl fragmentedMessageChannelImpl = this;
            synchronized (fragmentedMessageChannelImpl) {
                if (this.finalSent) {
                    throw WebSocketMessages.MESSAGES.fragmentedSenderCompleteAlready();
                }
                if (payloadSize < 0L) {
                    throw WebSocketMessages.MESSAGES.negativePayloadLength();
                }
                if (WebSocketChannel.this.broken.get()) {
                    throw WebSocketMessages.MESSAGES.streamIsBroken();
                }
                if (finalFrame) {
                    this.finalSent = true;
                }
                if (this.first) {
                    this.first = false;
                    type = this.type;
                } else {
                    type = WebSocketFrameType.CONTINUATION;
                }
            }
            StreamSinkFrameChannel sink = WebSocketChannel.this.createStreamSinkChannel((StreamSinkChannel)WebSocketChannel.this.channel.getSinkChannel(), type, payloadSize);
            sink.setFinalFragment(finalFrame);
            WebSocketChannel webSocketChannel = WebSocketChannel.this;
            synchronized (webSocketChannel) {
                this.fragmentedSenders.add(sink);
                if (WebSocketChannel.this.senders.peek() == this && this.isActive(sink)) {
                    sink.activate();
                }
            }
            return sink;
        }

        @Override
        public WebSocketChannel getWebSocketChannel() {
            return WebSocketChannel.this;
        }

        boolean isActive(StreamSinkFrameChannel channel) {
            return this.fragmentedSenders.peek() == channel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void activate() {
            WebSocketChannel webSocketChannel = WebSocketChannel.this;
            synchronized (webSocketChannel) {
                StreamSinkFrameChannel ch = this.fragmentedSenders.peek();
                if (ch != null) {
                    ch.activate();
                }
            }
        }

        boolean remove(StreamSinkFrameChannel channel) {
            this.fragmentedSenders.remove(channel);
            return this.finalSent && this.fragmentedSenders.isEmpty();
        }
    }

    public class StreamSourceChannelControl {
        private StreamSourceChannelControl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readFrameDone(StreamSourceFrameChannel channel) {
            if (channel.getType() == WebSocketFrameType.CLOSE) {
                IoUtils.safeClose((Closeable)WebSocketChannel.this.channel.getSourceChannel());
                if (WebSocketChannel.this.isCloseFrameSent()) {
                    IoUtils.safeClose((Closeable)WebSocketChannel.this.channel.getSinkChannel());
                }
            }
            WebSocketChannel webSocketChannel = WebSocketChannel.this;
            synchronized (webSocketChannel) {
                if (channel == WebSocketChannel.this.receiver) {
                    WebSocketChannel.this.receiver = null;
                    if (WebSocketChannel.this.receivesSuspended) {
                        WebSocketChannel.this.channel.getSourceChannel().suspendReads();
                    } else {
                        WebSocketChannel.this.channel.getSourceChannel().resumeReads();
                    }
                }
            }
        }
    }

    public static interface PartialFrame {
        public StreamSourceFrameChannel getChannel();

        public void handle(ByteBuffer var1, StreamConnection var2, PushBackStreamSourceConduit var3) throws WebSocketException;

        public boolean isDone();
    }

    private class WebSocketCloseListener
    implements ChannelListener<StreamSinkChannel> {
        private WebSocketCloseListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEvent(StreamSinkChannel c) {
            StreamSourceFrameChannel receiver = WebSocketChannel.this.receiver;
            if (receiver != null && receiver.isOpen() && receiver.isReadResumed()) {
                ChannelListeners.invokeChannelListener((Channel)((Object)receiver), (ChannelListener)receiver.getReadSetter().get());
            }
            WebSocketChannel webSocketChannel = WebSocketChannel.this;
            synchronized (webSocketChannel) {
                for (SendChannel channel : WebSocketChannel.this.senders) {
                    if (channel instanceof StreamSinkFrameChannel) {
                        ((StreamSinkFrameChannel)channel).activate();
                        continue;
                    }
                    if (!(channel instanceof FragmentedMessageChannelImpl)) continue;
                    ((FragmentedMessageChannelImpl)channel).activate();
                }
            }
            ChannelListeners.invokeChannelListener((Channel)((Object)WebSocketChannel.this), (ChannelListener)WebSocketChannel.this.closeSetter.get());
        }
    }

    private class WebSocketWriteListener
    implements ChannelListener<StreamSinkChannel> {
        private WebSocketWriteListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEvent(StreamSinkChannel channel) {
            WebSocketChannel webSocketChannel;
            SendChannel ch = null;
            while (true) {
                StreamSinkFrameChannel sink;
                SendChannel oldCh = ch;
                boolean writeResumed = false;
                webSocketChannel = WebSocketChannel.this;
                synchronized (webSocketChannel) {
                    ch = (SendChannel)WebSocketChannel.this.senders.peek();
                    if (ch != null) {
                        if (ch instanceof FragmentedMessageChannelImpl) {
                            FragmentedMessageChannelImpl fragmented = (FragmentedMessageChannelImpl)ch;
                            sink = (StreamSinkFrameChannel)fragmented.fragmentedSenders.peek();
                            if (sink != null) {
                                writeResumed = sink.isWriteResumed();
                            }
                        } else if (ch instanceof StreamSinkFrameChannel) {
                            sink = (StreamSinkFrameChannel)ch;
                            writeResumed = ((StreamSinkFrameChannel)ch).isWriteResumed();
                        } else {
                            sink = null;
                        }
                    } else {
                        sink = null;
                    }
                }
                if (ch == null || ch == oldCh) break;
                if (!writeResumed) {
                    return;
                }
                ChannelListener channelListener = sink.getWriteSetter().get();
                WebSocketLogger.REQUEST_LOGGER.debugf("Invoking write listener %s on %s", channelListener, sink);
                ChannelListeners.invokeChannelListener((Channel)((Object)sink), (ChannelListener)channelListener);
            }
            if (ch == null) {
                webSocketChannel = WebSocketChannel.this;
                synchronized (webSocketChannel) {
                    SendChannel sendChannel = (SendChannel)WebSocketChannel.this.senders.peek();
                    if (sendChannel == null || sendChannel instanceof FragmentedMessageChannelImpl && ((FragmentedMessageChannelImpl)sendChannel).fragmentedSenders.peek() == null) {
                        WebSocketLogger.REQUEST_LOGGER.debugf("Suspending writes on channel %s due to no sender", WebSocketChannel.this);
                        channel.suspendWrites();
                    }
                }
                return;
            }
        }
    }

    private final class WebSocketReadListener
    implements ChannelListener<StreamSourceChannel> {
        private WebSocketReadListener() {
        }

        public void handleEvent(StreamSourceChannel channel) {
            StreamSourceFrameChannel receiver = WebSocketChannel.this.receiver;
            if (receiver != null) {
                ChannelListener listener = receiver.getReadSetter().get();
                if (listener != null) {
                    WebSocketLogger.REQUEST_LOGGER.debugf("Invoking read listener %s on %s", listener, receiver);
                    ChannelListeners.invokeChannelListener((Channel)((Object)receiver), (ChannelListener)listener);
                } else {
                    WebSocketLogger.REQUEST_LOGGER.debugf("Suspending reads on channel %s due to no listener", receiver);
                    channel.suspendReads();
                }
            } else if (WebSocketChannel.this.closeFrameReceived || WebSocketChannel.this.receivesSuspended) {
                channel.suspendReads();
            } else {
                ChannelListener listener = WebSocketChannel.this.receiveSetter.get();
                if (listener != null) {
                    WebSocketLogger.REQUEST_LOGGER.debugf("Invoking receive listener", receiver);
                    ChannelListeners.invokeChannelListener((Channel)((Object)WebSocketChannel.this), (ChannelListener)listener);
                } else {
                    channel.suspendReads();
                }
            }
        }
    }
}

