/*
 * Decompiled with CFR 0.152.
 */
package io.undertow;

import io.undertow.UndertowMessages;
import io.undertow.UndertowOptions;
import io.undertow.ajp.AjpOpenListener;
import io.undertow.security.api.AuthenticationMode;
import io.undertow.security.api.GSSAPIServerSubjectFactory;
import io.undertow.security.idm.IdentityManager;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpOpenListener;
import io.undertow.server.OpenListener;
import java.net.Inet4Address;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.xnio.BufferAllocator;
import org.xnio.ByteBufferSlicePool;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Pool;
import org.xnio.StreamConnection;
import org.xnio.Xnio;
import org.xnio.XnioWorker;
import org.xnio.channels.AcceptingChannel;
import org.xnio.ssl.XnioSsl;

public class Undertow {
    private final int bufferSize;
    private final int buffersPerRegion;
    private final int ioThreads;
    private final int workerThreads;
    private final boolean directBuffers;
    private final List<ListenerConfig> listeners = new ArrayList<ListenerConfig>();
    private final HttpHandler rootHandler;
    private final OptionMap workerOptions;
    private final OptionMap socketOptions;
    private final OptionMap serverOptions;
    private XnioWorker worker;
    private List<AcceptingChannel<? extends StreamConnection>> channels;
    private Xnio xnio;

    private Undertow(Builder builder) {
        this.bufferSize = builder.bufferSize;
        this.buffersPerRegion = builder.buffersPerRegion;
        this.ioThreads = builder.ioThreads;
        this.workerThreads = builder.workerThreads;
        this.directBuffers = builder.directBuffers;
        this.listeners.addAll(builder.listeners);
        this.rootHandler = builder.handler;
        this.workerOptions = builder.workerOptions.getMap();
        this.socketOptions = builder.socketOptions.getMap();
        this.serverOptions = builder.serverOptions.getMap();
    }

    public static Builder builder() {
        return new Builder();
    }

    public synchronized void start() {
        this.xnio = Xnio.getInstance((String)"nio", (ClassLoader)Undertow.class.getClassLoader());
        this.channels = new ArrayList<AcceptingChannel<? extends StreamConnection>>();
        try {
            this.worker = this.xnio.createWorker(OptionMap.builder().set(Options.WORKER_IO_THREADS, this.ioThreads).set(Options.CONNECTION_HIGH_WATER, 1000000).set(Options.CONNECTION_LOW_WATER, 1000000).set(Options.WORKER_TASK_CORE_THREADS, this.workerThreads).set(Options.WORKER_TASK_MAX_THREADS, this.workerThreads).set(Options.TCP_NODELAY, true).set(Options.CORK, true).addAll(this.workerOptions).getMap());
            OptionMap socketOptions = OptionMap.builder().set(Options.WORKER_IO_THREADS, this.ioThreads).set(Options.TCP_NODELAY, true).set(Options.REUSE_ADDRESSES, true).addAll(this.socketOptions).getMap();
            ByteBufferSlicePool buffers = new ByteBufferSlicePool(this.directBuffers ? BufferAllocator.DIRECT_BYTE_BUFFER_ALLOCATOR : BufferAllocator.BYTE_BUFFER_ALLOCATOR, this.bufferSize, this.bufferSize * this.buffersPerRegion);
            for (ListenerConfig listener : this.listeners) {
                AcceptingChannel server;
                ChannelListener acceptListener;
                OpenListener openListener;
                if (listener.type == ListenerType.AJP) {
                    openListener = new AjpOpenListener((Pool<ByteBuffer>)buffers, this.serverOptions, this.bufferSize);
                    ((AjpOpenListener)openListener).setRootHandler(this.rootHandler);
                    acceptListener = ChannelListeners.openListenerAdapter((ChannelListener)openListener);
                    server = this.worker.createStreamConnectionServer((SocketAddress)new InetSocketAddress(Inet4Address.getByName(listener.host), listener.port), acceptListener, socketOptions);
                    server.resumeAccepts();
                    this.channels.add((AcceptingChannel<? extends StreamConnection>)server);
                    continue;
                }
                if (listener.type == ListenerType.HTTP) {
                    openListener = new HttpOpenListener((Pool<ByteBuffer>)buffers, OptionMap.builder().set(UndertowOptions.BUFFER_PIPELINED_DATA, true).addAll(this.serverOptions).getMap(), this.bufferSize);
                    ((HttpOpenListener)openListener).setRootHandler(this.rootHandler);
                    acceptListener = ChannelListeners.openListenerAdapter((ChannelListener)openListener);
                    server = this.worker.createStreamConnectionServer((SocketAddress)new InetSocketAddress(Inet4Address.getByName(listener.host), listener.port), acceptListener, socketOptions);
                    server.resumeAccepts();
                    this.channels.add((AcceptingChannel<? extends StreamConnection>)server);
                    continue;
                }
                if (listener.type != ListenerType.HTTPS) continue;
                openListener = new HttpOpenListener((Pool<ByteBuffer>)buffers, OptionMap.builder().set(UndertowOptions.BUFFER_PIPELINED_DATA, true).addAll(this.serverOptions).getMap(), this.bufferSize);
                ((HttpOpenListener)openListener).setRootHandler(this.rootHandler);
                acceptListener = ChannelListeners.openListenerAdapter((ChannelListener)openListener);
                XnioSsl xnioSsl = this.xnio.getSslProvider(OptionMap.create((Option)Options.USE_DIRECT_BUFFERS, (Object)true));
                AcceptingChannel sslServer = xnioSsl.createSslConnectionServer(this.worker, new InetSocketAddress(Inet4Address.getByName(listener.host), listener.port), acceptListener, socketOptions);
                sslServer.resumeAccepts();
                this.channels.add((AcceptingChannel<? extends StreamConnection>)sslServer);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void stop() {
        for (AcceptingChannel<? extends StreamConnection> channel : this.channels) {
            IoUtils.safeClose(channel);
        }
        this.channels = null;
        this.worker.shutdownNow();
        this.worker = null;
        this.xnio = null;
    }

    public static final class Builder {
        private int bufferSize;
        private int buffersPerRegion;
        private int ioThreads;
        private int workerThreads;
        private boolean directBuffers;
        private final List<ListenerConfig> listeners = new ArrayList<ListenerConfig>();
        private HttpHandler handler;
        private final OptionMap.Builder workerOptions = OptionMap.builder();
        private final OptionMap.Builder socketOptions = OptionMap.builder();
        private final OptionMap.Builder serverOptions = OptionMap.builder();

        private Builder() {
            this.ioThreads = Runtime.getRuntime().availableProcessors();
            this.workerThreads = this.ioThreads * 8;
            long maxMemory = Runtime.getRuntime().maxMemory();
            if (maxMemory < 0x4000000L) {
                this.directBuffers = false;
                this.bufferSize = 512;
                this.buffersPerRegion = 10;
            } else if (maxMemory < 0x8000000L) {
                this.directBuffers = true;
                this.bufferSize = 1024;
                this.buffersPerRegion = 10;
            } else {
                this.directBuffers = true;
                this.bufferSize = 4096;
                this.buffersPerRegion = 20;
            }
        }

        public Undertow build() {
            return new Undertow(this);
        }

        public Builder addListener(int port, String host) {
            this.listeners.add(new ListenerConfig(ListenerType.HTTP, port, host));
            return this;
        }

        public Builder setBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        public Builder setBuffersPerRegion(int buffersPerRegion) {
            this.buffersPerRegion = buffersPerRegion;
            return this;
        }

        public Builder setIoThreads(int ioThreads) {
            this.ioThreads = ioThreads;
            return this;
        }

        public Builder setWorkerThreads(int workerThreads) {
            this.workerThreads = workerThreads;
            return this;
        }

        public Builder setDirectBuffers(boolean directBuffers) {
            this.directBuffers = directBuffers;
            return this;
        }

        public Builder setHandler(HttpHandler handler) {
            this.handler = handler;
            return this;
        }

        public <T> Builder setServerOption(Option<T> option, T value) {
            this.serverOptions.set(option, value);
            return this;
        }

        public <T> Builder setSocketOption(Option<T> option, T value) {
            this.socketOptions.set(option, value);
            return this;
        }

        public <T> Builder setWorkerOption(Option<T> option, T value) {
            this.workerOptions.set(option, value);
            return this;
        }
    }

    public static class LoginConfig {
        private final IdentityManager identityManager;
        private boolean basic;
        private boolean digest;
        private boolean kerberos;
        private boolean form;
        private String realmName;
        private String errorPage;
        private String loginPage;
        private GSSAPIServerSubjectFactory subjectFactory;
        private AuthenticationMode authenticationMode = AuthenticationMode.PRO_ACTIVE;

        public LoginConfig(IdentityManager identityManager) {
            this.identityManager = identityManager;
        }

        public LoginConfig basicAuth(String realmName) {
            if (this.digest) {
                throw UndertowMessages.MESSAGES.authTypeCannotBeCombined("basic", "digest");
            }
            if (this.form) {
                throw UndertowMessages.MESSAGES.authTypeCannotBeCombined("basic", "form");
            }
            this.basic = true;
            this.realmName = realmName;
            return this;
        }

        public LoginConfig digestAuth(String realmName) {
            if (this.basic) {
                throw UndertowMessages.MESSAGES.authTypeCannotBeCombined("digest", "basic");
            }
            if (this.form) {
                throw UndertowMessages.MESSAGES.authTypeCannotBeCombined("digest", "form");
            }
            this.digest = true;
            this.realmName = realmName;
            return this;
        }

        public LoginConfig kerberosAuth(GSSAPIServerSubjectFactory subjectFactory) {
            this.kerberos = true;
            this.subjectFactory = subjectFactory;
            return this;
        }

        public LoginConfig formAuth(String loginPage, String errorPage) {
            if (this.digest) {
                throw UndertowMessages.MESSAGES.authTypeCannotBeCombined("form", "digest");
            }
            if (this.basic) {
                throw UndertowMessages.MESSAGES.authTypeCannotBeCombined("form", "basic");
            }
            this.loginPage = loginPage;
            this.errorPage = errorPage;
            this.form = true;
            return this;
        }

        public LoginConfig setAuthenticationMode(AuthenticationMode authenticationMode) {
            this.authenticationMode = authenticationMode;
            return this;
        }
    }

    private static class ListenerConfig {
        final ListenerType type;
        final int port;
        final String host;

        private ListenerConfig(ListenerType type, int port, String host) {
            this.type = type;
            this.port = port;
            this.host = host;
        }
    }

    public static enum ListenerType {
        HTTP,
        HTTPS,
        AJP;

    }
}

