/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.builder;

import io.undertow.UndertowMessages;
import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeParser;
import io.undertow.attribute.ExchangeAttributes;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.handlers.builder.HandlerBuilder;
import java.lang.reflect.Array;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;

public class HandlerParser {
    public static final HandlerWrapper parse(String string, ClassLoader classLoader) {
        Map<String, HandlerBuilder> builders = HandlerParser.loadBuilders(classLoader);
        ExchangeAttributeParser attributeParser = ExchangeAttributes.parser(classLoader);
        return HandlerParser.parse(string, builders, attributeParser);
    }

    private static Map<String, HandlerBuilder> loadBuilders(ClassLoader classLoader) {
        ServiceLoader<HandlerBuilder> loader = ServiceLoader.load(HandlerBuilder.class, classLoader);
        HashMap<String, HandlerBuilder> ret = new HashMap<String, HandlerBuilder>();
        for (HandlerBuilder builder : loader) {
            if (ret.containsKey(builder.name())) {
                if (((HandlerBuilder)ret.get(builder.name())).getClass() == builder.getClass()) continue;
                throw UndertowMessages.MESSAGES.moreThanOneHandlerWithName(builder.name(), builder.getClass(), ((HandlerBuilder)ret.get(builder.name())).getClass());
            }
            ret.put(builder.name(), builder);
        }
        return ret;
    }

    private static IllegalStateException error(String string, int pos, String reason) {
        StringBuilder b = new StringBuilder();
        b.append(string);
        b.append('\n');
        for (int i = 0; i < pos; ++i) {
            b.append(' ');
        }
        b.append('^');
        throw UndertowMessages.MESSAGES.errorParsingHandlerString(reason, b.toString());
    }

    static HandlerWrapper parse(String string, Map<String, HandlerBuilder> builders, ExchangeAttributeParser attributeParser) {
        Deque<Token> tokens = HandlerParser.tokenize(string);
        return HandlerParser.parseBuilder(string, tokens.pop(), tokens, builders, attributeParser);
    }

    private static HandlerWrapper parseBuilder(String string, Token token, Deque<Token> tokens, Map<String, HandlerBuilder> builders, ExchangeAttributeParser attributeParser) {
        HandlerBuilder builder = builders.get(token.token);
        if (builder == null) {
            throw HandlerParser.error(string, token.position, "no predicate named " + token.token);
        }
        Token next = tokens.peek();
        if (next.token.equals("[")) {
            HashMap<String, Object> values = new HashMap<String, Object>();
            tokens.poll();
            next = tokens.poll();
            if (next == null) {
                throw HandlerParser.error(string, string.length(), "Unexpected end of input");
            }
            if (next.token.equals("{")) {
                return HandlerParser.handleSingleArrayValue(string, builder, tokens, next, attributeParser);
            }
            while (!next.token.equals("]")) {
                Token equals = tokens.poll();
                if (!equals.token.equals("=")) {
                    if (equals.token.equals("]") && values.isEmpty()) {
                        return HandlerParser.handleSingleValue(string, builder, next, attributeParser);
                    }
                    if (equals.token.equals(",")) {
                        tokens.push(equals);
                        tokens.push(next);
                        return HandlerParser.handleSingleVarArgsValue(string, builder, tokens, next, attributeParser);
                    }
                    throw HandlerParser.error(string, equals.position, "Unexpected token");
                }
                Token value = tokens.poll();
                if (value == null) {
                    throw HandlerParser.error(string, string.length(), "Unexpected end of input");
                }
                if (value.token.equals("{")) {
                    values.put(next.token, HandlerParser.readArrayType(string, tokens, next, builder, attributeParser, "}"));
                } else {
                    if (HandlerParser.isOperator(value.token) || HandlerParser.isSpecialChar(value.token)) {
                        throw HandlerParser.error(string, value.position, "Unexpected token");
                    }
                    Class<?> type = builder.parameters().get(next.token);
                    if (type == null) {
                        throw HandlerParser.error(string, next.position, "Unexpected parameter " + next.token);
                    }
                    values.put(next.token, HandlerParser.coerceToType(string, value, type, attributeParser));
                }
                next = tokens.poll();
                if (next == null) {
                    throw HandlerParser.error(string, string.length(), "Unexpected end of input");
                }
                if (next.token.equals("]")) continue;
                if (!next.token.equals(",")) {
                    throw HandlerParser.error(string, string.length(), "Expecting , or ]");
                }
                next = tokens.poll();
                if (next != null) continue;
                throw HandlerParser.error(string, string.length(), "Unexpected end of input");
            }
            HandlerParser.checkParameters(string, next.position, values, builder);
            return builder.build(values);
        }
        throw HandlerParser.error(string, next.position, "Unexpected character");
    }

    private static HandlerWrapper handleSingleArrayValue(String string, HandlerBuilder builder, Deque<Token> tokens, Token token, ExchangeAttributeParser attributeParser) {
        String sv = builder.defaultParameter();
        if (sv == null) {
            throw HandlerParser.error(string, token.position, "default parameter not supported");
        }
        Object array = HandlerParser.readArrayType(string, tokens, new Token(sv, token.position), builder, attributeParser, "}");
        Token close = tokens.poll();
        if (!close.token.equals("]")) {
            throw HandlerParser.error(string, close.position, "expected ]");
        }
        return builder.build(Collections.singletonMap(sv, array));
    }

    private static HandlerWrapper handleSingleVarArgsValue(String string, HandlerBuilder builder, Deque<Token> tokens, Token token, ExchangeAttributeParser attributeParser) {
        String sv = builder.defaultParameter();
        if (sv == null) {
            throw HandlerParser.error(string, token.position, "default parameter not supported");
        }
        Object array = HandlerParser.readArrayType(string, tokens, new Token(sv, token.position), builder, attributeParser, "]");
        return builder.build(Collections.singletonMap(sv, array));
    }

    private static Object readArrayType(String string, Deque<Token> tokens, Token paramName, HandlerBuilder builder, ExchangeAttributeParser attributeParser, String expectedEndToken) {
        Class<?> type = builder.parameters().get(paramName.token);
        if (type == null) {
            throw HandlerParser.error(string, paramName.position, "no parameter called " + paramName.token);
        }
        if (!type.isArray()) {
            throw HandlerParser.error(string, paramName.position, "parameter is not an array type " + paramName.token);
        }
        Class<?> componentType = type.getComponentType();
        ArrayList<Object> values = new ArrayList<Object>();
        Token token = tokens.poll();
        while (token != null) {
            Token commaOrEnd = tokens.poll();
            values.add(HandlerParser.coerceToType(string, token, componentType, attributeParser));
            if (commaOrEnd.token.equals(expectedEndToken)) {
                Object array = Array.newInstance(componentType, values.size());
                for (int i = 0; i < values.size(); ++i) {
                    Array.set(array, i, values.get(i));
                }
                return array;
            }
            if (!commaOrEnd.token.equals(",")) {
                throw HandlerParser.error(string, commaOrEnd.position, "expected either , or }");
            }
            token = tokens.poll();
        }
        throw HandlerParser.error(string, string.length(), "unexpected end of input in array");
    }

    private static HandlerWrapper handleSingleValue(String string, HandlerBuilder builder, Token next, ExchangeAttributeParser attributeParser) {
        String sv = builder.defaultParameter();
        if (sv == null) {
            throw HandlerParser.error(string, next.position, "default parameter not supported");
        }
        Map<String, Object> values = Collections.singletonMap(sv, HandlerParser.coerceToType(string, next, builder.parameters().get(sv), attributeParser));
        HandlerParser.checkParameters(string, next.position, values, builder);
        return builder.build(values);
    }

    private static void checkParameters(String string, int pos, Map<String, Object> values, HandlerBuilder builder) {
        HashSet<String> required = new HashSet<String>(builder.requiredParameters());
        for (String key : values.keySet()) {
            required.remove(key);
        }
        if (!required.isEmpty()) {
            throw HandlerParser.error(string, pos, "Missing required parameters " + required);
        }
    }

    private static Object coerceToType(String string, Token token, Class<?> type, ExchangeAttributeParser attributeParser) {
        if (type.isArray()) {
            Object array = Array.newInstance(type.getComponentType(), 1);
            Array.set(array, 0, HandlerParser.coerceToType(string, token, type.getComponentType(), attributeParser));
            return array;
        }
        if (type == String.class) {
            return token.token;
        }
        if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            return Boolean.valueOf(token.token);
        }
        if (type.equals(Byte.class) || type.equals(Byte.TYPE)) {
            return Byte.valueOf(token.token);
        }
        if (type.equals(Character.class) || type.equals(Character.TYPE)) {
            if (token.token.length() != 1) {
                throw HandlerParser.error(string, token.position, "Cannot cooerce " + token.token + " to a Character");
            }
            return Character.valueOf(token.token.charAt(0));
        }
        if (type.equals(Short.class) || type.equals(Short.TYPE)) {
            return Short.valueOf(token.token);
        }
        if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            return Integer.valueOf(token.token);
        }
        if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            return Long.valueOf(token.token);
        }
        if (type.equals(Float.class) || type.equals(Float.TYPE)) {
            return Float.valueOf(token.token);
        }
        if (type.equals(Double.class) || type.equals(Double.TYPE)) {
            return Double.valueOf(token.token);
        }
        if (type.equals(ExchangeAttribute.class)) {
            return attributeParser.parse(token.token);
        }
        return token.token;
    }

    private static int precidence(String operator) {
        if (operator.equals("not")) {
            return 3;
        }
        if (operator.equals("and")) {
            return 2;
        }
        if (operator.equals("or")) {
            return 1;
        }
        throw new IllegalStateException();
    }

    private static boolean isOperator(String op) {
        return op.equals("and") || op.equals("or") || op.equals("not");
    }

    private static boolean isSpecialChar(String token) {
        if (token.length() != 1) {
            return false;
        }
        char c = token.charAt(0);
        switch (c) {
            case '(': 
            case ')': 
            case ',': 
            case '=': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                return true;
            }
        }
        return false;
    }

    static Deque<Token> tokenize(String string) {
        char currentStringDelim = '\u0000';
        boolean inVariable = false;
        StringBuilder current = new StringBuilder();
        ArrayDeque<Token> ret = new ArrayDeque<Token>();
        block6: for (int pos = 0; pos < string.length(); ++pos) {
            char c = string.charAt(pos);
            if (currentStringDelim != '\u0000') {
                if (c == currentStringDelim && current.charAt(current.length() - 1) != '\\') {
                    ret.add(new Token(current.toString(), pos));
                    current.setLength(0);
                    currentStringDelim = '\u0000';
                    continue;
                }
                current.append(c);
                continue;
            }
            switch (c) {
                case '\t': 
                case ' ': {
                    if (current.length() == 0) continue block6;
                    ret.add(new Token(current.toString(), pos));
                    current.setLength(0);
                    continue block6;
                }
                case '(': 
                case ')': 
                case ',': 
                case '=': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    if (inVariable) {
                        current.append(c);
                        if (c != '}') continue block6;
                        inVariable = false;
                        continue block6;
                    }
                    if (current.length() != 0) {
                        ret.add(new Token(current.toString(), pos));
                        current.setLength(0);
                    }
                    ret.add(new Token("" + c, pos));
                    continue block6;
                }
                case '\"': 
                case '\'': {
                    if (current.length() != 0) {
                        throw HandlerParser.error(string, pos, "Unexpected token");
                    }
                    currentStringDelim = c;
                    continue block6;
                }
                case '%': {
                    current.append(c);
                    if (string.charAt(pos + 1) != '{') continue block6;
                    inVariable = true;
                    continue block6;
                }
                default: {
                    current.append(c);
                }
            }
        }
        if (current.length() > 0) {
            ret.add(new Token(current.toString(), string.length()));
        }
        return ret;
    }

    static final class Token {
        final String token;
        final int position;

        private Token(String token, int position) {
            this.token = token;
            this.position = position;
        }
    }
}

