/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.RequestLimit;

public final class RequestLimitingHandler
implements HttpHandler {
    private final HttpHandler nextHandler;
    private final RequestLimit requestLimit;

    public RequestLimitingHandler(int maximumConcurrentRequests, HttpHandler nextHandler) {
        this(maximumConcurrentRequests, -1, nextHandler);
    }

    public RequestLimitingHandler(int maximumConcurrentRequests, int queueSize, HttpHandler nextHandler) {
        if (nextHandler == null) {
            throw new IllegalArgumentException("nextHandler is null");
        }
        if (maximumConcurrentRequests < 1) {
            throw new IllegalArgumentException("Maximum concurrent requests must be at least 1");
        }
        this.requestLimit = new RequestLimit(maximumConcurrentRequests, queueSize);
        this.nextHandler = nextHandler;
    }

    public RequestLimitingHandler(RequestLimit requestLimit, HttpHandler nextHandler) {
        if (nextHandler == null) {
            throw new IllegalArgumentException("nextHandler is null");
        }
        this.requestLimit = requestLimit;
        this.nextHandler = nextHandler;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        this.requestLimit.handleRequest(exchange, this.nextHandler);
    }

    public RequestLimit getRequestLimit() {
        return this.requestLimit;
    }
}

