/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.ajp;

import io.undertow.UndertowLogger;
import io.undertow.UndertowOptions;
import io.undertow.conduits.ConduitListener;
import io.undertow.conduits.EmptyStreamSourceConduit;
import io.undertow.conduits.ReadDataStreamSourceConduit;
import io.undertow.server.AbstractServerConnection;
import io.undertow.server.Connectors;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.protocol.ajp.AjpRequestParseState;
import io.undertow.server.protocol.ajp.AjpRequestParser;
import io.undertow.server.protocol.ajp.AjpServerConnection;
import io.undertow.server.protocol.ajp.AjpServerRequestConduit;
import io.undertow.server.protocol.ajp.AjpServerResponseConduit;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.Pooled;
import org.xnio.StreamConnection;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.channels.SuspendableWriteChannel;
import org.xnio.conduits.ConduitStreamSinkChannel;
import org.xnio.conduits.ConduitStreamSourceChannel;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.StreamSourceConduit;
import org.xnio.conduits.WriteReadyHandler;

final class AjpReadListener
implements ChannelListener<StreamSourceChannel> {
    private static final byte[] CPONG = new byte[]{65, 66, 0, 1, 9};
    private final AjpServerConnection connection;
    private final String scheme;
    private final boolean recordRequestStartTime;
    private AjpRequestParseState state = new AjpRequestParseState();
    private HttpServerExchange httpServerExchange;
    private volatile int read = 0;
    private final int maxRequestSize;
    private final long maxEntitySize;
    private final AjpRequestParser parser;
    private WriteReadyHandler.ChannelListenerHandler<ConduitStreamSinkChannel> writeReadyHandler;

    AjpReadListener(AjpServerConnection connection, String scheme, AjpRequestParser parser) {
        this.connection = connection;
        this.scheme = scheme;
        this.parser = parser;
        this.maxRequestSize = connection.getUndertowOptions().get(UndertowOptions.MAX_HEADER_SIZE, 51200);
        this.maxEntitySize = connection.getUndertowOptions().get(UndertowOptions.MAX_ENTITY_SIZE, 0L);
        this.writeReadyHandler = new WriteReadyHandler.ChannelListenerHandler((SuspendableWriteChannel)connection.getChannel().getSinkChannel());
        this.recordRequestStartTime = connection.getUndertowOptions().get(UndertowOptions.RECORD_REQUEST_START_TIME, false);
    }

    public void startRequest() {
        this.connection.resetChannel();
        this.state = new AjpRequestParseState();
        this.httpServerExchange = new HttpServerExchange(this.connection, this.maxEntitySize);
        this.read = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(StreamSourceChannel channel) {
        if (this.connection.getOriginalSinkConduit().isWriteShutdown() || this.connection.getOriginalSourceConduit().isReadShutdown()) {
            IoUtils.safeClose((Closeable)((Object)this.connection));
            channel.suspendReads();
            return;
        }
        Pooled existing = this.connection.getExtraBytes();
        Pooled pooled = existing == null ? this.connection.getBufferPool().allocate() : existing;
        ByteBuffer buffer = (ByteBuffer)pooled.getResource();
        boolean free = true;
        try {
            do {
                int res;
                if (existing == null) {
                    buffer.clear();
                    try {
                        res = channel.read(buffer);
                    }
                    catch (IOException e) {
                        UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                        IoUtils.safeClose((Closeable)channel);
                        if (free) {
                            pooled.free();
                        }
                        return;
                    }
                } else {
                    res = buffer.remaining();
                }
                if (res == 0) {
                    if (!channel.isReadResumed()) {
                        channel.getReadSetter().set((ChannelListener)this);
                        channel.resumeReads();
                    }
                    return;
                }
                if (res == -1) {
                    try {
                        channel.shutdownReads();
                        ConduitStreamSinkChannel responseChannel = this.connection.getChannel().getSinkChannel();
                        responseChannel.shutdownWrites();
                        IoUtils.safeClose((Closeable)((Object)this.connection));
                    }
                    catch (IOException e) {
                        UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                        IoUtils.safeClose((Closeable)((Object)this.connection));
                        if (free) {
                            pooled.free();
                        }
                        return;
                    }
                    return;
                }
                if (existing != null) {
                    existing = null;
                    this.connection.setExtraBytes(null);
                } else {
                    buffer.flip();
                }
                int begin = buffer.remaining();
                this.parser.parse(buffer, this.state, this.httpServerExchange);
                this.read += begin - buffer.remaining();
                if (buffer.hasRemaining()) {
                    free = false;
                    this.connection.setExtraBytes((Pooled<ByteBuffer>)pooled);
                }
                if (this.read <= this.maxRequestSize) continue;
                UndertowLogger.REQUEST_LOGGER.requestHeaderWasTooLarge(this.connection.getPeerAddress(), this.maxRequestSize);
                IoUtils.safeClose((Closeable)((Object)this.connection));
                return;
            } while (!this.state.isComplete());
            if (this.state.prefix != 2) {
                if (this.state.prefix == 10) {
                    UndertowLogger.REQUEST_LOGGER.debug("Received CPING, sending CPONG");
                    this.handleCPing();
                } else if (this.state.prefix == 9) {
                    UndertowLogger.REQUEST_LOGGER.debug("Received CPONG, starting next request");
                    this.state = new AjpRequestParseState();
                    channel.getReadSetter().set((ChannelListener)this);
                    channel.resumeReads();
                } else {
                    UndertowLogger.REQUEST_LOGGER.ignoringAjpRequestWithPrefixCode(this.state.prefix);
                    IoUtils.safeClose((Closeable)((Object)this.connection));
                }
                return;
            }
            channel.getReadSetter().set(null);
            channel.suspendReads();
            final HttpServerExchange httpServerExchange = this.httpServerExchange;
            AjpServerResponseConduit responseConduit = new AjpServerResponseConduit(this.connection.getChannel().getSinkChannel().getConduit(), this.connection.getBufferPool(), httpServerExchange, (ConduitListener<? super AjpServerResponseConduit>)new ConduitListener<AjpServerResponseConduit>(){

                @Override
                public void handleEvent(AjpServerResponseConduit channel) {
                    Connectors.terminateResponse(httpServerExchange);
                }
            }, httpServerExchange.getRequestMethod().equals(Methods.HEAD));
            this.connection.getChannel().getSinkChannel().setConduit((StreamSinkConduit)responseConduit);
            this.connection.getChannel().getSourceChannel().setConduit(this.createSourceConduit(this.connection.getChannel().getSourceChannel().getConduit(), responseConduit, httpServerExchange));
            responseConduit.setWriteReadyHandler((WriteReadyHandler)this.writeReadyHandler);
            try {
                this.connection.setSSLSessionInfo(this.state.createSslSessionInfo());
                httpServerExchange.setSourceAddress(this.state.createPeerAddress());
                httpServerExchange.setDestinationAddress(this.state.createDestinationAddress());
                if (this.scheme != null) {
                    httpServerExchange.setRequestScheme(this.scheme);
                }
                this.state = null;
                this.httpServerExchange = null;
                httpServerExchange.setPersistent(true);
                if (this.recordRequestStartTime) {
                    Connectors.setRequestStartTime(httpServerExchange);
                }
                Connectors.executeRootHandler(this.connection.getRootHandler(), httpServerExchange);
            }
            catch (Throwable t) {
                UndertowLogger.REQUEST_LOGGER.exceptionProcessingRequest(t);
                IoUtils.safeClose((Closeable)channel);
                IoUtils.safeClose((Closeable)((Object)this.connection));
            }
        }
        catch (Exception e) {
            UndertowLogger.REQUEST_LOGGER.exceptionProcessingRequest(e);
            IoUtils.safeClose((Closeable)this.connection.getChannel());
        }
        finally {
            if (free) {
                pooled.free();
            }
        }
    }

    private void handleCPing() {
        this.state = new AjpRequestParseState();
        final StreamConnection underlyingChannel = this.connection.getChannel();
        underlyingChannel.getSourceChannel().suspendReads();
        final ByteBuffer buffer = ByteBuffer.wrap(CPONG);
        try {
            do {
                int res;
                if ((res = underlyingChannel.getSinkChannel().write(buffer)) != 0) continue;
                underlyingChannel.getSinkChannel().setWriteListener((ChannelListener)new ChannelListener<ConduitStreamSinkChannel>(){

                    public void handleEvent(ConduitStreamSinkChannel channel) {
                        do {
                            try {
                                int res = channel.write(buffer);
                                if (res == 0) {
                                    return;
                                }
                            }
                            catch (IOException e) {
                                UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                                IoUtils.safeClose((Closeable)((Object)AjpReadListener.this.connection));
                            }
                        } while (buffer.hasRemaining());
                        channel.suspendWrites();
                        AjpReadListener.this.handleEvent((StreamSourceChannel)underlyingChannel.getSourceChannel());
                    }
                });
                underlyingChannel.getSinkChannel().resumeWrites();
                return;
            } while (buffer.hasRemaining());
            this.handleEvent((StreamSourceChannel)underlyingChannel.getSourceChannel());
        }
        catch (IOException e) {
            UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
            IoUtils.safeClose((Closeable)((Object)this.connection));
        }
    }

    public void exchangeComplete(HttpServerExchange exchange) {
        if (!exchange.isUpgrade() && exchange.isPersistent()) {
            this.startRequest();
            ConduitStreamSourceChannel channel = ((AjpServerConnection)exchange.getConnection()).getChannel().getSourceChannel();
            channel.getReadSetter().set((ChannelListener)this);
            channel.wakeupReads();
        } else if (!exchange.isPersistent()) {
            IoUtils.safeClose((Closeable)((Object)exchange.getConnection()));
        }
    }

    private StreamSourceConduit createSourceConduit(StreamSourceConduit underlyingConduit, AjpServerResponseConduit responseConduit, final HttpServerExchange exchange) {
        Long length;
        boolean hasTransferEncoding;
        ReadDataStreamSourceConduit conduit = new ReadDataStreamSourceConduit(underlyingConduit, (AbstractServerConnection)exchange.getConnection());
        HeaderMap requestHeaders = exchange.getRequestHeaders();
        HttpString transferEncoding = Headers.IDENTITY;
        String teHeader = requestHeaders.getLast(Headers.TRANSFER_ENCODING);
        boolean bl = hasTransferEncoding = teHeader != null;
        if (hasTransferEncoding) {
            transferEncoding = new HttpString(teHeader);
        }
        String requestContentLength = requestHeaders.getFirst(Headers.CONTENT_LENGTH);
        if (hasTransferEncoding && !transferEncoding.equals(Headers.IDENTITY)) {
            length = null;
        } else if (requestContentLength != null) {
            long contentLength = Long.parseLong(requestContentLength);
            if (contentLength == 0L) {
                UndertowLogger.REQUEST_LOGGER.trace("No content, starting next request");
                Connectors.terminateRequest(this.httpServerExchange);
                return new EmptyStreamSourceConduit(conduit.getReadThread());
            }
            length = contentLength;
        } else {
            UndertowLogger.REQUEST_LOGGER.trace("No content length or transfer coding, starting next request");
            Connectors.terminateRequest(exchange);
            return new EmptyStreamSourceConduit(conduit.getReadThread());
        }
        return new AjpServerRequestConduit((StreamSourceConduit)conduit, exchange, responseConduit, length, (ConduitListener<? super AjpServerRequestConduit>)new ConduitListener<AjpServerRequestConduit>(){

            @Override
            public void handleEvent(AjpServerRequestConduit channel) {
                Connectors.terminateRequest(exchange);
            }
        });
    }
}

