/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.attribute;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeBuilder;
import io.undertow.attribute.ReadOnlyAttributeException;
import io.undertow.server.HttpServerExchange;

public class RequestLineAttribute
implements ExchangeAttribute {
    public static final String REQUEST_LINE_SHORT = "%r";
    public static final String REQUEST_LINE = "%{REQUEST_LINE}";
    public static final ExchangeAttribute INSTANCE = new RequestLineAttribute();

    private RequestLineAttribute() {
    }

    @Override
    public String readAttribute(HttpServerExchange exchange) {
        StringBuilder sb = new StringBuilder().append(exchange.getRequestMethod().toString()).append(' ').append(exchange.getRequestURI());
        if (!exchange.getQueryString().isEmpty()) {
            sb.append('?');
            sb.append(exchange.getQueryString());
        }
        sb.append(' ').append(exchange.getProtocol().toString()).toString();
        return sb.toString();
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
        throw new ReadOnlyAttributeException("Request line", newValue);
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Request line";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.equals(RequestLineAttribute.REQUEST_LINE) || token.equals(RequestLineAttribute.REQUEST_LINE_SHORT)) {
                return INSTANCE;
            }
            return null;
        }
    }
}

