/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.http2;

import io.undertow.protocols.http2.HPackHuffman;
import io.undertow.protocols.http2.Hpack;
import io.undertow.protocols.http2.HpackException;
import io.undertow.util.HttpString;
import java.nio.ByteBuffer;

public class HpackDecoder
extends Hpack {
    private HeaderEmitter headerEmitter;
    private Hpack.HeaderField[] headerTable;
    private int firstSlotPosition = 0;
    private int filledTableSlots = 0;
    private int currentMemorySize = 0;
    private int maxMemorySize;
    private final StringBuilder stringBuilder = new StringBuilder();

    public HpackDecoder(int maxMemorySize) {
        this.maxMemorySize = maxMemorySize;
        int tableSize = maxMemorySize / 32;
        this.headerTable = new Hpack.HeaderField[tableSize];
    }

    public HpackDecoder() {
        this(4096);
    }

    public void decode(ByteBuffer buffer, boolean moreData) throws HpackException {
        while (buffer.hasRemaining()) {
            String headerValue;
            int originalPos = buffer.position();
            byte b = buffer.get();
            if ((b & 0x80) != 0) {
                buffer.position(buffer.position() - 1);
                int index = HpackDecoder.decodeInteger(buffer, 7);
                if (index == -1) {
                    buffer.position(originalPos);
                    return;
                }
                this.handleIndex(index);
                continue;
            }
            if ((b & 0x40) != 0) {
                HttpString headerName = this.readHeaderName(buffer, 6);
                if (headerName == null) {
                    buffer.position(originalPos);
                    return;
                }
                headerValue = this.readHpackString(buffer);
                if (headerValue == null) {
                    buffer.position(originalPos);
                    return;
                }
                this.headerEmitter.emitHeader(headerName, headerValue, false);
                this.addEntryToHeaderTable(new Hpack.HeaderField(headerName, headerValue));
                continue;
            }
            if ((b & 0xF0) == 0) {
                HttpString headerName = this.readHeaderName(buffer, 4);
                if (headerName == null) {
                    buffer.position(originalPos);
                    return;
                }
                headerValue = this.readHpackString(buffer);
                if (headerValue == null) {
                    buffer.position(originalPos);
                    return;
                }
                this.headerEmitter.emitHeader(headerName, headerValue, false);
                continue;
            }
            if ((b & 0xF0) == 16) {
                HttpString headerName = this.readHeaderName(buffer, 4);
                if (headerName == null) {
                    buffer.position(originalPos);
                    return;
                }
                headerValue = this.readHpackString(buffer);
                if (headerValue == null) {
                    buffer.position(originalPos);
                    return;
                }
                this.headerEmitter.emitHeader(headerName, headerValue, true);
                continue;
            }
            if ((b & 0xE0) == 32) {
                if (this.handleMaxMemorySizeChange(buffer, originalPos)) continue;
                return;
            }
            throw new RuntimeException("Not yet implemented");
        }
    }

    private boolean handleMaxMemorySizeChange(ByteBuffer buffer, int originalPos) {
        buffer.position(buffer.position() - 1);
        int size = HpackDecoder.decodeInteger(buffer, 5);
        if (size == -1) {
            buffer.position(originalPos);
            return false;
        }
        this.maxMemorySize = size;
        if (this.currentMemorySize > this.maxMemorySize) {
            int newTableSlots = this.filledTableSlots;
            int tableLength = this.headerTable.length;
            int newSize = this.currentMemorySize;
            while (this.currentMemorySize > this.maxMemorySize) {
                int clearIndex = this.firstSlotPosition++;
                if (this.firstSlotPosition == tableLength) {
                    this.firstSlotPosition = 0;
                }
                Hpack.HeaderField oldData = this.headerTable[clearIndex];
                this.headerTable[clearIndex] = null;
                newSize -= oldData.size;
                --newTableSlots;
            }
            this.filledTableSlots = newTableSlots;
            this.currentMemorySize = newSize;
        }
        return true;
    }

    private HttpString readHeaderName(ByteBuffer buffer, int prefixLength) throws HpackException {
        buffer.position(buffer.position() - 1);
        int index = HpackDecoder.decodeInteger(buffer, prefixLength);
        if (index == -1) {
            return null;
        }
        if (index != 0) {
            return this.handleIndexedHeaderName(index);
        }
        String string = this.readHpackString(buffer);
        if (string == null) {
            return null;
        }
        return new HttpString(string);
    }

    private String readHpackString(ByteBuffer buffer) throws HpackException {
        boolean huffman;
        if (!buffer.hasRemaining()) {
            return null;
        }
        byte data = buffer.get(buffer.position());
        int length = HpackDecoder.decodeInteger(buffer, 7);
        if (buffer.remaining() < length) {
            return null;
        }
        boolean bl = huffman = (data & 0x80) != 0;
        if (huffman) {
            return this.readHuffmanString(length, buffer);
        }
        for (int i = 0; i < length; ++i) {
            this.stringBuilder.append((char)buffer.get());
        }
        String ret = this.stringBuilder.toString();
        this.stringBuilder.setLength(0);
        return ret;
    }

    private String readHuffmanString(int length, ByteBuffer buffer) {
        HPackHuffman.decode(buffer, length, this.stringBuilder);
        String ret = this.stringBuilder.toString();
        this.stringBuilder.setLength(0);
        return ret;
    }

    private HttpString handleIndexedHeaderName(int index) throws HpackException {
        if (index <= STATIC_TABLE_LENGTH) {
            return HpackDecoder.STATIC_TABLE[index].name;
        }
        if (index >= STATIC_TABLE_LENGTH + this.filledTableSlots) {
            throw new HpackException();
        }
        int adjustedIndex = this.getRealIndex(index - STATIC_TABLE_LENGTH);
        Hpack.HeaderField res = this.headerTable[adjustedIndex];
        if (res == null) {
            throw new HpackException();
        }
        return res.name;
    }

    private void handleIndex(int index) throws HpackException {
        if (index <= STATIC_TABLE_LENGTH) {
            this.addStaticTableEntry(index);
        } else {
            int adjustedIndex = this.getRealIndex(index - STATIC_TABLE_LENGTH);
            Hpack.HeaderField headerField = this.headerTable[adjustedIndex];
            this.headerEmitter.emitHeader(headerField.name, headerField.value, false);
        }
    }

    int getRealIndex(int index) {
        return (this.firstSlotPosition + (this.filledTableSlots - index)) % this.headerTable.length;
    }

    private void addStaticTableEntry(int index) throws HpackException {
        Hpack.HeaderField entry = STATIC_TABLE[index];
        if (entry.value == null) {
            throw new HpackException();
        }
        this.headerEmitter.emitHeader(entry.name, entry.value, false);
    }

    private void addEntryToHeaderTable(Hpack.HeaderField entry) {
        if (entry.size > this.maxMemorySize) {
            this.filledTableSlots = 0;
            return;
        }
        int newTableSlots = this.filledTableSlots + 1;
        int tableLength = this.headerTable.length;
        int index = (this.firstSlotPosition + this.filledTableSlots) % tableLength;
        this.headerTable[index] = entry;
        int newSize = this.currentMemorySize + entry.size;
        while (newSize > this.maxMemorySize) {
            int clearIndex = this.firstSlotPosition++;
            if (this.firstSlotPosition == tableLength) {
                this.firstSlotPosition = 0;
            }
            Hpack.HeaderField oldData = this.headerTable[clearIndex];
            this.headerTable[clearIndex] = null;
            newSize -= oldData.size;
            --newTableSlots;
        }
        this.filledTableSlots = newTableSlots;
        this.currentMemorySize = newSize;
    }

    public HeaderEmitter getHeaderEmitter() {
        return this.headerEmitter;
    }

    public void setHeaderEmitter(HeaderEmitter headerEmitter) {
        this.headerEmitter = headerEmitter;
    }

    int getFirstSlotPosition() {
        return this.firstSlotPosition;
    }

    Hpack.HeaderField[] getHeaderTable() {
        return this.headerTable;
    }

    int getFilledTableSlots() {
        return this.filledTableSlots;
    }

    int getCurrentMemorySize() {
        return this.currentMemorySize;
    }

    int getMaxMemorySize() {
        return this.maxMemorySize;
    }

    public static interface HeaderEmitter {
        public void emitHeader(HttpString var1, String var2, boolean var3);
    }
}

