/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.security.impl;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.idm.PasswordCredential;
import io.undertow.server.DefaultResponseListener;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.server.session.Session;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import io.undertow.util.RedirectBuilder;
import io.undertow.util.Sessions;
import java.io.IOException;

public class FormAuthenticationMechanism
implements AuthenticationMechanism {
    public static final String LOCATION_ATTRIBUTE = FormAuthenticationMechanism.class.getName() + ".LOCATION";
    public static final String DEFAULT_POST_LOCATION = "/j_security_check";
    private final String name;
    private final String loginPage;
    private final String errorPage;
    private final String postLocation;
    private final FormParserFactory formParserFactory;

    public FormAuthenticationMechanism(String name, String loginPage, String errorPage) {
        this(FormParserFactory.builder().build(), name, loginPage, errorPage);
    }

    public FormAuthenticationMechanism(String name, String loginPage, String errorPage, String postLocation) {
        this(FormParserFactory.builder().build(), name, loginPage, errorPage, postLocation);
    }

    public FormAuthenticationMechanism(FormParserFactory formParserFactory, String name, String loginPage, String errorPage) {
        this(formParserFactory, name, loginPage, errorPage, DEFAULT_POST_LOCATION);
    }

    public FormAuthenticationMechanism(FormParserFactory formParserFactory, String name, String loginPage, String errorPage, String postLocation) {
        this.name = name;
        this.loginPage = loginPage;
        this.errorPage = errorPage;
        this.postLocation = postLocation;
        this.formParserFactory = formParserFactory;
    }

    @Override
    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        if (exchange.getRequestURI().endsWith(this.postLocation) && exchange.getRequestMethod().equals(Methods.POST)) {
            return this.runFormAuth(exchange, securityContext);
        }
        return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthenticationMechanism.AuthenticationMechanismOutcome runFormAuth(HttpServerExchange exchange, SecurityContext securityContext) {
        FormDataParser parser = this.formParserFactory.createParser(exchange);
        if (parser == null) {
            UndertowLogger.REQUEST_LOGGER.debug("Could not authenticate as no form parser is present");
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
        try {
            AuthenticationMechanism.AuthenticationMechanismOutcome outcome;
            block9: {
                FormData data = parser.parseBlocking();
                FormData.FormValue jUsername = data.getFirst("j_username");
                FormData.FormValue jPassword = data.getFirst("j_password");
                if (jUsername == null || jPassword == null) {
                    UndertowLogger.REQUEST_LOGGER.debug("Could not authenticate as username or password was not present in the posted result");
                    return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
                }
                String userName = jUsername.getValue();
                String password = jPassword.getValue();
                outcome = null;
                PasswordCredential credential = new PasswordCredential(password.toCharArray());
                try {
                    IdentityManager identityManager = securityContext.getIdentityManager();
                    Account account = identityManager.verify(userName, credential);
                    if (account != null) {
                        securityContext.authenticationComplete(account, this.name, true);
                        outcome = AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
                    } else {
                        securityContext.authenticationFailed(UndertowMessages.MESSAGES.authenticationFailed(userName), this.name);
                    }
                    if (outcome != AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED) break block9;
                    this.handleRedirectBack(exchange);
                    exchange.endExchange();
                }
                catch (Throwable throwable) {
                    if (outcome == AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED) {
                        this.handleRedirectBack(exchange);
                        exchange.endExchange();
                    }
                    return outcome != null ? outcome : AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
                }
            }
            return outcome != null ? outcome : AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void handleRedirectBack(HttpServerExchange exchange) {
        String location;
        Session session = Sessions.getSession(exchange);
        if (session != null && (location = (String)session.removeAttribute(LOCATION_ATTRIBUTE)) != null) {
            exchange.addDefaultResponseListener(new DefaultResponseListener(){

                @Override
                public boolean handleDefaultResponse(HttpServerExchange exchange) {
                    FormAuthenticationMechanism.sendRedirect(exchange, location);
                    exchange.setResponseCode(302);
                    exchange.endExchange();
                    return true;
                }
            });
        }
    }

    @Override
    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        if (exchange.getRequestURI().endsWith(this.postLocation) && exchange.getRequestMethod().equals(Methods.POST)) {
            Integer code = this.servePage(exchange, this.errorPage);
            return new AuthenticationMechanism.ChallengeResult(true, code);
        }
        this.storeInitialLocation(exchange);
        Integer code = this.servePage(exchange, this.loginPage);
        return new AuthenticationMechanism.ChallengeResult(true, code);
    }

    protected void storeInitialLocation(HttpServerExchange exchange) {
        Session session = Sessions.getOrCreateSession(exchange);
        session.setAttribute(LOCATION_ATTRIBUTE, RedirectBuilder.redirect(exchange, exchange.getRelativePath()));
    }

    protected Integer servePage(HttpServerExchange exchange, String location) {
        FormAuthenticationMechanism.sendRedirect(exchange, location);
        return 307;
    }

    static void sendRedirect(HttpServerExchange exchange, String location) {
        String loc = exchange.getRequestScheme() + "://" + exchange.getHostAndPort() + location;
        exchange.getResponseHeaders().put(Headers.LOCATION, loc);
    }
}

