/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.encoding;

import io.undertow.UndertowLogger;
import io.undertow.predicate.Predicate;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.encoding.AllowedContentEncodings;
import io.undertow.server.handlers.encoding.ContentEncodedResource;
import io.undertow.server.handlers.encoding.ContentEncodingRepository;
import io.undertow.server.handlers.encoding.EncodingMapping;
import io.undertow.server.handlers.resource.CachedResource;
import io.undertow.server.handlers.resource.CachingResourceManager;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.util.ImmediateConduitFactory;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.xnio.FileAccess;
import org.xnio.IoUtils;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.Channels;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.channels.SuspendableWriteChannel;
import org.xnio.conduits.ConduitStreamSinkChannel;
import org.xnio.conduits.Conduits;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.WriteReadyHandler;

public class ContentEncodedResourceManager {
    private final File encodedResourcesRoot;
    private final CachingResourceManager encoded;
    private final ContentEncodingRepository contentEncodingRepository;
    private final int minResourceSize;
    private final int maxResourceSize;
    private final Predicate encodingAllowed;
    private final ConcurrentMap<LockKey, Object> fileLocks = new ConcurrentHashMap<LockKey, Object>();

    public ContentEncodedResourceManager(File encodedResourcesRoot, CachingResourceManager encodedResourceManager, ContentEncodingRepository contentEncodingRepository, int minResourceSize, int maxResourceSize, Predicate encodingAllowed) {
        this.encodedResourcesRoot = encodedResourcesRoot;
        this.encoded = encodedResourceManager;
        this.contentEncodingRepository = contentEncodingRepository;
        this.minResourceSize = minResourceSize;
        this.maxResourceSize = maxResourceSize;
        this.encodingAllowed = encodingAllowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentEncodedResource getResource(Resource resource, HttpServerExchange exchange) throws IOException {
        FileChannel sourceFileChannel;
        FileChannel targetFileChannel;
        LockKey key;
        String newPath;
        EncodingMapping encoding;
        File file;
        block13: {
            ContentEncodedResource contentEncodedResource;
            String path = resource.getPath();
            file = resource.getFile();
            if (file == null) {
                return null;
            }
            if (this.minResourceSize > 0 && resource.getContentLength() < (long)this.minResourceSize || this.maxResourceSize > 0 && resource.getContentLength() > (long)this.maxResourceSize || this.encodingAllowed != null && !this.encodingAllowed.resolve(exchange)) {
                return null;
            }
            AllowedContentEncodings encodings = this.contentEncodingRepository.getContentEncodings(exchange);
            if (encodings == null || encodings.isNoEncodingsAllowed()) {
                return null;
            }
            encoding = encodings.getEncoding();
            if (encoding == null || encoding.getName().equals("identity")) {
                return null;
            }
            newPath = path + ".undertow.encoding." + encoding.getName();
            CachedResource preCompressed = this.encoded.getResource(newPath);
            if (preCompressed != null) {
                return new ContentEncodedResource(preCompressed, encoding.getName());
            }
            key = new LockKey(path, encoding.getName());
            if (this.fileLocks.putIfAbsent(key, this) != null) {
                return null;
            }
            targetFileChannel = null;
            sourceFileChannel = null;
            try {
                preCompressed = this.encoded.getResource(newPath);
                if (preCompressed == null) break block13;
                contentEncodedResource = new ContentEncodedResource(preCompressed, encoding.getName());
            }
            catch (Throwable throwable) {
                IoUtils.safeClose(targetFileChannel);
                IoUtils.safeClose(sourceFileChannel);
                this.fileLocks.remove(key);
                throw throwable;
            }
            IoUtils.safeClose(targetFileChannel);
            IoUtils.safeClose(sourceFileChannel);
            this.fileLocks.remove(key);
            return contentEncodedResource;
        }
        File finalTarget = new File(this.encodedResourcesRoot, newPath);
        File tempTarget = new File(this.encodedResourcesRoot, newPath);
        FileOutputStream tmp = new FileOutputStream(tempTarget);
        try {
            tmp.close();
        }
        finally {
            IoUtils.safeClose((Closeable)tmp);
        }
        targetFileChannel = exchange.getConnection().getWorker().getXnio().openFile(tempTarget, FileAccess.READ_WRITE);
        sourceFileChannel = exchange.getConnection().getWorker().getXnio().openFile(file, FileAccess.READ_ONLY);
        StreamSinkConduit conduit = encoding.getEncoding().getResponseWrapper().wrap(new ImmediateConduitFactory<FileConduitTarget>(new FileConduitTarget(targetFileChannel, exchange)), exchange);
        ConduitStreamSinkChannel targetChannel = new ConduitStreamSinkChannel(null, conduit);
        long transferred = sourceFileChannel.transferTo(0L, resource.getContentLength(), (WritableByteChannel)targetChannel);
        targetChannel.shutdownWrites();
        Channels.flushBlocking((SuspendableWriteChannel)targetChannel);
        if (transferred != resource.getContentLength()) {
            UndertowLogger.REQUEST_LOGGER.error("Failed to write pre-cached file");
        }
        tempTarget.renameTo(finalTarget);
        this.encoded.invalidate(newPath);
        CachedResource encodedResource = this.encoded.getResource(newPath);
        ContentEncodedResource contentEncodedResource = new ContentEncodedResource(encodedResource, encoding.getName());
        IoUtils.safeClose((Closeable)targetFileChannel);
        IoUtils.safeClose((Closeable)sourceFileChannel);
        this.fileLocks.remove(key);
        return contentEncodedResource;
    }

    private static final class FileConduitTarget
    implements StreamSinkConduit {
        private final FileChannel fileChannel;
        private final HttpServerExchange exchange;
        private WriteReadyHandler writeReadyHandler;
        private boolean writesResumed = false;

        private FileConduitTarget(FileChannel fileChannel, HttpServerExchange exchange) {
            this.fileChannel = fileChannel;
            this.exchange = exchange;
        }

        public long transferFrom(FileChannel fileChannel, long l, long l2) throws IOException {
            return this.fileChannel.transferFrom(fileChannel, l, l2);
        }

        public long transferFrom(StreamSourceChannel streamSourceChannel, long l, ByteBuffer byteBuffer) throws IOException {
            return IoUtils.transfer((ReadableByteChannel)streamSourceChannel, (long)l, (ByteBuffer)byteBuffer, (WritableByteChannel)this.fileChannel);
        }

        public int write(ByteBuffer byteBuffer) throws IOException {
            return this.fileChannel.write(byteBuffer);
        }

        public long write(ByteBuffer[] byteBuffers, int i, int i2) throws IOException {
            return this.fileChannel.write(byteBuffers, i, i2);
        }

        public int writeFinal(ByteBuffer src) throws IOException {
            return Conduits.writeFinalBasic((StreamSinkConduit)this, (ByteBuffer)src);
        }

        public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
            return Conduits.writeFinalBasic((StreamSinkConduit)this, (ByteBuffer[])srcs, (int)offset, (int)length);
        }

        public void terminateWrites() throws IOException {
            this.fileChannel.close();
        }

        public boolean isWriteShutdown() {
            return !this.fileChannel.isOpen();
        }

        public void resumeWrites() {
            this.wakeupWrites();
        }

        public void suspendWrites() {
            this.writesResumed = false;
        }

        public void wakeupWrites() {
            if (this.writeReadyHandler != null) {
                this.writesResumed = true;
                while (this.writesResumed && this.writeReadyHandler != null) {
                    this.writeReadyHandler.writeReady();
                }
            }
        }

        public boolean isWriteResumed() {
            return this.writesResumed;
        }

        public void awaitWritable() throws IOException {
        }

        public void awaitWritable(long l, TimeUnit timeUnit) throws IOException {
        }

        public XnioIoThread getWriteThread() {
            return this.exchange.getIoThread();
        }

        public void setWriteReadyHandler(WriteReadyHandler writeReadyHandler) {
            this.writeReadyHandler = writeReadyHandler;
        }

        public void truncateWrites() throws IOException {
            this.fileChannel.close();
        }

        public boolean flush() throws IOException {
            return true;
        }

        public XnioWorker getWorker() {
            return this.exchange.getConnection().getWorker();
        }
    }

    private final class LockKey {
        private final String path;
        private final String encoding;

        private LockKey(String path, String encoding) {
            this.path = path;
            this.encoding = encoding;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LockKey lockKey = (LockKey)o;
            if (this.encoding != null ? !this.encoding.equals(lockKey.encoding) : lockKey.encoding != null) {
                return false;
            }
            return !(this.path != null ? !this.path.equals(lockKey.path) : lockKey.path != null);
        }

        public int hashCode() {
            int result = this.path != null ? this.path.hashCode() : 0;
            result = 31 * result + (this.encoding != null ? this.encoding.hashCode() : 0);
            return result;
        }
    }
}

