/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.client;

import io.undertow.websockets.client.WebSocketClientHandshake;
import io.undertow.websockets.client.WebSocketClientNegotiation;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketVersion;
import io.undertow.websockets.extensions.ExtensionHandshake;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xnio.Cancellable;
import org.xnio.ChannelListener;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.StreamConnection;
import org.xnio.XnioWorker;
import org.xnio.http.ExtendedHandshakeChecker;
import org.xnio.http.HttpUpgrade;
import org.xnio.ssl.XnioSsl;

public class WebSocketClient {
    public static IoFuture<WebSocketChannel> connect(XnioWorker worker, Pool<ByteBuffer> bufferPool, OptionMap optionMap, URI uri, WebSocketVersion version) {
        return WebSocketClient.connect(worker, bufferPool, optionMap, uri, version, null);
    }

    public static IoFuture<WebSocketChannel> connect(XnioWorker worker, XnioSsl ssl, Pool<ByteBuffer> bufferPool, OptionMap optionMap, URI uri, WebSocketVersion version) {
        return WebSocketClient.connect(worker, ssl, bufferPool, optionMap, uri, version, null);
    }

    public static IoFuture<WebSocketChannel> connect(XnioWorker worker, Pool<ByteBuffer> bufferPool, OptionMap optionMap, URI uri, WebSocketVersion version, WebSocketClientNegotiation clientNegotiation) {
        return WebSocketClient.connect(worker, null, bufferPool, optionMap, uri, version, clientNegotiation);
    }

    public static IoFuture<WebSocketChannel> connect(XnioWorker worker, XnioSsl ssl, Pool<ByteBuffer> bufferPool, OptionMap optionMap, URI uri, WebSocketVersion version, WebSocketClientNegotiation clientNegotiation) {
        return WebSocketClient.connect(worker, ssl, bufferPool, optionMap, uri, version, clientNegotiation, null);
    }

    public static IoFuture<WebSocketChannel> connect(XnioWorker worker, XnioSsl ssl, final Pool<ByteBuffer> bufferPool, OptionMap optionMap, URI uri, WebSocketVersion version, WebSocketClientNegotiation clientNegotiation, Set<ExtensionHandshake> clientExtensions) {
        URI newUri;
        final FutureResult ioFuture = new FutureResult();
        try {
            newUri = new URI(uri.getScheme().equals("wss") ? "https" : "http", uri.getUserInfo(), uri.getHost(), uri.getPort() == -1 ? (uri.getScheme().equals("wss") ? 443 : 80) : uri.getPort(), uri.getPath().isEmpty() ? "/" : uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        final WebSocketClientHandshake handshake = WebSocketClientHandshake.create(version, newUri, clientNegotiation, clientExtensions);
        Map<String, String> originalHeaders = handshake.createHeaders();
        originalHeaders.put("Origin", uri.getHost());
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        for (Map.Entry<String, String> entry : originalHeaders.entrySet()) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(entry.getValue());
            headers.put(entry.getKey(), list);
        }
        if (clientNegotiation != null) {
            clientNegotiation.beforeRequest(headers);
        }
        final IoFuture result = ssl != null ? HttpUpgrade.performUpgrade((XnioWorker)worker, (XnioSsl)ssl, null, (URI)newUri, headers, (ChannelListener)new ChannelListener<StreamConnection>(){

            public void handleEvent(StreamConnection channel) {
                WebSocketChannel result = handshake.createChannel(channel, newUri.toString(), (Pool<ByteBuffer>)bufferPool);
                ioFuture.setResult((Object)result);
            }
        }, null, (OptionMap)optionMap, (ExtendedHandshakeChecker)handshake.handshakeChecker(newUri, headers)) : HttpUpgrade.performUpgrade((XnioWorker)worker, null, (URI)newUri, headers, (ChannelListener)new ChannelListener<StreamConnection>(){

            public void handleEvent(StreamConnection channel) {
                WebSocketChannel result = handshake.createChannel(channel, newUri.toString(), (Pool<ByteBuffer>)bufferPool);
                ioFuture.setResult((Object)result);
            }
        }, null, (OptionMap)optionMap, (ExtendedHandshakeChecker)handshake.handshakeChecker(newUri, headers));
        result.addNotifier((IoFuture.Notifier)new IoFuture.Notifier<StreamConnection, Object>(){

            public void notify(IoFuture<? extends StreamConnection> res, Object attachment) {
                if (res.getStatus() == IoFuture.Status.FAILED) {
                    ioFuture.setException(res.getException());
                }
            }
        }, null);
        ioFuture.addCancelHandler(new Cancellable(){

            public Cancellable cancel() {
                result.cancel();
                return null;
            }
        });
        return ioFuture.getIoFuture();
    }

    private WebSocketClient() {
    }
}

