/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.extensions;

import io.undertow.websockets.core.WebSocketChannel;
import java.nio.ByteBuffer;
import org.xnio.Pooled;

public class ExtensionByteBuffer {
    private WebSocketChannel channel;
    private ByteBuffer input;
    private int currentPosition;
    private int extraBuffers;
    private Pooled<ByteBuffer>[] extraPools;
    private int filled;
    private boolean flushed;
    private int flushedBuffer;
    private int flushedPosition;

    public ExtensionByteBuffer(WebSocketChannel channel, ByteBuffer input, int initPosition) {
        this.channel = channel;
        this.input = input;
        this.currentPosition = initPosition;
        this.extraBuffers = 0;
        this.filled = 0;
        this.flushed = false;
        this.flushedBuffer = 0;
        this.flushedPosition = 0;
    }

    public ByteBuffer getInput() {
        return this.input;
    }

    public void put(byte value) {
        this.checkPosition();
        this.currentBuffer().put(this.currentPosition, value);
        ++this.currentPosition;
        this.currentBuffer().position(this.currentPosition);
        ++this.filled;
    }

    public byte get(int position) {
        int relativePosition = this.getPosition(position);
        return this.getBuffer(position).get(relativePosition);
    }

    public int getFilled() {
        return this.filled;
    }

    public boolean hasExtra() {
        return this.extraBuffers > 0 && !this.flushed;
    }

    public int getExtra() {
        return this.extraBuffers;
    }

    public ByteBuffer getExtraBuffer(int buffer) {
        if (this.extraBuffers == 0 || buffer < 0 || buffer >= this.extraBuffers) {
            return null;
        }
        return (ByteBuffer)this.extraPools[buffer].getResource();
    }

    public boolean hasExtraRemaining() {
        if (this.extraBuffers == 0) {
            return false;
        }
        for (int i = 0; i < this.extraBuffers; ++i) {
            if (!((ByteBuffer)this.extraPools[i].getResource()).hasRemaining()) continue;
            return true;
        }
        return false;
    }

    public ByteBuffer getExtraRemainingBuffer() {
        if (this.extraBuffers == 0) {
            return null;
        }
        for (int i = 0; i < this.extraBuffers; ++i) {
            if (!((ByteBuffer)this.extraPools[i].getResource()).hasRemaining()) continue;
            return (ByteBuffer)this.extraPools[i].getResource();
        }
        return null;
    }

    public void flipExtra() {
        if (this.extraBuffers == 0) {
            return;
        }
        for (int i = 0; i < this.extraBuffers; ++i) {
            ((ByteBuffer)this.extraPools[i].getResource()).flip();
        }
    }

    public int flushExtra(ByteBuffer dst) {
        if (dst == null) {
            throw new IndexOutOfBoundsException("ByteBuffer destination is empty");
        }
        if (this.extraBuffers == 0) {
            return 0;
        }
        int count = 0;
        int maxPosition = 0;
        while (this.flushedBuffer < this.extraBuffers) {
            int n = maxPosition = this.flushedBuffer + 1 == this.extraBuffers ? this.currentPosition : ((ByteBuffer)this.extraPools[this.flushedBuffer].getResource()).capacity();
            while (this.flushedPosition < maxPosition) {
                dst.put(((ByteBuffer)this.extraPools[this.flushedBuffer].getResource()).get(this.flushedPosition));
                ++count;
                if (!dst.hasRemaining()) {
                    if (this.flushedPosition == maxPosition - 1) {
                        if (this.flushedBuffer == this.extraBuffers - 1) {
                            this.flushed = true;
                            this.free();
                        } else {
                            this.flushedPosition = 0;
                            ++this.flushedBuffer;
                        }
                    }
                    return count;
                }
                ++this.flushedPosition;
            }
            this.flushedPosition = 0;
            ++this.flushedBuffer;
        }
        this.flushed = true;
        this.free();
        return count;
    }

    public void free() {
        if (this.extraPools != null) {
            for (int i = 0; i < this.extraPools.length; ++i) {
                this.extraPools[i].free();
            }
        }
    }

    private void extraBuffer() {
        Pooled extraBuffer = this.channel.getBufferPool().allocate();
        if (this.extraPools == null) {
            this.extraPools = new Pooled[1];
            this.extraPools[0] = extraBuffer;
            this.extraBuffers = 1;
        } else {
            Pooled[] newExtraPools = new Pooled[this.extraBuffers + 1];
            for (int i = 0; i < this.extraBuffers; ++i) {
                newExtraPools[i] = this.extraPools[i];
            }
            newExtraPools[this.extraBuffers] = extraBuffer;
            this.extraPools = newExtraPools;
            ++this.extraBuffers;
        }
    }

    private void checkPosition() {
        if (this.currentPosition == this.currentBuffer().capacity()) {
            this.extraBuffer();
            this.currentPosition = 0;
        }
        if (this.currentPosition >= this.currentBuffer().limit()) {
            this.currentBuffer().limit(this.currentPosition + 1);
        }
    }

    private ByteBuffer currentBuffer() {
        if (this.extraBuffers == 0) {
            return this.input;
        }
        return (ByteBuffer)this.extraPools[this.extraBuffers - 1].getResource();
    }

    private ByteBuffer getBuffer(int position) {
        if (this.extraBuffers == 0) {
            return this.input;
        }
        if (position < this.input.capacity()) {
            return this.input;
        }
        int offset = this.input.capacity();
        for (int i = 0; i < this.extraPools.length; ++i) {
            if (position >= offset + ((ByteBuffer)this.extraPools[i].getResource()).capacity()) continue;
            return (ByteBuffer)this.extraPools[i].getResource();
        }
        return (ByteBuffer)this.extraPools[this.extraBuffers - 1].getResource();
    }

    private int getPosition(int position) {
        if (this.extraBuffers == 0) {
            return position;
        }
        if (position < this.input.capacity()) {
            return position;
        }
        int offset = this.input.capacity();
        for (int i = 0; i < this.extraPools.length; ++i) {
            if (position < offset + ((ByteBuffer)this.extraPools[i].getResource()).capacity()) {
                return position - offset;
            }
            offset += ((ByteBuffer)this.extraPools[i].getResource()).capacity();
        }
        return position;
    }
}

