/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.accesslog;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributes;
import io.undertow.attribute.SubstituteEmptyWrapper;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.accesslog.AccessLogReceiver;
import io.undertow.server.handlers.accesslog.JBossLoggingAccessLogReceiver;
import io.undertow.server.handlers.builder.HandlerBuilder;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class AccessLogHandler
implements HttpHandler {
    private final HttpHandler next;
    private final AccessLogReceiver accessLogReceiver;
    private final String formatString;
    private final ExchangeAttribute tokens;
    private final ExchangeCompletionListener exchangeCompletionListener = new AccessLogCompletionListener();

    public AccessLogHandler(HttpHandler next, AccessLogReceiver accessLogReceiver, String formatString, ClassLoader classLoader) {
        this.next = next;
        this.accessLogReceiver = accessLogReceiver;
        this.formatString = AccessLogHandler.handleCommonNames(formatString);
        this.tokens = ExchangeAttributes.parser(classLoader, new SubstituteEmptyWrapper("-")).parse(this.formatString);
    }

    private static String handleCommonNames(String formatString) {
        if (formatString.equals("common")) {
            return "%h %l %u %t \"%r\" %s %b";
        }
        if (formatString.equals("combined")) {
            return "%h %l %u %t \"%r\" %s %b \"%{i,Referer}\" \"%{i,User-Agent}\"";
        }
        return formatString;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        exchange.addExchangeCompleteListener(this.exchangeCompletionListener);
        this.next.handleRequest(exchange);
    }

    public String toString() {
        return "AccessLogHandler{formatString='" + this.formatString + '\'' + '}';
    }

    private static class Wrapper
    implements HandlerWrapper {
        private final String format;

        private Wrapper(String format) {
            this.format = format;
        }

        @Override
        public HttpHandler wrap(HttpHandler handler) {
            return new AccessLogHandler(handler, new JBossLoggingAccessLogReceiver(), this.format, Wrapper.class.getClassLoader());
        }
    }

    public static class Builder
    implements HandlerBuilder {
        @Override
        public String name() {
            return "access-log";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.singletonMap("format", String.class);
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.singleton("format");
        }

        @Override
        public String defaultParameter() {
            return "format";
        }

        @Override
        public HandlerWrapper build(Map<String, Object> config) {
            return new Wrapper((String)config.get("format"));
        }
    }

    private class AccessLogCompletionListener
    implements ExchangeCompletionListener {
        private AccessLogCompletionListener() {
        }

        @Override
        public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
            try {
                AccessLogHandler.this.accessLogReceiver.logMessage(AccessLogHandler.this.tokens.readAttribute(exchange));
            }
            finally {
                nextListener.proceed();
            }
        }
    }
}

