/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.conduits.ByteActivityCallback;
import io.undertow.server.ConnectorStatistics;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpServerExchange;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class ConnectorStatisticsImpl
implements ConnectorStatistics {
    private static final AtomicLongFieldUpdater<ConnectorStatisticsImpl> requestCountUpdater = AtomicLongFieldUpdater.newUpdater(ConnectorStatisticsImpl.class, "requestCount");
    private static final AtomicLongFieldUpdater<ConnectorStatisticsImpl> bytesSentUpdater = AtomicLongFieldUpdater.newUpdater(ConnectorStatisticsImpl.class, "bytesSent");
    private static final AtomicLongFieldUpdater<ConnectorStatisticsImpl> bytesReceivedUpdater = AtomicLongFieldUpdater.newUpdater(ConnectorStatisticsImpl.class, "bytesReceived");
    private static final AtomicLongFieldUpdater<ConnectorStatisticsImpl> errorCountUpdater = AtomicLongFieldUpdater.newUpdater(ConnectorStatisticsImpl.class, "errorCount");
    private static final AtomicLongFieldUpdater<ConnectorStatisticsImpl> processingTimeUpdater = AtomicLongFieldUpdater.newUpdater(ConnectorStatisticsImpl.class, "processingTime");
    private static final AtomicLongFieldUpdater<ConnectorStatisticsImpl> maxProcessingTimeUpdater = AtomicLongFieldUpdater.newUpdater(ConnectorStatisticsImpl.class, "maxProcessingTime");
    private volatile long requestCount;
    private volatile long bytesSent;
    private volatile long bytesReceived;
    private volatile long errorCount;
    private volatile long processingTime;
    private volatile long maxProcessingTime;
    private final ExchangeCompletionListener completionListener = new ExchangeCompletionListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
            block5: {
                try {
                    long oldMax;
                    long start;
                    if (exchange.getResponseCode() == 500) {
                        errorCountUpdater.incrementAndGet(ConnectorStatisticsImpl.this);
                    }
                    if ((start = exchange.getRequestStartTime()) <= 0L) break block5;
                    long elapsed = System.currentTimeMillis() - start;
                    processingTimeUpdater.addAndGet(ConnectorStatisticsImpl.this, elapsed);
                    do {
                        if ((oldMax = maxProcessingTimeUpdater.get(ConnectorStatisticsImpl.this)) < elapsed) continue;
                        break;
                    } while (!maxProcessingTimeUpdater.compareAndSet(ConnectorStatisticsImpl.this, oldMax, elapsed));
                }
                finally {
                    nextListener.proceed();
                }
            }
        }
    };

    @Override
    public long getRequestCount() {
        return requestCountUpdater.get(this);
    }

    @Override
    public long getBytesSent() {
        return bytesSentUpdater.get(this);
    }

    @Override
    public long getBytesReceived() {
        return bytesReceivedUpdater.get(this);
    }

    @Override
    public long getErrorCount() {
        return errorCountUpdater.get(this);
    }

    @Override
    public long getProcessingTime() {
        return processingTimeUpdater.get(this);
    }

    @Override
    public long getMaxProcessingTime() {
        return maxProcessingTimeUpdater.get(this);
    }

    @Override
    public void reset() {
        requestCountUpdater.set(this, 0L);
        bytesSentUpdater.set(this, 0L);
        bytesReceivedUpdater.set(this, 0L);
        errorCountUpdater.set(this, 0L);
        maxProcessingTimeUpdater.set(this, 0L);
        processingTimeUpdater.set(this, 0L);
    }

    public void requestFinished(long bytesSent, long bytesReceived, boolean error) {
        bytesSentUpdater.addAndGet(this, bytesSent);
        bytesReceivedUpdater.addAndGet(this, bytesReceived);
        if (error) {
            errorCountUpdater.incrementAndGet(this);
        }
    }

    public void updateBytesSent(long bytes) {
        bytesSentUpdater.addAndGet(this, bytes);
    }

    public void updateBytesReceived(long bytes) {
        bytesReceivedUpdater.addAndGet(this, bytes);
    }

    public void setup(HttpServerExchange exchange) {
        requestCountUpdater.incrementAndGet(this);
        exchange.addExchangeCompleteListener(this.completionListener);
    }

    public ByteActivityCallback sentAccumulator() {
        return new BytesSentAccumulator();
    }

    public ByteActivityCallback receivedAccumulator() {
        return new BytesReceivedAccumulator();
    }

    private class BytesReceivedAccumulator
    implements ByteActivityCallback {
        private BytesReceivedAccumulator() {
        }

        @Override
        public void activity(long bytes) {
            bytesReceivedUpdater.addAndGet(ConnectorStatisticsImpl.this, bytes);
        }
    }

    private class BytesSentAccumulator
    implements ByteActivityCallback {
        private BytesSentAccumulator() {
        }

        @Override
        public void activity(long bytes) {
            bytesSentUpdater.addAndGet(ConnectorStatisticsImpl.this, bytes);
        }
    }
}

