/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy.mod_cluster;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.Version;
import io.undertow.io.Sender;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.server.handlers.form.FormEncodedDataDefinition;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.server.handlers.proxy.mod_cluster.Balancer;
import io.undertow.server.handlers.proxy.mod_cluster.Context;
import io.undertow.server.handlers.proxy.mod_cluster.MCMPConfig;
import io.undertow.server.handlers.proxy.mod_cluster.MCMPConstants;
import io.undertow.server.handlers.proxy.mod_cluster.MCMPErrorCode;
import io.undertow.server.handlers.proxy.mod_cluster.MCMPInfoUtil;
import io.undertow.server.handlers.proxy.mod_cluster.ModCluster;
import io.undertow.server.handlers.proxy.mod_cluster.ModClusterContainer;
import io.undertow.server.handlers.proxy.mod_cluster.Node;
import io.undertow.server.handlers.proxy.mod_cluster.NodeConfig;
import io.undertow.server.handlers.proxy.mod_cluster.NodePingUtil;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.ssl.XnioSsl;

class MCMPHandler
implements HttpHandler {
    public static final HttpString CONFIG = new HttpString("CONFIG");
    public static final HttpString ENABLE_APP = new HttpString("ENABLE-APP");
    public static final HttpString DISABLE_APP = new HttpString("DISABLE-APP");
    public static final HttpString STOP_APP = new HttpString("STOP-APP");
    public static final HttpString REMOVE_APP = new HttpString("REMOVE-APP");
    public static final HttpString STATUS = new HttpString("STATUS");
    public static final HttpString DUMP = new HttpString("DUMP");
    public static final HttpString INFO = new HttpString("INFO");
    public static final HttpString PING = new HttpString("PING");
    protected static final String VERSION_PROTOCOL = "0.2.1";
    protected static final String MOD_CLUSTER_EXPOSED_VERSION = "mod_cluster_undertow/" + Version.getVersionString();
    private static final String CONTENT_TYPE = "text/plain; charset=ISO-8859-1";
    private static final String TYPESYNTAX = "SYNTAX";
    private static final String SCONBAD = "SYNTAX: Context without Alias";
    private static final String SBADFLD = "SYNTAX: Invalid field ";
    private static final String SBADFLD1 = " in message";
    private static final String SMISFLD = "SYNTAX: Mandatory field(s) missing in message";
    private final FormParserFactory parserFactory;
    private final MCMPConfig config;
    private final HttpHandler next;
    private final long creationTime = System.currentTimeMillis();
    private final ModCluster modCluster;
    protected final ModClusterContainer container;

    public MCMPHandler(MCMPConfig config, ModCluster modCluster, HttpHandler next) {
        this.config = config;
        this.next = next;
        this.modCluster = modCluster;
        this.container = modCluster.getContainer();
        this.parserFactory = FormParserFactory.builder(false).addParser(new FormEncodedDataDefinition().setForceCreation(true)).build();
        UndertowLogger.ROOT_LOGGER.mcmpHandlerCreated();
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        InetSocketAddress addr = exchange.getDestinationAddress();
        if (addr.getPort() != this.config.getManagementPort() || !addr.getHostString().equals(this.config.getManagementHost()) && !addr.getHostString().equals(this.config.getManagementHostIp())) {
            this.next.handleRequest(exchange);
            return;
        }
        if (exchange.isInIoThread()) {
            exchange.dispatch(this);
            return;
        }
        HttpString method = exchange.getRequestMethod();
        try {
            this.handleRequest(method, exchange);
        }
        catch (Exception e) {
            UndertowLogger.ROOT_LOGGER.failedToProcessManagementReq(e);
            exchange.setStatusCode(500);
            exchange.getResponseHeaders().add(Headers.CONTENT_TYPE, CONTENT_TYPE);
            Sender sender = exchange.getResponseSender();
            sender.send("failed to process management request");
        }
    }

    protected void handleRequest(HttpString method, HttpServerExchange exchange) throws Exception {
        RequestData requestData = this.parseFormData(exchange);
        if (CONFIG.equals(method)) {
            this.processConfig(exchange, requestData);
        } else if (ENABLE_APP.equals(method)) {
            this.processCommand(exchange, requestData, MCMPAction.ENABLE);
        } else if (DISABLE_APP.equals(method)) {
            this.processCommand(exchange, requestData, MCMPAction.DISABLE);
        } else if (STOP_APP.equals(method)) {
            this.processCommand(exchange, requestData, MCMPAction.STOP);
        } else if (REMOVE_APP.equals(method)) {
            this.processCommand(exchange, requestData, MCMPAction.REMOVE);
        } else if (STATUS.equals(method)) {
            this.processStatus(exchange, requestData);
        } else if (INFO.equals(method)) {
            this.processInfo(exchange);
        } else if (DUMP.equals(method)) {
            this.processDump(exchange);
        } else if (PING.equals(method)) {
            this.processPing(exchange, requestData);
        } else {
            this.next.handleRequest(exchange);
        }
    }

    private void processConfig(HttpServerExchange exchange, RequestData requestData) throws IOException {
        List<String> hosts = null;
        List<String> contexts = null;
        Balancer.BalancerBuilder balancer = Balancer.builder();
        NodeConfig.NodeBuilder node = NodeConfig.builder(this.modCluster);
        Iterator<HttpString> i = requestData.iterator();
        while (i.hasNext()) {
            HttpString name = i.next();
            String value = requestData.getFirst(name);
            UndertowLogger.ROOT_LOGGER.mcmpKeyValue(name, value);
            if (!MCMPHandler.checkString(value)) {
                MCMPHandler.processError(TYPESYNTAX, SBADFLD + name + SBADFLD1, exchange);
                return;
            }
            if (MCMPConstants.BALANCER.equals(name)) {
                node.setBalancer(value);
                balancer.setName(value);
                continue;
            }
            if (MCMPConstants.MAXATTEMPTS.equals(name)) {
                balancer.setMaxattempts(Integer.valueOf(value));
                continue;
            }
            if (MCMPConstants.STICKYSESSION.equals(name)) {
                if (!"No".equalsIgnoreCase(value)) continue;
                balancer.setStickySession(false);
                continue;
            }
            if (MCMPConstants.STICKYSESSIONCOOKIE.equals(name)) {
                balancer.setStickySessionCookie(value);
                continue;
            }
            if (MCMPConstants.STICKYSESSIONPATH.equals(name)) {
                balancer.setStickySessionPath(value);
                continue;
            }
            if (MCMPConstants.STICKYSESSIONREMOVE.equals(name)) {
                if (!"Yes".equalsIgnoreCase(value)) continue;
                balancer.setStickySessionRemove(true);
                continue;
            }
            if (MCMPConstants.STICKYSESSIONFORCE.equals(name)) {
                if (!"no".equalsIgnoreCase(value)) continue;
                balancer.setStickySessionForce(false);
                continue;
            }
            if (MCMPConstants.JVMROUTE.equals(name)) {
                node.setJvmRoute(value);
                continue;
            }
            if (MCMPConstants.DOMAIN.equals(name)) {
                node.setDomain(value);
                continue;
            }
            if (MCMPConstants.HOST.equals(name)) {
                node.setHostname(value);
                continue;
            }
            if (MCMPConstants.PORT.equals(name)) {
                node.setPort(Integer.parseInt(value));
                continue;
            }
            if (MCMPConstants.TYPE.equals(name)) {
                node.setType(value);
                continue;
            }
            if (MCMPConstants.REVERSED.equals(name)) continue;
            if (MCMPConstants.FLUSH_PACKET.equals(name)) {
                if ("on".equalsIgnoreCase(value)) {
                    node.setFlushPackets(true);
                    continue;
                }
                if (!"auto".equalsIgnoreCase(value)) continue;
                node.setFlushPackets(true);
                continue;
            }
            if (MCMPConstants.FLUSH_WAIT.equals(name)) {
                node.setFlushwait(Integer.valueOf(value));
                continue;
            }
            if (MCMPConstants.PING.equals(name)) {
                node.setPing(Integer.valueOf(value));
                continue;
            }
            if (MCMPConstants.SMAX.equals(name)) {
                node.setSmax(Integer.valueOf(value));
                continue;
            }
            if (MCMPConstants.TTL.equals(name)) {
                node.setTtl(Integer.valueOf(value).intValue());
                continue;
            }
            if (MCMPConstants.TIMEOUT.equals(name)) {
                node.setTimeout(Integer.valueOf(value));
                continue;
            }
            if (MCMPConstants.CONTEXT.equals(name)) {
                String[] stringArray = value.split(",");
                contexts = Arrays.asList(stringArray);
                continue;
            }
            if (MCMPConstants.ALIAS.equals(name)) {
                String[] stringArray = value.split(",");
                hosts = Arrays.asList(stringArray);
                continue;
            }
            MCMPHandler.processError(TYPESYNTAX, SBADFLD + name + SBADFLD1, exchange);
            return;
        }
        try {
            NodeConfig config = node.build();
            if (this.container.addNode(config, balancer, exchange.getIoThread(), exchange.getConnection().getByteBufferPool())) {
                if (contexts != null && hosts != null) {
                    for (String string : contexts) {
                        this.container.enableContext(string, config.getJvmRoute(), hosts);
                    }
                }
                MCMPHandler.processOK(exchange);
            } else {
                MCMPHandler.processError(MCMPErrorCode.NODE_STILL_EXISTS, exchange);
            }
        }
        catch (Exception e) {
            MCMPHandler.processError(MCMPErrorCode.CANT_UPDATE_NODE, exchange);
        }
    }

    void processCommand(HttpServerExchange exchange, RequestData requestData, MCMPAction action) throws IOException {
        if (exchange.getRequestPath().equals("*") || exchange.getRequestPath().endsWith("/*")) {
            this.processNodeCommand(exchange, requestData, action);
        } else {
            this.processAppCommand(exchange, requestData, action);
        }
    }

    void processNodeCommand(HttpServerExchange exchange, RequestData requestData, MCMPAction action) throws IOException {
        String jvmRoute = requestData.getFirst(MCMPConstants.JVMROUTE);
        if (jvmRoute == null) {
            MCMPHandler.processError(TYPESYNTAX, SMISFLD, exchange);
            return;
        }
        if (this.processNodeCommand(jvmRoute, action)) {
            MCMPHandler.processOK(exchange);
        } else {
            MCMPHandler.processError(MCMPErrorCode.CANT_UPDATE_NODE, exchange);
        }
    }

    boolean processNodeCommand(String jvmRoute, MCMPAction action) throws IOException {
        switch (action) {
            case ENABLE: {
                return this.container.enableNode(jvmRoute);
            }
            case DISABLE: {
                return this.container.disableNode(jvmRoute);
            }
            case STOP: {
                return this.container.stopNode(jvmRoute);
            }
            case REMOVE: {
                return this.container.removeNode(jvmRoute) != null;
            }
        }
        return false;
    }

    void processAppCommand(HttpServerExchange exchange, RequestData requestData, MCMPAction action) throws IOException {
        List<String> virtualHosts;
        String contextPath = requestData.getFirst(MCMPConstants.CONTEXT);
        String jvmRoute = requestData.getFirst(MCMPConstants.JVMROUTE);
        String aliases = requestData.getFirst(MCMPConstants.ALIAS);
        if (contextPath == null || jvmRoute == null || aliases == null) {
            MCMPHandler.processError(TYPESYNTAX, SMISFLD, exchange);
            return;
        }
        List<String> list = virtualHosts = aliases != null ? Arrays.asList(aliases.split(",")) : null;
        if (virtualHosts == null || virtualHosts.isEmpty()) {
            MCMPHandler.processError(TYPESYNTAX, SCONBAD, exchange);
            return;
        }
        String response = null;
        switch (action) {
            case ENABLE: {
                if (this.container.enableContext(contextPath, jvmRoute, virtualHosts)) break;
                MCMPHandler.processError(MCMPErrorCode.CANT_UPDATE_CONTEXT, exchange);
                return;
            }
            case DISABLE: {
                if (this.container.disableContext(contextPath, jvmRoute, virtualHosts)) break;
                MCMPHandler.processError(MCMPErrorCode.CANT_UPDATE_CONTEXT, exchange);
                return;
            }
            case STOP: {
                int i = this.container.stopContext(contextPath, jvmRoute, virtualHosts);
                StringBuilder builder = new StringBuilder();
                builder.append("Type=STOP-APP-RSP,JvmRoute=").append(jvmRoute);
                builder.append("Alias=").append(aliases);
                builder.append("Context=").append(contextPath);
                builder.append("Requests=").append(i);
                response = builder.toString();
                break;
            }
            case REMOVE: {
                if (this.container.removeContext(contextPath, jvmRoute, virtualHosts)) break;
                MCMPHandler.processError(MCMPErrorCode.CANT_UPDATE_CONTEXT, exchange);
                return;
            }
            default: {
                MCMPHandler.processError(TYPESYNTAX, SMISFLD, exchange);
                return;
            }
        }
        if (response != null) {
            MCMPHandler.sendResponse(exchange, response);
        } else {
            MCMPHandler.processOK(exchange);
        }
    }

    void processStatus(final HttpServerExchange exchange, RequestData requestData) throws IOException {
        final String jvmRoute = requestData.getFirst(MCMPConstants.JVMROUTE);
        String loadValue = requestData.getFirst(MCMPConstants.LOAD);
        if (loadValue == null || jvmRoute == null) {
            MCMPHandler.processError(TYPESYNTAX, SMISFLD, exchange);
            return;
        }
        UndertowLogger.ROOT_LOGGER.receivedNodeLoad(jvmRoute, loadValue);
        final int load = Integer.valueOf(loadValue);
        if (load > 0 || load == -2) {
            final Node node = this.container.getNode(jvmRoute);
            if (node == null) {
                MCMPHandler.processError(MCMPErrorCode.CANT_READ_NODE, exchange);
                return;
            }
            NodePingUtil.PingCallback callback = new NodePingUtil.PingCallback(){

                @Override
                public void completed() {
                    String response = "Type=STATUS-RSP&State=OK&JVMRoute=" + jvmRoute + "&id=" + MCMPHandler.this.creationTime;
                    try {
                        if (load > 0) {
                            node.updateLoad(load);
                        }
                        MCMPHandler.sendResponse(exchange, response);
                    }
                    catch (Exception e) {
                        UndertowLogger.ROOT_LOGGER.failedToSendPingResponse(e);
                    }
                }

                @Override
                public void failed() {
                    String response = "Type=STATUS-RSP&State=NOTOK&JVMRoute=" + jvmRoute + "&id=" + MCMPHandler.this.creationTime;
                    try {
                        node.markInError();
                        MCMPHandler.sendResponse(exchange, response);
                    }
                    catch (Exception e) {
                        UndertowLogger.ROOT_LOGGER.failedToSendPingResponseDBG(e, node.getJvmRoute(), jvmRoute);
                    }
                }
            };
            node.ping(exchange, callback);
        } else if (load == 0) {
            Node node = this.container.getNode(jvmRoute);
            if (node != null) {
                node.hotStandby();
                MCMPHandler.sendResponse(exchange, "Type=STATUS-RSP&State=OK&JVMRoute=" + jvmRoute + "&id=" + this.creationTime);
            } else {
                MCMPHandler.processError(MCMPErrorCode.CANT_READ_NODE, exchange);
            }
        } else if (load == -1) {
            Node node = this.container.getNode(jvmRoute);
            if (node != null) {
                node.markInError();
                MCMPHandler.sendResponse(exchange, "Type=STATUS-RSP&State=NOTOK&JVMRoute=" + jvmRoute + "&id=" + this.creationTime);
            } else {
                MCMPHandler.processError(MCMPErrorCode.CANT_READ_NODE, exchange);
            }
        } else {
            MCMPHandler.processError(TYPESYNTAX, SMISFLD, exchange);
        }
    }

    void processPing(final HttpServerExchange exchange, RequestData requestData) throws IOException {
        Node nodeConfig;
        String jvmRoute = requestData.getFirst(MCMPConstants.JVMROUTE);
        String scheme = requestData.getFirst(MCMPConstants.SCHEME);
        String host = requestData.getFirst(MCMPConstants.HOST);
        String port = requestData.getFirst(MCMPConstants.PORT);
        final String OK = "Type=PING-RSP&State=OK&id=" + this.creationTime;
        final String NOTOK = "Type=PING-RSP&State=NOTOK&id=" + this.creationTime;
        if (jvmRoute != null) {
            nodeConfig = this.container.getNode(jvmRoute);
            if (nodeConfig == null) {
                MCMPHandler.sendResponse(exchange, NOTOK);
                return;
            }
        } else {
            if (scheme == null && host == null && port == null) {
                MCMPHandler.sendResponse(exchange, OK);
                return;
            }
            if (host == null || port == null) {
                MCMPHandler.processError(TYPESYNTAX, SMISFLD, exchange);
                return;
            }
            this.checkHostUp(scheme, host, Integer.valueOf(port), exchange, new NodePingUtil.PingCallback(){

                @Override
                public void completed() {
                    MCMPHandler.sendResponse(exchange, OK);
                }

                @Override
                public void failed() {
                    MCMPHandler.sendResponse(exchange, NOTOK);
                }
            });
            return;
        }
        NodePingUtil.PingCallback callback = new NodePingUtil.PingCallback(){

            @Override
            public void completed() {
                try {
                    MCMPHandler.sendResponse(exchange, OK);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void failed() {
                try {
                    nodeConfig.markInError();
                    MCMPHandler.sendResponse(exchange, NOTOK);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        nodeConfig.ping(exchange, callback);
    }

    protected void processInfo(HttpServerExchange exchange) throws IOException {
        String data = this.processInfoString();
        exchange.getResponseHeaders().add(Headers.SERVER, MOD_CLUSTER_EXPOSED_VERSION);
        MCMPHandler.sendResponse(exchange, data);
    }

    protected String processInfoString() {
        StringBuilder builder = new StringBuilder();
        ArrayList<Node.VHostMapping> vHosts = new ArrayList<Node.VHostMapping>();
        ArrayList<Context> contexts = new ArrayList<Context>();
        Collection<Node> nodes = this.container.getNodes();
        for (Node node : nodes) {
            MCMPInfoUtil.printInfo(node, builder);
            vHosts.addAll(node.getVHosts());
            contexts.addAll(node.getContexts());
        }
        for (Node.VHostMapping vHost : vHosts) {
            MCMPInfoUtil.printInfo(vHost, builder);
        }
        for (Context context : contexts) {
            MCMPInfoUtil.printInfo(context, builder);
        }
        return builder.toString();
    }

    protected void processDump(HttpServerExchange exchange) throws IOException {
        String data = this.processDumpString();
        exchange.getResponseHeaders().add(Headers.SERVER, MOD_CLUSTER_EXPOSED_VERSION);
        MCMPHandler.sendResponse(exchange, data);
    }

    protected String processDumpString() {
        StringBuilder builder = new StringBuilder();
        Collection<Balancer> balancers = this.container.getBalancers();
        for (Balancer balancer : balancers) {
            MCMPInfoUtil.printDump(balancer, builder);
        }
        ArrayList<Node.VHostMapping> vHosts = new ArrayList<Node.VHostMapping>();
        ArrayList<Context> contexts = new ArrayList<Context>();
        Collection<Node> nodes = this.container.getNodes();
        for (Node node : nodes) {
            MCMPInfoUtil.printDump(node, builder);
            vHosts.addAll(node.getVHosts());
            contexts.addAll(node.getContexts());
        }
        for (Node.VHostMapping vHost : vHosts) {
            MCMPInfoUtil.printDump(vHost, builder);
        }
        for (Context context : contexts) {
            MCMPInfoUtil.printDump(context, builder);
        }
        return builder.toString();
    }

    protected void checkHostUp(String scheme, String host, int port, HttpServerExchange exchange, NodePingUtil.PingCallback callback) {
        XnioSsl xnioSsl = null;
        OptionMap options = OptionMap.builder().set(Options.TCP_NODELAY, true).getMap();
        try {
            if ("ajp".equalsIgnoreCase(scheme) || "http".equalsIgnoreCase(scheme)) {
                URI uri = new URI(scheme, null, host, port, "/", null, null);
                NodePingUtil.pingHttpClient(uri, callback, exchange, this.container.getClient(), xnioSsl, options);
            } else {
                InetSocketAddress address = new InetSocketAddress(host, port);
                NodePingUtil.pingHost(address, exchange, callback, options);
            }
        }
        catch (URISyntaxException e) {
            callback.failed();
        }
    }

    static void sendResponse(HttpServerExchange exchange, String response) {
        exchange.setStatusCode(200);
        exchange.getResponseHeaders().add(Headers.CONTENT_TYPE, CONTENT_TYPE);
        Sender sender = exchange.getResponseSender();
        UndertowLogger.ROOT_LOGGER.mcmpSendingResponse(exchange.getSourceAddress(), exchange.getStatusCode(), exchange.getResponseHeaders(), response);
        sender.send(response);
    }

    static void processOK(HttpServerExchange exchange) throws IOException {
        exchange.setStatusCode(200);
        exchange.getResponseHeaders().add(Headers.CONTENT_TYPE, CONTENT_TYPE);
        exchange.endExchange();
    }

    static void processError(MCMPErrorCode errorCode, HttpServerExchange exchange) {
        MCMPHandler.processError(errorCode.getType(), errorCode.getMessage(), exchange);
    }

    static void processError(String type, String errString, HttpServerExchange exchange) {
        exchange.setStatusCode(500);
        exchange.getResponseHeaders().add(Headers.CONTENT_TYPE, CONTENT_TYPE);
        exchange.getResponseHeaders().add(new HttpString("Version"), VERSION_PROTOCOL);
        exchange.getResponseHeaders().add(new HttpString("Type"), type);
        exchange.getResponseHeaders().add(new HttpString("Mess"), errString);
        exchange.endExchange();
        UndertowLogger.ROOT_LOGGER.mcmpProcessingError(type, errString);
    }

    RequestData parseFormData(HttpServerExchange exchange) throws IOException {
        FormDataParser parser = this.parserFactory.createParser(exchange);
        FormData formData = parser.parseBlocking();
        RequestData data = new RequestData();
        for (String name : formData) {
            HttpString key = new HttpString(name);
            data.add(key, formData.get(name));
        }
        return data;
    }

    private static void checkStringForSuspiciousCharacters(String data) {
        for (int i = 0; i < data.length(); ++i) {
            char c = data.charAt(i);
            if (c != '>' && c != '<' && c != '\\' && c != '\"' && c != '\n' && c != '\r') continue;
            throw UndertowMessages.MESSAGES.mcmpMessageRejectedDueToSuspiciousCharacters(data);
        }
    }

    static boolean checkString(String value) {
        return value != null && value.length() > 0;
    }

    static class RequestData {
        private final Map<HttpString, Deque<String>> values = new LinkedHashMap<HttpString, Deque<String>>();

        RequestData() {
        }

        Iterator<HttpString> iterator() {
            return this.values.keySet().iterator();
        }

        void add(HttpString name, Deque<FormData.FormValue> values) {
            MCMPHandler.checkStringForSuspiciousCharacters(name.toString());
            for (FormData.FormValue value : values) {
                this.add(name, value);
            }
        }

        void addValues(HttpString name, Deque<String> value) {
            Deque<String> values = this.values.get(name);
            for (String i : value) {
                MCMPHandler.checkStringForSuspiciousCharacters(i);
            }
            if (values == null) {
                this.values.put(name, value);
            } else {
                values.addAll(value);
            }
        }

        void add(HttpString name, FormData.FormValue value) {
            Deque<String> values = this.values.get(name);
            if (values == null) {
                values = new ArrayDeque<String>(1);
                this.values.put(name, values);
            }
            String stringVal = value.getValue();
            MCMPHandler.checkStringForSuspiciousCharacters(stringVal);
            values.add(stringVal);
        }

        String getFirst(HttpString name) {
            Deque<String> deque = this.values.get(name);
            return deque == null ? null : deque.peekFirst();
        }
    }

    static enum MCMPAction {
        ENABLE,
        DISABLE,
        STOP,
        REMOVE;

    }
}

