/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.ajp;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.protocols.ajp.AbstractAjpClientStreamSinkChannel;
import io.undertow.protocols.ajp.AbstractAjpClientStreamSourceChannel;
import io.undertow.protocols.ajp.AjpClientFramePriority;
import io.undertow.protocols.ajp.AjpClientRequestClientStreamSinkChannel;
import io.undertow.protocols.ajp.AjpClientResponseStreamSourceChannel;
import io.undertow.protocols.ajp.AjpResponseParser;
import io.undertow.server.protocol.framed.AbstractFramedChannel;
import io.undertow.server.protocol.framed.AbstractFramedStreamSourceChannel;
import io.undertow.server.protocol.framed.FrameHeaderData;
import io.undertow.util.Attachable;
import io.undertow.util.HeaderMap;
import io.undertow.util.HttpString;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.StreamConnection;

public class AjpClientChannel
extends AbstractFramedChannel<AjpClientChannel, AbstractAjpClientStreamSourceChannel, AbstractAjpClientStreamSinkChannel> {
    private final AjpResponseParser ajpParser = new AjpResponseParser();
    private AjpClientResponseStreamSourceChannel source;
    private AjpClientRequestClientStreamSinkChannel sink;
    boolean sinkDone = true;
    boolean sourceDone = true;
    private boolean lastFrameSent;
    private boolean lastFrameRecieved;

    public AjpClientChannel(StreamConnection connectedStreamChannel, Pool<ByteBuffer> bufferPool, OptionMap settings) {
        super(connectedStreamChannel, bufferPool, AjpClientFramePriority.INSTANCE, null, settings);
    }

    @Override
    protected AbstractAjpClientStreamSourceChannel createChannel(FrameHeaderData frameHeaderData, Pooled<ByteBuffer> frameData) throws IOException {
        if (frameHeaderData instanceof SendHeadersResponse) {
            AjpClientResponseStreamSourceChannel sourceChannel;
            SendHeadersResponse h = (SendHeadersResponse)frameHeaderData;
            this.source = sourceChannel = new AjpClientResponseStreamSourceChannel(this, h.headers, h.statusCode, h.reasonPhrase, frameData, (int)frameHeaderData.getFrameLength());
            return sourceChannel;
        }
        if (frameHeaderData instanceof RequestBodyChunk) {
            RequestBodyChunk r = (RequestBodyChunk)frameHeaderData;
            this.sink.chunkRequested(r.getLength());
            frameData.free();
            return null;
        }
        frameData.free();
        throw new RuntimeException("TODO: unknown frame");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected FrameHeaderData parseFrame(ByteBuffer data) throws IOException {
        this.ajpParser.parse(data);
        if (this.ajpParser.isComplete()) {
            try {
                AjpResponseParser parser = this.ajpParser;
                if (parser.prefix == 4) {
                    SendHeadersResponse sendHeadersResponse = new SendHeadersResponse(parser.statusCode, parser.reasonPhrase, parser.headers);
                    return sendHeadersResponse;
                }
                if (parser.prefix == 6) {
                    RequestBodyChunk requestBodyChunk = new RequestBodyChunk(parser.readBodyChunkSize);
                    return requestBodyChunk;
                }
                if (parser.prefix == 3) {
                    SendBodyChunk sendBodyChunk = new SendBodyChunk(parser.currentIntegerPart + 1);
                    return sendBodyChunk;
                }
                if (parser.prefix == 5) {
                    boolean persistent;
                    boolean bl = persistent = parser.currentIntegerPart != 0;
                    if (!persistent) {
                        this.lastFrameRecieved = true;
                        this.lastFrameSent = true;
                    }
                    EndResponse endResponse = new EndResponse();
                    return endResponse;
                }
                UndertowLogger.ROOT_LOGGER.debug("UNKOWN FRAME");
            }
            finally {
                this.ajpParser.reset();
            }
        }
        return null;
    }

    public AjpClientRequestClientStreamSinkChannel sendRequest(HttpString method, String path, HttpString protocol, HeaderMap headers, Attachable attachable, ChannelListener<AjpClientRequestClientStreamSinkChannel> finishListener) {
        AjpClientRequestClientStreamSinkChannel ajpClientRequestStreamSinkChannel;
        if (!this.sinkDone || !this.sourceDone) {
            throw UndertowMessages.MESSAGES.ajpRequestAlreadyInProgress();
        }
        this.sinkDone = false;
        this.sourceDone = false;
        this.sink = ajpClientRequestStreamSinkChannel = new AjpClientRequestClientStreamSinkChannel(this, finishListener, headers, path, method, protocol, attachable);
        this.source = null;
        return ajpClientRequestStreamSinkChannel;
    }

    @Override
    protected boolean isLastFrameReceived() {
        return this.lastFrameRecieved;
    }

    @Override
    protected boolean isLastFrameSent() {
        return this.lastFrameSent;
    }

    @Override
    protected void lastDataRead() {
        this.lastFrameRecieved = true;
        this.lastFrameSent = true;
        IoUtils.safeClose((Closeable)((Object)this));
    }

    @Override
    protected void handleBrokenSourceChannel(Throwable e) {
        IoUtils.safeClose((Closeable[])new Closeable[]{this.source, this.sink});
        UndertowLogger.REQUEST_IO_LOGGER.ioException(new IOException(e));
        IoUtils.safeClose((Closeable)((Object)this));
    }

    @Override
    protected void handleBrokenSinkChannel(Throwable e) {
        IoUtils.safeClose((Closeable[])new Closeable[]{this.source, this.sink});
        UndertowLogger.REQUEST_IO_LOGGER.ioException(new IOException(e));
        IoUtils.safeClose((Closeable)((Object)this));
    }

    @Override
    protected void closeSubChannels() {
        IoUtils.safeClose((Closeable[])new Closeable[]{this.source, this.sink});
    }

    void sinkDone() {
        this.sinkDone = true;
        if (this.sourceDone) {
            this.sink = null;
            this.source = null;
        }
    }

    void sourceDone() {
        this.sourceDone = true;
        if (this.sinkDone) {
            this.sink = null;
            this.source = null;
        } else {
            this.sink.startDiscard();
        }
    }

    @Override
    public boolean isOpen() {
        return super.isOpen() && !this.lastFrameSent && !this.lastFrameRecieved;
    }

    @Override
    protected synchronized void recalculateHeldFrames() throws IOException {
        super.recalculateHeldFrames();
    }

    class EndResponse
    implements FrameHeaderData {
        EndResponse() {
        }

        @Override
        public long getFrameLength() {
            return 0L;
        }

        @Override
        public AbstractFramedStreamSourceChannel<?, ?, ?> getExistingChannel() {
            return AjpClientChannel.this.source;
        }
    }

    class SendBodyChunk
    implements FrameHeaderData {
        private final int length;

        SendBodyChunk(int length) {
            this.length = length;
        }

        @Override
        public long getFrameLength() {
            return this.length;
        }

        @Override
        public AbstractFramedStreamSourceChannel<?, ?, ?> getExistingChannel() {
            return AjpClientChannel.this.source;
        }
    }

    class RequestBodyChunk
    implements FrameHeaderData {
        private final int length;

        RequestBodyChunk(int length) {
            this.length = length;
        }

        public int getLength() {
            return this.length;
        }

        @Override
        public long getFrameLength() {
            return 0L;
        }

        @Override
        public AbstractFramedStreamSourceChannel<?, ?, ?> getExistingChannel() {
            return null;
        }
    }

    class SendHeadersResponse
    implements FrameHeaderData {
        private final int statusCode;
        private final String reasonPhrase;
        private final HeaderMap headers;

        SendHeadersResponse(int statusCode, String reasonPhrase, HeaderMap headers) {
            this.statusCode = statusCode;
            this.reasonPhrase = reasonPhrase;
            this.headers = headers;
        }

        @Override
        public long getFrameLength() {
            return 0L;
        }

        @Override
        public AbstractFramedStreamSourceChannel<?, ?, ?> getExistingChannel() {
            return null;
        }
    }
}

