/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol;

import io.undertow.UndertowLogger;
import io.undertow.server.ServerConnection;
import java.io.Closeable;
import java.util.concurrent.TimeUnit;
import org.xnio.IoUtils;
import org.xnio.XnioExecutor;

public final class ParseTimeoutUpdater
implements Runnable,
ServerConnection.CloseListener {
    private final ServerConnection connection;
    private final long requestParseTimeout;
    private final long requestIdleTimeout;
    private volatile XnioExecutor.Key handle;
    private volatile long expireTime = -1L;
    private boolean parsing = false;
    private static final int FUZZ_FACTOR = 50;

    public ParseTimeoutUpdater(ServerConnection channel, long requestParseTimeout, long requestIdleTimeout) {
        this.connection = channel;
        this.requestParseTimeout = requestParseTimeout;
        this.requestIdleTimeout = requestIdleTimeout;
    }

    public void connectionIdle() {
        this.parsing = false;
        this.handleSchedule(this.requestIdleTimeout);
    }

    private void handleSchedule(long timeout) {
        if (timeout == -1L) {
            this.expireTime = -1L;
            return;
        }
        long newExpireTime = System.currentTimeMillis() + timeout;
        long oldExpireTime = this.expireTime;
        this.expireTime = newExpireTime;
        if (newExpireTime < oldExpireTime && this.handle != null) {
            this.handle.remove();
            this.handle = null;
        }
        if (this.handle == null) {
            this.handle = this.connection.getIoThread().executeAfter((Runnable)this, timeout + 50L, TimeUnit.MILLISECONDS);
        }
    }

    public void failedParse() {
        if (!this.parsing) {
            this.parsing = true;
            this.handleSchedule(this.requestParseTimeout);
        }
    }

    public void requestStarted() {
        this.expireTime = -1L;
        this.parsing = false;
    }

    @Override
    public void run() {
        if (!this.connection.isOpen()) {
            return;
        }
        this.handle = null;
        if (this.expireTime > 0L) {
            long now = System.currentTimeMillis();
            if (this.expireTime > now) {
                this.handle = this.connection.getIoThread().executeAfter((Runnable)this, this.expireTime - now + 50L, TimeUnit.MILLISECONDS);
            } else {
                UndertowLogger.REQUEST_LOGGER.parseRequestTimedOut(this.connection.getPeerAddress());
                IoUtils.safeClose((Closeable)((Object)this.connection));
            }
        }
    }

    @Override
    public void closed(ServerConnection connection) {
        if (this.handle != null) {
            this.handle.remove();
            this.handle = null;
        }
    }
}

