/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.security.impl;

import io.undertow.UndertowMessages;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.AuthenticationMechanismFactory;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.idm.PasswordCredential;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.util.HttpString;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GenericHeaderAuthenticationMechanism
implements AuthenticationMechanism {
    public static final String NAME = "GENERIC_HEADER";
    public static final String IDENTITY_HEADER = "identity-header";
    public static final String SESSION_HEADER = "session-header";
    private final String mechanismName;
    private final List<HttpString> identityHeaders;
    private final List<String> sessionCookieNames;
    private final IdentityManager identityManager;

    public GenericHeaderAuthenticationMechanism(String mechanismName, List<HttpString> identityHeaders, List<String> sessionCookieNames, IdentityManager identityManager) {
        this.mechanismName = mechanismName;
        this.identityHeaders = identityHeaders;
        this.sessionCookieNames = sessionCookieNames;
        this.identityManager = identityManager;
    }

    @Override
    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        String principal = this.getPrincipal(exchange);
        if (principal == null) {
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
        }
        String session = this.getSession(exchange);
        if (session == null) {
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
        }
        Account account = this.identityManager.verify(principal, new PasswordCredential(session.toCharArray()));
        if (account == null) {
            securityContext.authenticationFailed(UndertowMessages.MESSAGES.authenticationFailed(principal), this.mechanismName);
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
        securityContext.authenticationComplete(account, this.mechanismName, false);
        return AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
    }

    private String getSession(HttpServerExchange exchange) {
        for (String header : this.sessionCookieNames) {
            Cookie cookie = exchange.getRequestCookies().get(header);
            if (cookie == null) continue;
            return cookie.getValue();
        }
        return null;
    }

    private String getPrincipal(HttpServerExchange exchange) {
        for (HttpString header : this.identityHeaders) {
            String res = exchange.getRequestHeaders().getFirst(header);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    @Override
    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        return new AuthenticationMechanism.ChallengeResult(false);
    }

    public static class Factory
    implements AuthenticationMechanismFactory {
        private final IdentityManager identityManager;

        public Factory(IdentityManager identityManager) {
            this.identityManager = identityManager;
        }

        @Override
        public AuthenticationMechanism create(String mechanismName, FormParserFactory formParserFactory, Map<String, String> properties) {
            String identity = properties.get(GenericHeaderAuthenticationMechanism.IDENTITY_HEADER);
            if (identity == null) {
                throw UndertowMessages.MESSAGES.authenticationPropertyNotSet(mechanismName, GenericHeaderAuthenticationMechanism.IDENTITY_HEADER);
            }
            String session = properties.get(GenericHeaderAuthenticationMechanism.SESSION_HEADER);
            if (session == null) {
                throw UndertowMessages.MESSAGES.authenticationPropertyNotSet(mechanismName, GenericHeaderAuthenticationMechanism.SESSION_HEADER);
            }
            ArrayList<HttpString> ids = new ArrayList<HttpString>();
            for (String s : identity.split(",")) {
                ids.add(new HttpString(s));
            }
            ArrayList<String> sessions = new ArrayList<String>();
            for (String s : session.split(",")) {
                sessions.add(s);
            }
            return new GenericHeaderAuthenticationMechanism(mechanismName, ids, sessions, this.identityManager);
        }
    }
}

