/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers.security;

import io.undertow.security.api.RoleMappingManager;
import io.undertow.security.api.SecurityContext;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletAttachments;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import io.undertow.servlet.spec.HttpServletResponseImpl;
import java.util.List;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletSecurityRoleHandler
implements HttpHandler {
    private final HttpHandler next;
    private final RoleMappingManager roleMappingManager;

    public ServletSecurityRoleHandler(HttpHandler next, RoleMappingManager roleMappingManager) {
        this.next = next;
        this.roleMappingManager = roleMappingManager;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        List roles = exchange.getAttachmentList(ServletAttachments.REQUIRED_ROLES);
        SecurityContext sc = (SecurityContext)exchange.getAttachment(SecurityContext.ATTACHMENT_KEY);
        exchange.putAttachment(ServletAttachments.SERVLET_ROLE_MAPPINGS, (Object)this.roleMappingManager);
        HttpServletRequestImpl request = HttpServletRequestImpl.getRequestImpl((ServletRequest)exchange.getAttachment(HttpServletRequestImpl.ATTACHMENT_KEY));
        if (request.getDispatcherType() != DispatcherType.REQUEST) {
            this.next.handleRequest(exchange);
        } else if (roles == null || roles.isEmpty()) {
            this.next.handleRequest(exchange);
        } else {
            for (Set roleSet : roles) {
                boolean found = false;
                for (String role : roleSet) {
                    if (!this.roleMappingManager.isUserInRole(role, sc)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                HttpServletResponse response = (HttpServletResponse)exchange.getAttachment(HttpServletResponseImpl.ATTACHMENT_KEY);
                response.sendError(403);
                return;
            }
            this.next.handleRequest(exchange);
        }
    }
}

