/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.servlet.websockets.ServletWebSocketHttpExchange;
import io.undertow.websockets.core.handler.WebSocketConnectionCallback;
import io.undertow.websockets.core.protocol.Handshake;
import io.undertow.websockets.jsr.ConfiguredServerEndpoint;
import io.undertow.websockets.jsr.EndpointSessionHandler;
import io.undertow.websockets.jsr.ServerWebSocketContainer;
import io.undertow.websockets.jsr.handshake.HandshakeUtil;
import io.undertow.websockets.jsr.handshake.JsrHybi07Handshake;
import io.undertow.websockets.jsr.handshake.JsrHybi08Handshake;
import io.undertow.websockets.jsr.handshake.JsrHybi13Handshake;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.websocket.server.ServerContainer;

public class JsrWebSocketFilter
implements Filter {
    private WebSocketConnectionCallback callback;
    private Map<ConfiguredServerEndpoint, List<Handshake>> handshakes;
    private List<ConfiguredServerEndpoint> configuredServerEndpoints;

    protected Map<ConfiguredServerEndpoint, List<Handshake>> handshakes(List<ConfiguredServerEndpoint> configs) {
        IdentityHashMap<ConfiguredServerEndpoint, List<Handshake>> ret = new IdentityHashMap<ConfiguredServerEndpoint, List<Handshake>>();
        for (ConfiguredServerEndpoint config : configs) {
            ArrayList<Object> handshakes = new ArrayList<Object>();
            handshakes.add((Object)new JsrHybi13Handshake(config));
            handshakes.add((Object)new JsrHybi08Handshake(config));
            handshakes.add((Object)new JsrHybi07Handshake(config));
            ret.put(config, handshakes);
        }
        return ret;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        ServerWebSocketContainer container = (ServerWebSocketContainer)filterConfig.getServletContext().getAttribute(ServerContainer.class.getName());
        container.deploymentComplete();
        this.configuredServerEndpoints = new ArrayList<ConfiguredServerEndpoint>(container.getConfiguredServerEndpoints());
        Collections.sort(this.configuredServerEndpoints, new Comparator<ConfiguredServerEndpoint>(){

            @Override
            public int compare(ConfiguredServerEndpoint o1, ConfiguredServerEndpoint o2) {
                return o1.getPathTemplate().compareTo(o2.getPathTemplate());
            }
        });
        this.handshakes = this.handshakes(this.configuredServerEndpoints);
        this.callback = new EndpointSessionHandler(container);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        if (req.getHeader("Upgrade") != null) {
            ServletWebSocketHttpExchange facade = new ServletWebSocketHttpExchange(req, resp);
            String path = req.getPathInfo() == null ? req.getServletPath() : req.getServletPath() + req.getPathInfo();
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            HashMap params = new HashMap();
            for (ConfiguredServerEndpoint endpoint : this.configuredServerEndpoints) {
                if (!endpoint.getPathTemplate().matches(path, params)) continue;
                Handshake handshaker = null;
                for (Handshake method : this.handshakes.get(endpoint)) {
                    if (!method.matches((WebSocketHttpExchange)facade)) continue;
                    handshaker = method;
                    break;
                }
                if (handshaker == null) {
                    chain.doFilter(request, response);
                    continue;
                }
                facade.putAttachment(HandshakeUtil.PATH_PARAMS, params);
                handshaker.handshake((WebSocketHttpExchange)facade, this.callback);
                return;
            }
            chain.doFilter(request, response);
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }
}

