/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.util.ImmediateInstanceHandle;
import io.undertow.websockets.api.WebSocketSession;
import io.undertow.websockets.api.WebSocketSessionHandler;
import io.undertow.websockets.impl.WebSocketChannelSession;
import io.undertow.websockets.jsr.ConfiguredServerEndpoint;
import io.undertow.websockets.jsr.JsrWebSocketLogger;
import io.undertow.websockets.jsr.ServerWebSocketContainer;
import io.undertow.websockets.jsr.UndertowSession;
import io.undertow.websockets.jsr.handshake.HandshakeUtil;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.io.Closeable;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Session;
import org.xnio.IoUtils;

public final class EndpointSessionHandler
implements WebSocketSessionHandler {
    private final ServerWebSocketContainer container;

    public EndpointSessionHandler(ServerWebSocketContainer container) {
        this.container = container;
    }

    ServerWebSocketContainer getContainer() {
        return this.container;
    }

    public void onSession(WebSocketSession s, WebSocketHttpExchange exchange) {
        WebSocketChannelSession channelSession = (WebSocketChannelSession)s;
        ConfiguredServerEndpoint config = HandshakeUtil.getConfig(channelSession.getChannel());
        try {
            InstanceFactory<Endpoint> endpointFactory = config.getEndpointFactory();
            Object instance = endpointFactory != null ? endpointFactory.createInstance() : new ImmediateInstanceHandle((Object)((Endpoint)config.getEndpointConfiguration().getConfigurator().getEndpointInstance(config.getEndpointConfiguration().getEndpointClass())));
            UndertowSession session = new UndertowSession(channelSession, URI.create(exchange.getRequestURI()), (Map)exchange.getAttachment(HandshakeUtil.PATH_PARAMS), Collections.<String, List<String>>emptyMap(), this, null, (InstanceHandle<Endpoint>)instance, (EndpointConfig)config.getEndpointConfiguration(), exchange.getQueryString(), config.getEncodingFactory().createEncoding((EndpointConfig)config.getEndpointConfiguration()), config.getOpenSessions());
            config.getOpenSessions().add(session);
            session.setMaxBinaryMessageBufferSize(this.getContainer().getDefaultMaxBinaryMessageBufferSize());
            session.setMaxTextMessageBufferSize(this.getContainer().getDefaultMaxTextMessageBufferSize());
            session.getAsyncRemote().setSendTimeout(this.getContainer().getDefaultAsyncSendTimeout());
            ((Endpoint)instance.getInstance()).onOpen((Session)session, (EndpointConfig)config.getEndpointConfiguration());
        }
        catch (InstantiationException e) {
            JsrWebSocketLogger.REQUEST_LOGGER.endpointCreationFailed(e);
            IoUtils.safeClose((Closeable)channelSession.getChannel());
        }
    }
}

