/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.websockets.api.WebSocketFrameHeader;
import io.undertow.websockets.api.WebSocketSession;
import io.undertow.websockets.jsr.AbstractFrameHandler;
import io.undertow.websockets.jsr.PartialFrameHandler;
import io.undertow.websockets.jsr.UndertowSession;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.websocket.DecodeException;
import javax.websocket.Endpoint;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import org.xnio.Buffers;

class MixedFrameHandler
extends PartialFrameHandler {
    final List<ByteBuffer> textFrame = new ArrayList<ByteBuffer>();
    final List<ByteBuffer> binaryFrame = new ArrayList<ByteBuffer>();

    public MixedFrameHandler(UndertowSession session, Endpoint endpoint) {
        super(session, endpoint);
    }

    @Override
    public void onTextFrame(WebSocketSession s, WebSocketFrameHeader header, ByteBuffer ... payload) {
        AbstractFrameHandler.HandlerWrapper handler = this.getHandler(AbstractFrameHandler.FrameType.TEXT);
        if (handler == null) {
            return;
        }
        MessageHandler mHandler = handler.getHandler();
        if (mHandler instanceof MessageHandler.Partial) {
            super.onTextFrame(s, header, payload);
        } else {
            String message = payload.toString();
            if (handler.getMessageType() == String.class) {
                ((MessageHandler.Whole)handler.getHandler()).onMessage((Object)message);
            } else if (handler.getMessageType() == Reader.class) {
                ((MessageHandler.Whole)handler.getHandler()).onMessage((Object)new StringReader(message));
            } else {
                try {
                    Object object = this.getSession().getEncoding().decodeText(handler.getMessageType(), message);
                    ((MessageHandler.Whole)handler.getHandler()).onMessage(object);
                }
                catch (DecodeException e) {
                    this.getEndpoint().onError((Session)this.getSession(), (Throwable)e);
                }
            }
        }
    }

    @Override
    public void onBinaryFrame(WebSocketSession s, WebSocketFrameHeader header, ByteBuffer ... payload) {
        AbstractFrameHandler.HandlerWrapper handler = this.getHandler(AbstractFrameHandler.FrameType.BYTE);
        if (handler == null) {
            return;
        }
        if (handler.getHandler() instanceof MessageHandler.Partial) {
            super.onBinaryFrame(s, header, payload);
        } else {
            MessageHandler.Whole mHandler = (MessageHandler.Whole)handler.getHandler();
            if (handler.getMessageType() == ByteBuffer.class) {
                mHandler.onMessage((Object)MixedFrameHandler.toBuffer(payload));
            } else if (handler.getMessageType() == byte[].class) {
                long size = Buffers.remaining((Buffer[])payload);
                if (size == 0L) {
                    mHandler.onMessage((Object)EMPTY);
                } else {
                    byte[] data = MixedFrameHandler.toArray(payload);
                    mHandler.onMessage((Object)data);
                }
            } else if (handler.getMessageType() == InputStream.class) {
                long size = Buffers.remaining((Buffer[])payload);
                if (size == 0L) {
                    mHandler.onMessage((Object)new ByteArrayInputStream(EMPTY));
                } else {
                    byte[] data = MixedFrameHandler.toArray(payload);
                    mHandler.onMessage((Object)new ByteArrayInputStream(data));
                }
            } else {
                try {
                    Object object = this.getSession().getEncoding().decodeBinary(handler.getMessageType(), MixedFrameHandler.toArray(payload));
                    mHandler.onMessage(object);
                }
                catch (DecodeException e) {
                    this.getEndpoint().onError((Session)this.getSession(), (Throwable)e);
                }
            }
        }
    }
}

