/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.api.ThreadSetupAction;
import io.undertow.servlet.spec.ServletContextImpl;
import io.undertow.servlet.util.ConstructorInstanceFactory;
import io.undertow.servlet.util.ImmediateInstanceHandle;
import io.undertow.util.PathTemplate;
import io.undertow.websockets.WebSocketExtension;
import io.undertow.websockets.client.WebSocketClient;
import io.undertow.websockets.client.WebSocketClientNegotiation;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketVersion;
import io.undertow.websockets.jsr.ConfiguredClientEndpoint;
import io.undertow.websockets.jsr.ConfiguredServerEndpoint;
import io.undertow.websockets.jsr.DefaultContainerConfigurator;
import io.undertow.websockets.jsr.EncodingFactory;
import io.undertow.websockets.jsr.EndpointSessionHandler;
import io.undertow.websockets.jsr.ExtensionImpl;
import io.undertow.websockets.jsr.JsrWebSocketLogger;
import io.undertow.websockets.jsr.JsrWebSocketMessages;
import io.undertow.websockets.jsr.UndertowSession;
import io.undertow.websockets.jsr.WebsocketClientSslProvider;
import io.undertow.websockets.jsr.annotated.AnnotatedEndpoint;
import io.undertow.websockets.jsr.annotated.AnnotatedEndpointFactory;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.servlet.DispatcherType;
import javax.websocket.ClientEndpoint;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.HandshakeResponse;
import javax.websocket.Session;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.XnioWorker;
import org.xnio.http.UpgradeFailedException;
import org.xnio.ssl.XnioSsl;

public class ServerWebSocketContainer
implements ServerContainer,
Closeable {
    public static final String TIMEOUT = "io.undertow.websocket.CONNECT_TIMEOUT";
    public static final int DEFAULT_WEB_SOCKET_TIMEOUT_SECONDS = 10;
    private final ClassIntrospecter classIntrospecter;
    private final Map<Class<?>, ConfiguredClientEndpoint> clientEndpoints = new HashMap();
    private final List<ConfiguredServerEndpoint> configuredServerEndpoints = new ArrayList<ConfiguredServerEndpoint>();
    private final TreeSet<PathTemplate> seenPaths = new TreeSet();
    private final XnioWorker xnioWorker;
    private final Pool<ByteBuffer> bufferPool;
    private final ThreadSetupAction threadSetupAction;
    private final boolean dispatchToWorker;
    private volatile long defaultAsyncSendTimeout;
    private volatile long defaultMaxSessionIdleTimeout;
    private volatile int defaultMaxBinaryMessageBufferSize;
    private volatile int defaultMaxTextMessageBufferSize;
    private volatile boolean deploymentComplete = false;
    private ServletContextImpl contextToAddFilter = null;
    private final List<WebsocketClientSslProvider> clientSslProviders;

    public ServerWebSocketContainer(ClassIntrospecter classIntrospecter, XnioWorker xnioWorker, Pool<ByteBuffer> bufferPool, ThreadSetupAction threadSetupAction, boolean dispatchToWorker, boolean clientMode) {
        this(classIntrospecter, ServerWebSocketContainer.class.getClassLoader(), xnioWorker, bufferPool, threadSetupAction, dispatchToWorker);
    }

    public ServerWebSocketContainer(ClassIntrospecter classIntrospecter, ClassLoader classLoader, XnioWorker xnioWorker, Pool<ByteBuffer> bufferPool, ThreadSetupAction threadSetupAction, boolean dispatchToWorker) {
        this.classIntrospecter = classIntrospecter;
        this.bufferPool = bufferPool;
        this.xnioWorker = xnioWorker;
        this.threadSetupAction = threadSetupAction;
        this.dispatchToWorker = dispatchToWorker;
        ArrayList<WebsocketClientSslProvider> clientSslProviders = new ArrayList<WebsocketClientSslProvider>();
        for (WebsocketClientSslProvider provider : ServiceLoader.load(WebsocketClientSslProvider.class, classLoader)) {
            clientSslProviders.add(provider);
        }
        this.clientSslProviders = Collections.unmodifiableList(clientSslProviders);
    }

    public long getDefaultAsyncSendTimeout() {
        return this.defaultAsyncSendTimeout;
    }

    public void setAsyncSendTimeout(long defaultAsyncSendTimeout) {
        this.defaultAsyncSendTimeout = defaultAsyncSendTimeout;
    }

    public Session connectToServer(Object annotatedEndpointInstance, URI path) throws DeploymentException, IOException {
        WebsocketClientSslProvider provider;
        ConfiguredClientEndpoint config = this.getClientEndpoint(annotatedEndpointInstance.getClass(), false);
        if (config == null) {
            throw JsrWebSocketMessages.MESSAGES.notAValidClientEndpointType(annotatedEndpointInstance.getClass());
        }
        AnnotatedEndpoint instance = config.getFactory().createInstance((InstanceHandle<?>)new ImmediateInstanceHandle(annotatedEndpointInstance));
        XnioSsl ssl = null;
        Iterator<WebsocketClientSslProvider> i$ = this.clientSslProviders.iterator();
        while (i$.hasNext() && (ssl = (provider = i$.next()).getSsl(this.xnioWorker, annotatedEndpointInstance, path)) == null) {
        }
        return this.connectToServerInternal(instance, ssl, config, path);
    }

    public Session connectToServer(Class<?> aClass, URI uri) throws DeploymentException, IOException {
        ConfiguredClientEndpoint config = this.getClientEndpoint(aClass, true);
        if (config == null) {
            throw JsrWebSocketMessages.MESSAGES.notAValidClientEndpointType(aClass);
        }
        try {
            WebsocketClientSslProvider provider;
            AnnotatedEndpointFactory factory = config.getFactory();
            InstanceHandle instance = config.getInstanceFactory().createInstance();
            XnioSsl ssl = null;
            Iterator<WebsocketClientSslProvider> i$ = this.clientSslProviders.iterator();
            while (i$.hasNext() && (ssl = (provider = i$.next()).getSsl(this.xnioWorker, aClass, uri)) == null) {
            }
            return this.connectToServerInternal(factory.createInstance(instance), ssl, config, uri);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public Session connectToServer(Endpoint endpointInstance, ClientEndpointConfig config, URI path) throws DeploymentException, IOException {
        WebSocketChannel channel;
        WebsocketClientSslProvider provider;
        ClientEndpointConfig cec = config != null ? config : ClientEndpointConfig.Builder.create().build();
        ClientNegotiation clientNegotiation = new ClientNegotiation(cec.getPreferredSubprotocols(), ServerWebSocketContainer.toExtensionList(cec.getExtensions()), cec);
        XnioSsl ssl = null;
        Iterator<WebsocketClientSslProvider> i$ = this.clientSslProviders.iterator();
        while (i$.hasNext() && (ssl = (provider = i$.next()).getSsl(this.xnioWorker, endpointInstance, cec, path)) == null) {
        }
        IoFuture session = WebSocketClient.connect((XnioWorker)this.xnioWorker, ssl, this.bufferPool, (OptionMap)OptionMap.EMPTY, (URI)path, (WebSocketVersion)WebSocketVersion.V13, (WebSocketClientNegotiation)clientNegotiation);
        Number timeout = (Number)cec.getUserProperties().get(TIMEOUT);
        if (session.await(timeout == null ? 10L : (long)timeout.intValue(), TimeUnit.SECONDS) == IoFuture.Status.WAITING) {
            session.cancel();
            session.addNotifier((IoFuture.Notifier)new IoFuture.HandlingNotifier<WebSocketChannel, Object>(){

                public void handleDone(WebSocketChannel data, Object attachment) {
                    IoUtils.safeClose((Closeable)data);
                }
            }, null);
            throw JsrWebSocketMessages.MESSAGES.connectionTimedOut();
        }
        try {
            channel = (WebSocketChannel)session.get();
        }
        catch (UpgradeFailedException e) {
            throw new DeploymentException(e.getMessage(), (Throwable)e);
        }
        EndpointSessionHandler sessionHandler = new EndpointSessionHandler(this);
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        HashMap<String, Extension> extMap = new HashMap<String, Extension>();
        for (Extension ext : cec.getExtensions()) {
            extMap.put(ext.getName(), ext);
        }
        for (WebSocketExtension e : clientNegotiation.getSelectedExtensions()) {
            Extension ext = (Extension)extMap.get(e.getName());
            if (ext == null) {
                throw JsrWebSocketMessages.MESSAGES.extensionWasNotPresentInClientHandshake(e.getName(), clientNegotiation.getSupportedExtensions());
            }
            extensions.add(ExtensionImpl.create(e));
        }
        EncodingFactory encodingFactory = EncodingFactory.createFactory(this.classIntrospecter, cec.getDecoders(), cec.getEncoders());
        UndertowSession undertowSession = new UndertowSession(channel, path, Collections.emptyMap(), Collections.emptyMap(), sessionHandler, null, (InstanceHandle<Endpoint>)new ImmediateInstanceHandle((Object)endpointInstance), (EndpointConfig)cec, path.getQuery(), encodingFactory.createEncoding((EndpointConfig)cec), new HashSet<Session>(), clientNegotiation.getSelectedSubProtocol(), extensions);
        endpointInstance.onOpen((Session)undertowSession, (EndpointConfig)cec);
        channel.resumeReceives();
        return undertowSession;
    }

    public Session connectToServer(Class<? extends Endpoint> endpointClass, ClientEndpointConfig cec, URI path) throws DeploymentException, IOException {
        try {
            Endpoint endpoint = endpointClass.newInstance();
            return this.connectToServer(endpoint, cec, path);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private Session connectToServerInternal(Endpoint endpointInstance, XnioSsl ssl, ConfiguredClientEndpoint cec, URI path) throws DeploymentException, IOException {
        WebSocketChannel channel;
        Number timeout;
        ClientNegotiation clientNegotiation = new ClientNegotiation(cec.getConfig().getPreferredSubprotocols(), ServerWebSocketContainer.toExtensionList(cec.getConfig().getExtensions()), cec.getConfig());
        IoFuture session = WebSocketClient.connect((XnioWorker)this.xnioWorker, (XnioSsl)ssl, this.bufferPool, (OptionMap)OptionMap.EMPTY, (URI)path, (WebSocketVersion)WebSocketVersion.V13, (WebSocketClientNegotiation)clientNegotiation);
        IoFuture.Status result = session.await((timeout = (Number)cec.getConfig().getUserProperties().get(TIMEOUT)) == null ? 10L : (long)timeout.intValue(), TimeUnit.SECONDS);
        if (result == IoFuture.Status.WAITING) {
            session.cancel();
            session.addNotifier((IoFuture.Notifier)new IoFuture.HandlingNotifier<WebSocketChannel, Object>(){

                public void handleDone(WebSocketChannel data, Object attachment) {
                    IoUtils.safeClose((Closeable)data);
                }
            }, null);
            throw JsrWebSocketMessages.MESSAGES.connectionTimedOut();
        }
        try {
            channel = (WebSocketChannel)session.get();
        }
        catch (UpgradeFailedException e) {
            throw new DeploymentException(e.getMessage(), (Throwable)e);
        }
        EndpointSessionHandler sessionHandler = new EndpointSessionHandler(this);
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        HashMap<String, Extension> extMap = new HashMap<String, Extension>();
        for (Extension ext : cec.getConfig().getExtensions()) {
            extMap.put(ext.getName(), ext);
        }
        for (WebSocketExtension e : clientNegotiation.getSelectedExtensions()) {
            Extension ext = (Extension)extMap.get(e.getName());
            if (ext == null) {
                throw JsrWebSocketMessages.MESSAGES.extensionWasNotPresentInClientHandshake(e.getName(), clientNegotiation.getSupportedExtensions());
            }
            extensions.add(ExtensionImpl.create(e));
        }
        UndertowSession undertowSession = new UndertowSession(channel, path, Collections.emptyMap(), Collections.emptyMap(), sessionHandler, null, (InstanceHandle<Endpoint>)new ImmediateInstanceHandle((Object)endpointInstance), (EndpointConfig)cec.getConfig(), path.getQuery(), cec.getEncodingFactory().createEncoding((EndpointConfig)cec.getConfig()), new HashSet<Session>(), clientNegotiation.getSelectedSubProtocol(), extensions);
        endpointInstance.onOpen((Session)undertowSession, (EndpointConfig)cec.getConfig());
        channel.resumeReceives();
        return undertowSession;
    }

    public long getDefaultMaxSessionIdleTimeout() {
        return this.defaultMaxSessionIdleTimeout;
    }

    public void setDefaultMaxSessionIdleTimeout(long timeout) {
        this.defaultMaxSessionIdleTimeout = timeout;
    }

    public int getDefaultMaxBinaryMessageBufferSize() {
        return this.defaultMaxBinaryMessageBufferSize;
    }

    public void setDefaultMaxBinaryMessageBufferSize(int defaultMaxBinaryMessageBufferSize) {
        this.defaultMaxBinaryMessageBufferSize = defaultMaxBinaryMessageBufferSize;
    }

    public int getDefaultMaxTextMessageBufferSize() {
        return this.defaultMaxTextMessageBufferSize;
    }

    public void setDefaultMaxTextMessageBufferSize(int defaultMaxTextMessageBufferSize) {
        this.defaultMaxTextMessageBufferSize = defaultMaxTextMessageBufferSize;
    }

    public Set<Extension> getInstalledExtensions() {
        return Collections.emptySet();
    }

    public void invokeEndpointMethod(Executor executor, final Runnable invocation) {
        if (this.dispatchToWorker) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    ServerWebSocketContainer.this.invokeEndpointMethod(invocation);
                }
            });
        } else {
            this.invokeEndpointMethod(invocation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeEndpointMethod(Runnable invocation) {
        ThreadSetupAction.Handle handle = this.threadSetupAction.setup(null);
        try {
            invocation.run();
        }
        finally {
            handle.tearDown();
        }
    }

    public void addEndpoint(Class<?> endpoint) throws DeploymentException {
        if (this.deploymentComplete) {
            throw JsrWebSocketMessages.MESSAGES.cannotAddEndpointAfterDeployment();
        }
        this.addEndpointInternal(endpoint, true);
    }

    private void addEndpointInternal(Class<?> endpoint, boolean requiresCreation) throws DeploymentException {
        ServerEndpoint serverEndpoint = endpoint.getAnnotation(ServerEndpoint.class);
        ClientEndpoint clientEndpoint = endpoint.getAnnotation(ClientEndpoint.class);
        if (serverEndpoint != null) {
            DefaultContainerConfigurator configurator;
            JsrWebSocketLogger.ROOT_LOGGER.addingAnnotatedServerEndpoint(endpoint, serverEndpoint.value());
            PathTemplate template = PathTemplate.create((String)serverEndpoint.value());
            if (this.seenPaths.contains(template)) {
                PathTemplate existing = null;
                for (PathTemplate p : this.seenPaths) {
                    if (p.compareTo(template) != 0) continue;
                    existing = p;
                    break;
                }
                throw JsrWebSocketMessages.MESSAGES.multipleEndpointsWithOverlappingPaths(template, existing);
            }
            this.seenPaths.add(template);
            EncodingFactory encodingFactory = EncodingFactory.createFactory(this.classIntrospecter, serverEndpoint.decoders(), serverEndpoint.encoders());
            AnnotatedEndpointFactory annotatedEndpointFactory = AnnotatedEndpointFactory.create(endpoint, encodingFactory, template.getParameterNames());
            InstanceFactory instanceFactory = null;
            try {
                instanceFactory = this.classIntrospecter.createInstanceFactory(endpoint);
            }
            catch (NoSuchMethodException e) {
                throw JsrWebSocketMessages.MESSAGES.couldNotDeploy(e);
            }
            Class configuratorClass = serverEndpoint.configurator();
            if (configuratorClass != ServerEndpointConfig.Configurator.class) {
                try {
                    configurator = (ServerEndpointConfig.Configurator)configuratorClass.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw JsrWebSocketMessages.MESSAGES.couldNotDeploy(e);
                }
            } else {
                configurator = DefaultContainerConfigurator.INSTANCE;
            }
            ServerEndpointConfig config = ServerEndpointConfig.Builder.create(endpoint, (String)serverEndpoint.value()).decoders(Arrays.asList(serverEndpoint.decoders())).encoders(Arrays.asList(serverEndpoint.encoders())).subprotocols(Arrays.asList(serverEndpoint.subprotocols())).configurator((ServerEndpointConfig.Configurator)configurator).build();
            ConfiguredServerEndpoint confguredServerEndpoint = new ConfiguredServerEndpoint(config, instanceFactory, template, encodingFactory, annotatedEndpointFactory);
            this.configuredServerEndpoints.add(confguredServerEndpoint);
            this.handleAddingFilterMapping();
        } else if (clientEndpoint != null) {
            InstanceFactory instanceFactory;
            JsrWebSocketLogger.ROOT_LOGGER.addingAnnotatedClientEndpoint(endpoint);
            EncodingFactory encodingFactory = EncodingFactory.createFactory(this.classIntrospecter, clientEndpoint.decoders(), clientEndpoint.encoders());
            try {
                instanceFactory = this.classIntrospecter.createInstanceFactory(endpoint);
            }
            catch (Exception e) {
                try {
                    instanceFactory = new ConstructorInstanceFactory(endpoint.getConstructor(new Class[0]));
                }
                catch (NoSuchMethodException e1) {
                    if (requiresCreation) {
                        throw JsrWebSocketMessages.MESSAGES.couldNotDeploy(e);
                    }
                    instanceFactory = new InstanceFactory<Object>(){

                        public InstanceHandle<Object> createInstance() throws InstantiationException {
                            throw new InstantiationException();
                        }
                    };
                }
            }
            AnnotatedEndpointFactory factory = AnnotatedEndpointFactory.create(endpoint, encodingFactory, Collections.emptySet());
            ClientEndpointConfig.Configurator configurator = null;
            try {
                configurator = (ClientEndpointConfig.Configurator)clientEndpoint.configurator().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw JsrWebSocketMessages.MESSAGES.couldNotDeploy(e);
            }
            ClientEndpointConfig config = ClientEndpointConfig.Builder.create().decoders(Arrays.asList(clientEndpoint.decoders())).encoders(Arrays.asList(clientEndpoint.encoders())).preferredSubprotocols(Arrays.asList(clientEndpoint.subprotocols())).configurator(configurator).build();
            ConfiguredClientEndpoint configuredClientEndpoint = new ConfiguredClientEndpoint(config, factory, encodingFactory, instanceFactory);
            this.clientEndpoints.put(endpoint, configuredClientEndpoint);
        } else {
            throw JsrWebSocketMessages.MESSAGES.classWasNotAnnotated(endpoint);
        }
    }

    private void handleAddingFilterMapping() {
        if (this.contextToAddFilter != null) {
            this.contextToAddFilter.getDeployment().getDeploymentInfo().addFilterUrlMapping("Undertow Web Socket Filter", "/*", DispatcherType.REQUEST);
            this.contextToAddFilter.getDeployment().getServletPaths().invalidate();
            this.contextToAddFilter = null;
        }
    }

    public void addEndpoint(ServerEndpointConfig endpoint) throws DeploymentException {
        if (this.deploymentComplete) {
            throw JsrWebSocketMessages.MESSAGES.cannotAddEndpointAfterDeployment();
        }
        JsrWebSocketLogger.ROOT_LOGGER.addingProgramaticEndpoint(endpoint.getEndpointClass(), endpoint.getPath());
        PathTemplate template = PathTemplate.create((String)endpoint.getPath());
        if (this.seenPaths.contains(template)) {
            PathTemplate existing = null;
            for (PathTemplate p : this.seenPaths) {
                if (p.compareTo(template) != 0) continue;
                existing = p;
                break;
            }
            throw JsrWebSocketMessages.MESSAGES.multipleEndpointsWithOverlappingPaths(template, existing);
        }
        this.seenPaths.add(template);
        EncodingFactory encodingFactory = EncodingFactory.createFactory(this.classIntrospecter, endpoint.getDecoders(), endpoint.getEncoders());
        ConfiguredServerEndpoint confguredServerEndpoint = new ConfiguredServerEndpoint(endpoint, null, template, encodingFactory, null);
        this.configuredServerEndpoints.add(confguredServerEndpoint);
        this.handleAddingFilterMapping();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfiguredClientEndpoint getClientEndpoint(Class<?> endpointType, boolean requiresCreation) {
        Class<?> type;
        for (type = endpointType; type != Object.class && type != null && !type.isAnnotationPresent(ClientEndpoint.class); type = type.getSuperclass()) {
        }
        if (type == Object.class || type == null) {
            return null;
        }
        ConfiguredClientEndpoint existing = this.clientEndpoints.get(type);
        if (existing != null) {
            return existing;
        }
        ServerWebSocketContainer serverWebSocketContainer = this;
        synchronized (serverWebSocketContainer) {
            existing = this.clientEndpoints.get(type);
            if (existing != null) {
                return existing;
            }
            if (type.isAnnotationPresent(ClientEndpoint.class)) {
                try {
                    this.addEndpointInternal(type, requiresCreation);
                    return this.clientEndpoints.get(type);
                }
                catch (DeploymentException e) {
                    throw new RuntimeException(e);
                }
            }
            return null;
        }
    }

    public void deploymentComplete() {
        this.deploymentComplete = true;
    }

    public List<ConfiguredServerEndpoint> getConfiguredServerEndpoints() {
        return this.configuredServerEndpoints;
    }

    public ServletContextImpl getContextToAddFilter() {
        return this.contextToAddFilter;
    }

    public void setContextToAddFilter(ServletContextImpl contextToAddFilter) {
        this.contextToAddFilter = contextToAddFilter;
    }

    @Override
    public synchronized void close() {
        for (ConfiguredServerEndpoint endpoint : this.configuredServerEndpoints) {
            for (Session session : endpoint.getOpenSessions()) {
                try {
                    session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.GOING_AWAY, ""));
                }
                catch (Exception e) {
                    JsrWebSocketLogger.ROOT_LOGGER.couldNotCloseOnUndeploy(e);
                }
            }
        }
    }

    public Pool<ByteBuffer> getBufferPool() {
        return this.bufferPool;
    }

    public XnioWorker getXnioWorker() {
        return this.xnioWorker;
    }

    private static List<WebSocketExtension> toExtensionList(List<Extension> extensions) {
        ArrayList<WebSocketExtension> ret = new ArrayList<WebSocketExtension>();
        for (Extension e : extensions) {
            ArrayList<WebSocketExtension.Parameter> parameters = new ArrayList<WebSocketExtension.Parameter>();
            for (Extension.Parameter p : e.getParameters()) {
                parameters.add(new WebSocketExtension.Parameter(p.getName(), p.getValue()));
            }
            ret.add(new WebSocketExtension(e.getName(), parameters));
        }
        return ret;
    }

    private class ClientNegotiation
    extends WebSocketClientNegotiation {
        private final ClientEndpointConfig config;

        public ClientNegotiation(List<String> supportedSubProtocols, List<WebSocketExtension> supportedExtensions, ClientEndpointConfig config) {
            super(supportedSubProtocols, supportedExtensions);
            this.config = config;
        }

        public void afterRequest(Map<String, List<String>> headers) {
            ClientEndpointConfig.Configurator configurator = this.config.getConfigurator();
            if (configurator != null) {
                final TreeMap newHeaders = new TreeMap(String.CASE_INSENSITIVE_ORDER);
                for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                    ArrayList arrayList = new ArrayList();
                    arrayList.addAll(entry.getValue());
                    newHeaders.put(entry.getKey(), arrayList);
                }
                configurator.afterResponse(new HandshakeResponse(){

                    public Map<String, List<String>> getHeaders() {
                        return newHeaders;
                    }
                });
            }
        }

        public void beforeRequest(Map<String, List<String>> headers) {
            ClientEndpointConfig.Configurator configurator = this.config.getConfigurator();
            if (configurator != null) {
                HashMap newHeaders = new HashMap();
                for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                    ArrayList arrayList = new ArrayList();
                    arrayList.addAll(entry.getValue());
                    newHeaders.put(entry.getKey(), arrayList);
                }
                configurator.beforeRequest(newHeaders);
                headers.clear();
                for (Map.Entry<String, List<String>> entry : newHeaders.entrySet()) {
                    if (entry.getValue().isEmpty()) continue;
                    headers.put(entry.getKey(), entry.getValue());
                }
            }
        }
    }
}

