/*
 * Decompiled with CFR 0.152.
 */
package io.userinfo.client;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.userinfo.client.UserInfoService;
import io.userinfo.client.model.Info;
import java.lang.reflect.Type;
import java.util.Date;
import org.joda.time.DateTime;
import retrofit.RestAdapter;
import retrofit.converter.Converter;
import retrofit.converter.GsonConverter;

public class UserInfo {
    private static final UserInfoService SERVICE;
    protected static final String CLIENT_VERSION_ID = "userinfo-java:1.1.0";

    public static Info getInfo(String ipAddress) {
        return SERVICE.getInfos(ipAddress);
    }

    static {
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapter(DateTime.class, (Object)new DateTimeTypeConverter()).create();
        RestAdapter restAdapter = new RestAdapter.Builder().setEndpoint("https://api.userinfo.io").setConverter((Converter)new GsonConverter(gson)).build();
        SERVICE = (UserInfoService)restAdapter.create(UserInfoService.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DateTimeTypeConverter
    implements JsonSerializer<DateTime>,
    JsonDeserializer<DateTime> {
        private DateTimeTypeConverter() {
        }

        public JsonElement serialize(DateTime src, Type srcType, JsonSerializationContext context) {
            return new JsonPrimitive(src.toString());
        }

        public DateTime deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            try {
                return new DateTime((Object)json.getAsString());
            }
            catch (IllegalArgumentException e) {
                Date date = (Date)context.deserialize(json, Date.class);
                return new DateTime((Object)date);
            }
        }
    }
}

