/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2.providers;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.PubSecKeyOptions;
import io.vertx.ext.auth.oauth2.OAuth2Auth;
import io.vertx.ext.auth.oauth2.OAuth2ClientOptions;
import io.vertx.ext.auth.oauth2.OAuth2FlowType;
import io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth;
import io.vertx.ext.auth.oauth2.rbac.KeycloakRBAC;

@VertxGen
public interface KeycloakAuth
extends OpenIDConnectAuth {
    public static OAuth2Auth create(Vertx vertx, JsonObject config) {
        return KeycloakAuth.create(vertx, OAuth2FlowType.AUTH_CODE, config);
    }

    public static OAuth2Auth create(Vertx vertx, OAuth2FlowType flow, JsonObject config) {
        return KeycloakAuth.create(vertx, flow, config, new HttpClientOptions());
    }

    public static OAuth2Auth create(Vertx vertx, JsonObject config, HttpClientOptions httpClientOptions) {
        return KeycloakAuth.create(vertx, OAuth2FlowType.AUTH_CODE, config, httpClientOptions);
    }

    public static OAuth2Auth create(Vertx vertx, OAuth2FlowType flow, JsonObject config, HttpClientOptions httpClientOptions) {
        OAuth2ClientOptions options = new OAuth2ClientOptions(httpClientOptions);
        options.setFlow(flow);
        if (config.containsKey("auth-server-url")) {
            options.setSite(config.getString("auth-server-url"));
        }
        if (config.containsKey("resource")) {
            options.setClientID(config.getString("resource"));
        }
        if (config.containsKey("credentials") && config.getJsonObject("credentials").containsKey("secret")) {
            options.setClientSecret(config.getJsonObject("credentials").getString("secret"));
        }
        if (config.containsKey("public-client") && config.getBoolean("public-client", Boolean.valueOf(false)).booleanValue()) {
            options.setUseBasicAuthorizationHeader(true);
        }
        if (config.containsKey("realm")) {
            String realm = config.getString("realm");
            options.setAuthorizationPath("/realms/" + realm + "/protocol/openid-connect/auth");
            options.setTokenPath("/realms/" + realm + "/protocol/openid-connect/token");
            options.setRevocationPath(null);
            options.setLogoutPath("/realms/" + realm + "/protocol/openid-connect/logout");
            options.setUserInfoPath("/realms/" + realm + "/protocol/openid-connect/userinfo");
            options.setIntrospectionPath("/realms/" + realm + "/protocol/openid-connect/token/introspect");
            options.setJwkPath("/realms/" + realm + "/protocol/openid-connect/certs");
        }
        if (config.containsKey("realm-public-key")) {
            options.addPubSecKey(new PubSecKeyOptions().setAlgorithm("RS256").setPublicKey(config.getString("realm-public-key")));
        }
        return OAuth2Auth.create(vertx, options).rbacHandler(KeycloakRBAC.create(options));
    }

    public static void discover(Vertx vertx, OAuth2ClientOptions config, Handler<AsyncResult<OAuth2Auth>> handler) {
        OAuth2ClientOptions options = new OAuth2ClientOptions(config);
        OpenIDConnectAuth.discover(vertx, options, (Handler<AsyncResult<OAuth2Auth>>)((Handler)discover -> {
            if (discover.succeeded()) {
                ((OAuth2Auth)discover.result()).rbacHandler(KeycloakRBAC.create(options));
            }
            handler.handle(discover);
        }));
    }
}

