/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.JWTOptions;
import io.vertx.ext.auth.NoSuchKeyIdException;
import io.vertx.ext.auth.PubSecKeyOptions;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.CredentialValidationException;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.authentication.TokenCredentials;
import io.vertx.ext.auth.authentication.UsernamePasswordCredentials;
import io.vertx.ext.auth.impl.jose.JWK;
import io.vertx.ext.auth.impl.jose.JWT;
import io.vertx.ext.auth.oauth2.OAuth2Auth;
import io.vertx.ext.auth.oauth2.OAuth2FlowType;
import io.vertx.ext.auth.oauth2.OAuth2Options;
import io.vertx.ext.auth.oauth2.Oauth2Credentials;
import io.vertx.ext.auth.oauth2.impl.OAuth2API;
import java.util.List;

public class OAuth2AuthProviderImpl
implements OAuth2Auth {
    private static final Logger LOG = LoggerFactory.getLogger(OAuth2AuthProviderImpl.class);
    private final Vertx vertx;
    private final ContextInternal ctx;
    private final OAuth2Options config;
    private final OAuth2API api;
    private volatile JWT jwt = new JWT();
    private volatile long updateTimerId = -1L;
    private Handler<String> missingKeyHandler;

    public OAuth2AuthProviderImpl(Vertx vertx, OAuth2Options config) {
        this.vertx = vertx;
        this.ctx = (ContextInternal)vertx.getOrCreateContext();
        this.config = config;
        this.api = new OAuth2API(vertx, config);
        this.config.replaceVariables(true);
        this.config.validate();
        this.jwt.nonceAlgorithm(this.config.getJWTOptions().getNonceAlgorithm());
        if (config.getPubSecKeys() != null) {
            for (PubSecKeyOptions pubSecKey : config.getPubSecKeys()) {
                this.jwt.addJWK(new JWK(pubSecKey));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        OAuth2AuthProviderImpl oAuth2AuthProviderImpl = this;
        synchronized (oAuth2AuthProviderImpl) {
            if (this.updateTimerId != -1L) {
                this.vertx.cancelTimer(this.updateTimerId);
                this.updateTimerId = -1L;
            }
            this.jwt = null;
        }
    }

    @Override
    public Future<Void> jWKSet() {
        return this.api.jwkSet().compose(json -> {
            OAuth2AuthProviderImpl oAuth2AuthProviderImpl = this;
            synchronized (oAuth2AuthProviderImpl) {
                if (this.updateTimerId != -1L) {
                    this.vertx.cancelTimer(this.updateTimerId);
                }
                JWT jwt = new JWT().nonceAlgorithm(this.config.getJWTOptions().getNonceAlgorithm());
                JsonArray keys = json.getJsonArray("keys");
                for (Object key : keys) {
                    try {
                        jwt.addJWK(new JWK((JsonObject)key));
                    }
                    catch (RuntimeException e) {
                        LOG.warn((Object)("Skipped unsupported JWK: " + e.getMessage()));
                    }
                }
                this.jwt = jwt;
                if (this.config.isRotateJWKs() && json.containsKey("maxAge")) {
                    int leeway = Math.max(0, this.config.getJWTOptions().getLeeway());
                    long delay = json.getLong("maxAge") * 1000L - (long)leeway;
                    this.updateTimerId = delay > 0L ? this.vertx.setPeriodic(delay, t -> this.jWKSet((Handler<AsyncResult<Void>>)((Handler)autoUpdateRes -> {
                        if (autoUpdateRes.failed()) {
                            LOG.warn((Object)"Failed to auto-update JWK Set", autoUpdateRes.cause());
                        }
                    }))) : -1L;
                }
            }
            return this.ctx.succeededFuture();
        });
    }

    @Override
    public OAuth2Auth missingKeyHandler(Handler<String> handler) {
        this.missingKeyHandler = handler;
        return this;
    }

    public OAuth2Options getConfig() {
        return this.config;
    }

    public void authenticate(JsonObject authInfo, Handler<AsyncResult<User>> handler) {
        if (authInfo.containsKey("access_token")) {
            TokenCredentials cred = new TokenCredentials(authInfo.getString("access_token"));
            if (authInfo.containsKey("scopes")) {
                for (Object scope : authInfo.getJsonArray("scopes")) {
                    cred.addScope((String)scope);
                }
            }
            this.authenticate((Credentials)cred, handler);
            return;
        }
        OAuth2FlowType flow = authInfo.getString("flow") != null && !authInfo.getString("flow").isEmpty() ? OAuth2FlowType.getFlow(authInfo.getString("flow")) : this.config.getFlow();
        switch (flow) {
            case AUTH_CODE: {
                if (!authInfo.containsKey("code")) break;
                Oauth2Credentials cred = new Oauth2Credentials().setCode(authInfo.getString("code")).setCodeVerifier(authInfo.getString("codeVerifier")).setRedirectUri(authInfo.getString("redirectUri")).setFlow(flow);
                this.authenticate(cred, handler);
                return;
            }
            case CLIENT: {
                Oauth2Credentials cred = new Oauth2Credentials().setFlow(flow);
                if (authInfo.containsKey("scopes")) {
                    for (Object scope : authInfo.getJsonArray("scopes")) {
                        cred.addScope((String)scope);
                    }
                }
                this.authenticate(cred, handler);
                return;
            }
            case PASSWORD: {
                if (!authInfo.containsKey("username") || !authInfo.containsKey("password")) break;
                Oauth2Credentials cred = new Oauth2Credentials().setUsername(authInfo.getString("username")).setPassword(authInfo.getString("password")).setFlow(flow);
                if (authInfo.containsKey("scopes")) {
                    for (Object scope : authInfo.getJsonArray("scopes")) {
                        cred.addScope((String)scope);
                    }
                }
                this.authenticate(cred, handler);
                return;
            }
            case AUTH_JWT: 
            case AAD_OBO: {
                if (authInfo.containsKey("assertion")) {
                    Oauth2Credentials cred = new Oauth2Credentials().setAssertion(authInfo.getString("assertion")).setFlow(flow);
                    this.authenticate(cred, handler);
                    return;
                }
                this.authenticate(new Oauth2Credentials().setJwt(authInfo).setFlow(flow), handler);
                return;
            }
        }
        handler.handle((Object)Future.failedFuture((String)("can't parse token: " + authInfo)));
    }

    public void authenticate(Credentials credentials, Handler<AsyncResult<User>> handler) {
        try {
            if (credentials instanceof UsernamePasswordCredentials) {
                UsernamePasswordCredentials usernamePasswordCredentials = (UsernamePasswordCredentials)credentials;
                usernamePasswordCredentials.checkValid(null);
                Oauth2Credentials cred = new Oauth2Credentials().setUsername(usernamePasswordCredentials.getUsername()).setPassword(usernamePasswordCredentials.getPassword()).setFlow(OAuth2FlowType.PASSWORD);
                this.authenticate(cred, handler);
                return;
            }
            if (credentials instanceof TokenCredentials) {
                JWTOptions jwtOptions;
                TokenCredentials tokenCredentials = (TokenCredentials)credentials;
                tokenCredentials.checkValid(null);
                User user = this.createUser(new JsonObject().put("access_token", (Object)tokenCredentials.getToken()), false);
                if (user.attributes().containsKey("accessToken") && !this.jwt.isUnsecure() && !user.expired((jwtOptions = this.config.getJWTOptions()).getLeeway())) {
                    handler.handle((Object)Future.succeededFuture((Object)user));
                    return;
                }
                if (this.config.getIntrospectionPath() == null) {
                    if (user.attributes().containsKey("missing-kid")) {
                        handler.handle((Object)Future.failedFuture((Throwable)new NoSuchKeyIdException(user.attributes().getString("missing-kid"))));
                    } else {
                        handler.handle((Object)Future.failedFuture((String)"Can't authenticate access_token: Provider doesn't support token introspection"));
                    }
                    return;
                }
                this.api.tokenIntrospection("access_token", tokenCredentials.getToken()).compose(json -> {
                    User newUser;
                    String clientId;
                    if (json.containsKey("active") && !json.getBoolean("active", Boolean.valueOf(false)).booleanValue()) {
                        return this.ctx.failedFuture("Inactive Token");
                    }
                    if (json.containsKey("client_id") && (clientId = this.config.getClientId()) != null && !clientId.equals(json.getString("client_id"))) {
                        LOG.info((Object)"Introspect client_id doesn't match configured client_id");
                    }
                    if ((newUser = this.createUser((JsonObject)json, user.attributes().containsKey("missing-kid"))).expired(this.config.getJWTOptions().getLeeway())) {
                        return this.ctx.failedFuture("Used is expired.");
                    }
                    return this.ctx.succeededFuture((Object)newUser);
                }).onComplete(handler);
                return;
            }
            Oauth2Credentials oauth2Credentials = (Oauth2Credentials)credentials;
            JsonObject params = new JsonObject();
            OAuth2FlowType flow = oauth2Credentials.getFlow() != null ? oauth2Credentials.getFlow() : this.config.getFlow();
            oauth2Credentials.checkValid(flow);
            if (this.config.getSupportedGrantTypes() != null && !this.config.getSupportedGrantTypes().isEmpty() && !this.config.getSupportedGrantTypes().contains(flow.getGrantType())) {
                handler.handle((Object)Future.failedFuture((String)"Provided flow is not supported by provider"));
                return;
            }
            switch (flow) {
                case AUTH_CODE: {
                    params.put("code", (Object)oauth2Credentials.getCode());
                    if (oauth2Credentials.getRedirectUri() != null) {
                        params.put("redirect_uri", (Object)oauth2Credentials.getRedirectUri());
                    }
                    if (oauth2Credentials.getCodeVerifier() == null) break;
                    params.put("code_verifier", (Object)oauth2Credentials.getCodeVerifier());
                    break;
                }
                case PASSWORD: {
                    params.put("username", (Object)oauth2Credentials.getUsername()).put("password", (Object)oauth2Credentials.getPassword());
                    if (oauth2Credentials.getScopes() == null) break;
                    params.put("scope", (Object)String.join((CharSequence)this.config.getScopeSeparator(), oauth2Credentials.getScopes()));
                    break;
                }
                case CLIENT: {
                    if (oauth2Credentials.getScopes() == null) break;
                    params.put("scope", (Object)String.join((CharSequence)this.config.getScopeSeparator(), oauth2Credentials.getScopes()));
                    break;
                }
                case AUTH_JWT: {
                    params.put("assertion", (Object)this.jwt.sign(oauth2Credentials.getJwt(), this.config.getJWTOptions()));
                    if (oauth2Credentials.getScopes() == null) break;
                    params.put("scope", (Object)String.join((CharSequence)this.config.getScopeSeparator(), oauth2Credentials.getScopes()));
                    break;
                }
                case AAD_OBO: {
                    params.put("requested_token_use", (Object)"on_behalf_of").put("assertion", (Object)oauth2Credentials.getAssertion());
                    if (oauth2Credentials.getScopes() == null) break;
                    params.put("scope", (Object)String.join((CharSequence)this.config.getScopeSeparator(), oauth2Credentials.getScopes()));
                    break;
                }
                default: {
                    handler.handle((Object)Future.failedFuture((String)"Current flow does not allow acquiring a token by the replay party"));
                    return;
                }
            }
            this.api.token(flow.getGrantType(), params).compose(json -> {
                User newUser = this.createUser((JsonObject)json, false);
                if (newUser.expired(this.config.getJWTOptions().getLeeway())) {
                    return this.ctx.failedFuture("Used is expired.");
                }
                return this.ctx.succeededFuture((Object)newUser);
            }).onComplete(handler);
        }
        catch (CredentialValidationException | ClassCastException e) {
            handler.handle((Object)Future.failedFuture((Throwable)e));
        }
    }

    @Override
    public String authorizeURL(JsonObject params) {
        return this.api.authorizeURL(params);
    }

    @Override
    public Future<User> refresh(User user) {
        if (user.principal().getString("refresh_token") == null || user.principal().getString("refresh_token").isEmpty()) {
            return this.ctx.failedFuture((Throwable)new IllegalStateException("refresh_token is null or empty"));
        }
        return this.api.token("refresh_token", new JsonObject().put("refresh_token", (Object)user.principal().getString("refresh_token"))).compose(json -> {
            User newUser = this.createUser((JsonObject)json, false);
            if (newUser.expired(this.config.getJWTOptions().getLeeway())) {
                return this.ctx.failedFuture("Used is expired.");
            }
            return this.ctx.succeededFuture((Object)newUser);
        });
    }

    @Override
    public Future<Void> revoke(User user, String tokenType) {
        return this.api.tokenRevocation(tokenType, user.principal().getString(tokenType));
    }

    @Override
    public Future<JsonObject> userInfo(User user) {
        return this.api.userInfo(user.principal().getString("access_token"), this.jwt).compose(json -> {
            String userSub = user.principal().getString("sub", user.attributes().getString("sub"));
            String userInfoSub = json.getString("sub");
            if (!(userSub == null && userInfoSub == null || userSub == null || userInfoSub == null || userSub.equals(userInfoSub))) {
                return this.ctx.failedFuture("Used 'sub' does not match UserInfo 'sub'.");
            }
            OAuth2AuthProviderImpl.copyProperties(json, user.attributes(), true, new String[0]);
            if (user.expired(this.config.getJWTOptions().getLeeway())) {
                return this.ctx.failedFuture("Used is expired.");
            }
            return this.ctx.succeededFuture(json);
        });
    }

    @Override
    public String endSessionURL(User user, JsonObject params) {
        return this.api.endSessionURL(user.principal().getString("id_token"), params);
    }

    private User createUser(JsonObject json, boolean skipMissingKeyNotify) {
        User user = User.create((JsonObject)json);
        long now = System.currentTimeMillis() / 1000L;
        String missingKid = null;
        if (json.containsKey("expires_in")) {
            Long expiresIn;
            try {
                expiresIn = json.getLong("expires_in");
            }
            catch (ClassCastException e) {
                expiresIn = Long.valueOf(json.getString("expires_in"));
            }
            user.attributes().put("iat", (Object)now).put("exp", (Object)(now + expiresIn));
        }
        if (!this.jwt.isUnsecure()) {
            JsonObject token;
            if (json.containsKey("access_token")) {
                try {
                    token = this.jwt.decode(json.getString("access_token"));
                    user.attributes().put("accessToken", (Object)this.validToken(token, false));
                    OAuth2AuthProviderImpl.copyProperties(user.attributes().getJsonObject("accessToken"), user.attributes(), true, "exp", "iat", "nbf", "sub");
                    user.attributes().put("rootClaim", (Object)"accessToken");
                }
                catch (NoSuchKeyIdException e) {
                    if (!skipMissingKeyNotify) {
                        user.attributes().put("missing-kid", (Object)e.id());
                        missingKid = e.id();
                        if (this.missingKeyHandler != null) {
                            this.missingKeyHandler.handle((Object)e.id());
                        } else {
                            LOG.trace((Object)"Cannot decode access token:", (Throwable)e);
                        }
                    }
                }
                catch (DecodeException | IllegalStateException e) {
                    LOG.trace((Object)"Cannot decode access token:", e);
                }
            }
            if (json.containsKey("id_token")) {
                try {
                    token = this.jwt.decode(json.getString("id_token"));
                    user.attributes().put("idToken", (Object)this.validToken(token, true));
                    OAuth2AuthProviderImpl.copyProperties(user.attributes().getJsonObject("idToken"), user.attributes(), false, "sub", "name", "email", "picture");
                }
                catch (NoSuchKeyIdException e) {
                    if (!skipMissingKeyNotify && !e.id().equals(missingKid)) {
                        user.attributes().put("missing-kid", (Object)e.id());
                        if (this.missingKeyHandler != null) {
                            this.missingKeyHandler.handle((Object)e.id());
                        } else {
                            LOG.trace((Object)"Cannot decode access token:", (Throwable)e);
                        }
                    }
                }
                catch (DecodeException | IllegalStateException e) {
                    LOG.trace((Object)"Cannot decode id token:", e);
                }
            }
        }
        return user;
    }

    private JsonObject validToken(JsonObject token, boolean idToken) throws IllegalStateException {
        JWTOptions jwtOptions = this.config.getJWTOptions();
        JsonArray target = null;
        if (token.containsKey("aud")) {
            try {
                target = token.getValue("aud") instanceof String ? new JsonArray().add(token.getValue("aud")) : token.getJsonArray("aud");
            }
            catch (RuntimeException e) {
                throw new IllegalStateException("User audience isn't a JsonArray or String");
            }
        }
        if (target != null && target.size() > 0) {
            if (idToken || jwtOptions.getAudience() == null) {
                if (!target.contains((Object)this.config.getClientId())) {
                    throw new IllegalStateException("Invalid JWT audience. expected: " + this.config.getClientId());
                }
            } else {
                List aud = jwtOptions.getAudience();
                for (String el : aud) {
                    if (target.contains((Object)el)) continue;
                    throw new IllegalStateException("Invalid JWT audience. expected: " + el);
                }
            }
        }
        if (jwtOptions.getIssuer() != null && !jwtOptions.getIssuer().equals(token.getString("iss"))) {
            throw new IllegalStateException("Invalid JWT issuer");
        }
        if (idToken && token.containsKey("azp")) {
            String clientId = this.config.getClientId();
            if (!clientId.equals(token.getString("azp"))) {
                throw new IllegalStateException("Invalid authorised party != config.clientID");
            }
            if (target != null && target.size() > 1 && !target.contains((Object)token.getString("azp"))) {
                throw new IllegalStateException("ID Token with multiple audiences, doesn't contain azp Claim value");
            }
        }
        return token;
    }

    private static void copyProperties(JsonObject source, JsonObject target, boolean overwrite, String ... keys) {
        block4: {
            if (source == null || target == null) break block4;
            if (keys.length == 0) {
                for (String key : source.fieldNames()) {
                    if (target.containsKey(key) && !overwrite) continue;
                    target.put(key, source.getValue(key));
                }
            } else {
                for (String key : keys) {
                    if (!source.containsKey(key) || target.containsKey(key) && !overwrite) continue;
                    target.put(key, source.getValue(key));
                }
            }
        }
    }
}

