/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.cassandra;

import com.datastax.driver.core.Cluster;
import io.vertx.cassandra.CassandraClientOptionsConverter;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@DataObject(generateConverter=true)
public class CassandraClientOptions {
    public static final int DEFAULT_PORT = 9042;
    public static final String DEFAULT_HOST = "localhost";
    private Cluster.Builder builder;

    public CassandraClientOptions() {
        this(Cluster.builder());
        this.setPort(9042);
    }

    public CassandraClientOptions(Cluster.Builder builder) {
        this.builder = builder;
    }

    public CassandraClientOptions(JsonObject json) {
        this();
        CassandraClientOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        CassandraClientOptionsConverter.toJson(this, json);
        return json;
    }

    public CassandraClientOptions setContactPoints(List<String> contactPoints) {
        for (String contactPoint : contactPoints) {
            this.builder.addContactPoint(contactPoint);
        }
        return this;
    }

    public CassandraClientOptions setPort(int port) {
        this.builder.withPort(port);
        return this;
    }

    public CassandraClientOptions addContactPoint(String address) {
        this.builder.addContactPoint(address);
        return this;
    }

    public List<String> getContactPoints() {
        return this.builder.getContactPoints().stream().map(InetSocketAddress::toString).collect(Collectors.toList());
    }

    public Cluster.Builder dataStaxClusterBuilder() {
        return this.builder;
    }
}

