/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.cassandra.impl;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.google.common.util.concurrent.ListenableFuture;
import io.vertx.cassandra.CassandraClient;
import io.vertx.cassandra.CassandraClientOptions;
import io.vertx.cassandra.CassandraRowStream;
import io.vertx.cassandra.ResultSet;
import io.vertx.cassandra.impl.CassandraRowStreamImpl;
import io.vertx.cassandra.impl.ResultSetImpl;
import io.vertx.cassandra.impl.Util;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.shareddata.LocalMap;
import io.vertx.core.shareddata.Shareable;
import java.io.Closeable;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public class CassandraClientImpl
implements CassandraClient {
    private static final String DS_LOCAL_MAP_NAME = "__vertx.CassandraClient.datasources";
    private final Vertx vertx;
    private final CassandraHolder cassandraHolder;

    public CassandraClientImpl(Vertx vertx, String dataSourceName, CassandraClientOptions cassandraClientOptions) {
        this.vertx = vertx;
        this.cassandraHolder = this.lookupHolder(dataSourceName, cassandraClientOptions);
        Context ctx = Vertx.currentContext();
        if (ctx != null && ctx.owner() == vertx) {
            ctx.addCloseHook(v -> this.cassandraHolder.close());
        }
    }

    private LocalMap<String, CassandraHolder> cassandraHolderLocalMap() {
        return this.vertx.sharedData().getLocalMap(DS_LOCAL_MAP_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CassandraHolder lookupHolder(String dataSourceName, CassandraClientOptions cassandraClientOptions) {
        LocalMap<String, CassandraHolder> map;
        LocalMap<String, CassandraHolder> localMap = map = this.cassandraHolderLocalMap();
        synchronized (localMap) {
            CassandraHolder theHolder = (CassandraHolder)map.get((Object)dataSourceName);
            if (theHolder == null) {
                theHolder = new CassandraHolder(cassandraClientOptions, () -> this.removeFromMap(map, dataSourceName));
                map.put((Object)dataSourceName, (Object)theHolder);
            } else {
                theHolder.incRefCount();
            }
            return theHolder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromMap(LocalMap<String, CassandraHolder> map, String dataSourceName) {
        LocalMap<String, CassandraHolder> localMap = map;
        synchronized (localMap) {
            map.remove((Object)dataSourceName);
            if (map.isEmpty()) {
                map.close();
            }
        }
    }

    @Override
    public CassandraClient connect() {
        return this.connect(null);
    }

    @Override
    public boolean isConnected() {
        Session session = this.cassandraHolder.session.get();
        if (session == null) {
            return false;
        }
        return !session.isClosed();
    }

    @Override
    public CassandraClient connect(Handler<AsyncResult<Void>> connectHandler) {
        return this.connect(null, connectHandler);
    }

    @Override
    public CassandraClient connect(String keyspace, Handler<AsyncResult<Void>> connectHandler) {
        this.cassandraHolder.session.set(null);
        Cluster.Builder builder = this.cassandraHolder.options.dataStaxClusterBuilder();
        if (builder.getContactPoints().isEmpty()) {
            builder.addContactPoint("localhost");
        }
        Cluster build = builder.build();
        ListenableFuture connectGuavaFuture = keyspace == null ? build.connectAsync() : build.connectAsync(keyspace);
        Util.handleOnContext(connectGuavaFuture, this.vertx.getOrCreateContext(), ar -> {
            if (ar.succeeded()) {
                this.cassandraHolder.session.set((Session)ar.result());
                if (connectHandler != null) {
                    connectHandler.handle((Object)Future.succeededFuture());
                }
            } else if (connectHandler != null) {
                connectHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        });
        return this;
    }

    @Override
    public CassandraClient executeWithFullFetch(String query, Handler<AsyncResult<List<Row>>> resultHandler) {
        return this.executeWithFullFetch((Statement)new SimpleStatement(query), resultHandler);
    }

    @Override
    public CassandraClient executeWithFullFetch(Statement statement, Handler<AsyncResult<List<Row>>> resultHandler) {
        this.execute(statement, (Handler<AsyncResult<ResultSet>>)((Handler)ar -> {
            if (ar.succeeded()) {
                ((ResultSet)ar.result()).all(resultHandler);
            } else {
                resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        }));
        return this;
    }

    @Override
    public CassandraClient execute(String query, Handler<AsyncResult<ResultSet>> resultHandler) {
        return this.execute((Statement)new SimpleStatement(query), resultHandler);
    }

    @Override
    public CassandraClient execute(Statement statement, Handler<AsyncResult<ResultSet>> resultHandler) {
        Context context = this.vertx.getOrCreateContext();
        this.executeWithSession(session -> Util.handleOnContext(session.executeAsync(statement), context, ar -> {
            if (ar.succeeded()) {
                resultHandler.handle((Object)Future.succeededFuture((Object)new ResultSetImpl((com.datastax.driver.core.ResultSet)ar.result(), this.vertx)));
            } else {
                resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        }), resultHandler);
        return this;
    }

    @Override
    public CassandraClient disconnect() {
        return this.disconnect(null);
    }

    @Override
    public CassandraClient prepare(String query, Handler<AsyncResult<PreparedStatement>> resultHandler) {
        Context context = this.vertx.getOrCreateContext();
        this.executeWithSession(session -> Util.handleOnContext(session.prepareAsync(query), context, ar -> {
            if (ar.succeeded()) {
                resultHandler.handle((Object)Future.succeededFuture((Object)ar.result()));
            } else {
                resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        }), resultHandler);
        return this;
    }

    @Override
    public CassandraClient queryStream(String sql, Handler<AsyncResult<CassandraRowStream>> rowStreamHandler) {
        return this.queryStream((Statement)new SimpleStatement(sql), rowStreamHandler);
    }

    @Override
    public CassandraClient queryStream(Statement statement, Handler<AsyncResult<CassandraRowStream>> rowStreamHandler) {
        Context context = this.vertx.getOrCreateContext();
        this.executeWithSession(session -> Util.handleOnContext(session.executeAsync(statement), context, ar -> {
            if (ar.succeeded()) {
                rowStreamHandler.handle((Object)Future.succeededFuture((Object)new CassandraRowStreamImpl((com.datastax.driver.core.ResultSet)ar.result(), context)));
            } else {
                rowStreamHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        }), rowStreamHandler);
        return this;
    }

    @Override
    public CassandraClient disconnect(Handler<AsyncResult<Void>> disconnectHandler) {
        Context context = this.vertx.getOrCreateContext();
        this.executeWithSession(session -> Util.handleOnContext(session.closeAsync(), context, ar -> {
            if (ar.succeeded()) {
                disconnectHandler.handle((Object)Future.succeededFuture());
            } else {
                disconnectHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        }), disconnectHandler);
        return this;
    }

    private <T> void executeWithSession(Consumer<Session> sessionConsumer, Handler<AsyncResult<T>> handlerToFailIfNoSessionPresent) {
        Session session = this.cassandraHolder.session.get();
        if (session != null) {
            sessionConsumer.accept(session);
        } else if (handlerToFailIfNoSessionPresent != null) {
            handlerToFailIfNoSessionPresent.handle((Object)Future.failedFuture((String)"In order to do this, you should be connected"));
        }
    }

    class CassandraHolder
    implements Closeable,
    Shareable {
        int refCount = 1;
        AtomicReference<Session> session = new AtomicReference<Object>(null);
        CassandraClientOptions options;
        Runnable closeRunner;

        public CassandraHolder(CassandraClientOptions options, Runnable closeRunner) {
            this.options = options;
            this.closeRunner = closeRunner;
        }

        synchronized void incRefCount() {
            ++this.refCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            CassandraHolder cassandraHolder = this;
            synchronized (cassandraHolder) {
                --this.refCount;
                if (this.refCount == 0 && this.session.get() != null) {
                    this.session.get().close();
                }
            }
            if (this.refCount == 0 && this.closeRunner != null) {
                this.closeRunner.run();
            }
        }
    }
}

