/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.cassandra.impl;

import com.datastax.driver.core.Session;
import io.vertx.cassandra.CassandraClient;
import io.vertx.cassandra.Mapper;
import io.vertx.cassandra.MappingManager;
import io.vertx.cassandra.impl.CassandraClientImpl;
import io.vertx.cassandra.impl.MapperImpl;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.ContextInternal;
import java.util.Objects;

public class MappingManagerImpl
implements MappingManager {
    final CassandraClientImpl client;
    private com.datastax.driver.mapping.MappingManager mappingManager;

    public MappingManagerImpl(CassandraClient client) {
        Objects.requireNonNull(client, "client");
        this.client = (CassandraClientImpl)client;
    }

    @Override
    public <T> Mapper<T> mapper(Class<T> mappedClass) {
        return new MapperImpl<T>(this, mappedClass);
    }

    synchronized void getMappingManager(ContextInternal context, Handler<AsyncResult<com.datastax.driver.mapping.MappingManager>> handler) {
        if (this.mappingManager != null) {
            handler.handle((Object)Future.succeededFuture((Object)this.mappingManager));
        } else {
            this.client.getSession(context, (Handler<AsyncResult<Session>>)((Handler)ar -> {
                if (ar.succeeded()) {
                    com.datastax.driver.mapping.MappingManager manager;
                    try {
                        MappingManagerImpl mappingManagerImpl = this;
                        synchronized (mappingManagerImpl) {
                            if (this.mappingManager == null) {
                                this.mappingManager = new com.datastax.driver.mapping.MappingManager((Session)ar.result());
                            }
                            manager = this.mappingManager;
                        }
                    }
                    catch (Exception e) {
                        handler.handle((Object)Future.failedFuture((Throwable)e));
                        return;
                    }
                    handler.handle((Object)Future.succeededFuture((Object)manager));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }));
        }
    }
}

