/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.cassandra.impl;

import com.datastax.driver.core.Session;
import io.vertx.core.impl.TaskQueue;
import io.vertx.core.shareddata.Shareable;
import java.util.Objects;

class SessionHolder
implements Shareable {
    final TaskQueue connectionQueue;
    final Session session;
    final int refCount;

    SessionHolder() {
        this.connectionQueue = new TaskQueue();
        this.session = null;
        this.refCount = 1;
    }

    private SessionHolder(TaskQueue connectionQueue, Session session, int refCount) {
        this.connectionQueue = connectionQueue;
        this.session = session;
        this.refCount = refCount;
    }

    SessionHolder connected(Session session) {
        Objects.requireNonNull(session);
        if (this.session != null) {
            throw new IllegalStateException();
        }
        return new SessionHolder(this.connectionQueue, session, this.refCount);
    }

    SessionHolder increment() {
        return new SessionHolder(this.connectionQueue, this.session, this.refCount + 1);
    }

    SessionHolder decrement() {
        if (this.refCount < 1) {
            throw new IllegalArgumentException();
        }
        return new SessionHolder(this.connectionQueue, this.session, this.refCount - 1);
    }
}

