/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.cassandra.impl;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import java.util.Objects;
import java.util.function.Function;

class Util {
    Util() {
    }

    static <T> void handleOnContext(ListenableFuture<T> listenableFuture, Context context, Handler<AsyncResult<T>> handler) {
        Util.handleOnContext(listenableFuture, context, Function.identity(), handler);
    }

    static <I, O> void handleOnContext(ListenableFuture<I> listenableFuture, final Context context, final Function<I, O> converter, final Handler<AsyncResult<O>> handler) {
        Objects.requireNonNull(listenableFuture, "listenableFuture must not be null");
        Objects.requireNonNull(context, "context must not be null");
        Objects.requireNonNull(converter, "converter must not be null");
        if (handler != null) {
            Futures.addCallback(listenableFuture, (FutureCallback)new FutureCallback<I>(){

                public void onSuccess(I result) {
                    context.runOnContext(v -> handler.handle((Object)Future.succeededFuture(converter.apply(result))));
                }

                public void onFailure(Throwable t) {
                    context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)t)));
                }
            });
        }
    }
}

