/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.consul.KeyValue;
import io.vertx.ext.consul.KeyValueListConverter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

@DataObject(generateConverter=true)
public class KeyValueList {
    private long index;
    private List<KeyValue> list;

    public KeyValueList() {
    }

    public KeyValueList(KeyValueList other) {
        this.index = other.index;
        this.list = other.list;
    }

    public KeyValueList(JsonObject json) {
        KeyValueListConverter.fromJson(json, this);
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        KeyValueListConverter.toJson(this, jsonObject);
        return jsonObject;
    }

    @GenIgnore
    public boolean isPresent() {
        return this.list != null;
    }

    public long getIndex() {
        return this.index;
    }

    public KeyValueList setIndex(long index) {
        this.index = index;
        return this;
    }

    public List<KeyValue> getList() {
        return this.list;
    }

    public KeyValueList setList(List<KeyValue> list) {
        this.list = list;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyValueList list1 = (KeyValueList)o;
        if (this.index != list1.index) {
            return false;
        }
        return this.list != null ? this.sorted().equals(list1.sorted()) : list1.list == null;
    }

    public int hashCode() {
        int result = (int)(this.index ^ this.index >>> 32);
        result = 31 * result + (this.list != null ? this.sorted().hashCode() : 0);
        return result;
    }

    private List<KeyValue> sorted() {
        ArrayList<KeyValue> sorted = null;
        if (this.list != null) {
            sorted = new ArrayList<KeyValue>(this.list);
            sorted.sort(Comparator.comparing(KeyValue::getKey));
        }
        return sorted;
    }
}

