/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;

@DataObject
public class KeyValueOptions {
    private static final String ACQUIRE_SESSION_KEY = "AcquireSession";
    private static final String RELEASE_SESSION_KEY = "ReleaseSession";
    private static final String FLAGS_KEY = "Flags";
    private static final String CAS_KEY = "Cas";
    private String acquireSession;
    private String releaseSession;
    private long flags;
    private long cas;

    public KeyValueOptions() {
        this.cas = -1L;
    }

    public KeyValueOptions(KeyValueOptions options) {
        this.acquireSession = options.acquireSession;
        this.releaseSession = options.releaseSession;
        this.flags = options.flags;
        this.cas = options.cas;
    }

    public KeyValueOptions(JsonObject options) {
        this.acquireSession = options.getString(ACQUIRE_SESSION_KEY);
        this.releaseSession = options.getString(RELEASE_SESSION_KEY);
        String flagsStr = options.getString(FLAGS_KEY);
        this.flags = flagsStr == null ? 0L : Long.parseUnsignedLong(flagsStr);
        String casStr = options.getString(CAS_KEY);
        this.cas = casStr == null ? -1L : Long.parseUnsignedLong(casStr);
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        if (this.acquireSession != null) {
            jsonObject.put(ACQUIRE_SESSION_KEY, this.acquireSession);
        }
        if (this.releaseSession != null) {
            jsonObject.put(RELEASE_SESSION_KEY, this.releaseSession);
        }
        if (this.flags != 0L) {
            jsonObject.put(FLAGS_KEY, Long.toUnsignedString(this.flags));
        }
        if (this.cas >= 0L) {
            jsonObject.put(CAS_KEY, Long.toUnsignedString(this.cas));
        }
        return jsonObject;
    }

    public String getAcquireSession() {
        return this.acquireSession;
    }

    public KeyValueOptions setAcquireSession(String acquireSession) {
        this.acquireSession = acquireSession;
        return this;
    }

    public String getReleaseSession() {
        return this.releaseSession;
    }

    public KeyValueOptions setReleaseSession(String releaseSession) {
        this.releaseSession = releaseSession;
        return this;
    }

    public long getFlags() {
        return this.flags;
    }

    public KeyValueOptions setFlags(long flags) {
        this.flags = flags;
        return this;
    }

    public long getCasIndex() {
        return this.cas;
    }

    public KeyValueOptions setCasIndex(long index) {
        this.cas = index;
        return this;
    }
}

