/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.consul.CheckOptions;
import io.vertx.ext.consul.ServiceOptions;
import java.util.ArrayList;

public class ServiceOptionsConverter {
    public static void fromJson(JsonObject json, ServiceOptions obj) {
        if (json.getValue("address") instanceof String) {
            obj.setAddress((String)json.getValue("address"));
        }
        if (json.getValue("checkOptions") instanceof JsonObject) {
            obj.setCheckOptions(new CheckOptions((JsonObject)json.getValue("checkOptions")));
        }
        if (json.getValue("id") instanceof String) {
            obj.setId((String)json.getValue("id"));
        }
        if (json.getValue("name") instanceof String) {
            obj.setName((String)json.getValue("name"));
        }
        if (json.getValue("port") instanceof Number) {
            obj.setPort(((Number)json.getValue("port")).intValue());
        }
        if (json.getValue("tags") instanceof JsonArray) {
            ArrayList<String> list = new ArrayList<String>();
            json.getJsonArray("tags").forEach(item -> {
                if (item instanceof String) {
                    list.add((String)item);
                }
            });
            obj.setTags(list);
        }
    }

    public static void toJson(ServiceOptions obj, JsonObject json) {
        if (obj.getAddress() != null) {
            json.put("address", obj.getAddress());
        }
        if (obj.getCheckOptions() != null) {
            json.put("checkOptions", obj.getCheckOptions().toJson());
        }
        if (obj.getId() != null) {
            json.put("id", obj.getId());
        }
        if (obj.getName() != null) {
            json.put("name", obj.getName());
        }
        json.put("port", Integer.valueOf(obj.getPort()));
        if (obj.getTags() != null) {
            JsonArray array = new JsonArray();
            obj.getTags().forEach(item -> array.add(item));
            json.put("tags", array);
        }
    }
}

