/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.ext.consul;

import io.reactivex.Completable;
import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.consul.AclToken;
import io.vertx.ext.consul.BlockingQueryOptions;
import io.vertx.ext.consul.Check;
import io.vertx.ext.consul.CheckList;
import io.vertx.ext.consul.CheckOptions;
import io.vertx.ext.consul.CheckQueryOptions;
import io.vertx.ext.consul.CheckStatus;
import io.vertx.ext.consul.ConsulClientOptions;
import io.vertx.ext.consul.CoordinateList;
import io.vertx.ext.consul.DcCoordinates;
import io.vertx.ext.consul.Event;
import io.vertx.ext.consul.EventList;
import io.vertx.ext.consul.EventListOptions;
import io.vertx.ext.consul.EventOptions;
import io.vertx.ext.consul.KeyValue;
import io.vertx.ext.consul.KeyValueList;
import io.vertx.ext.consul.KeyValueOptions;
import io.vertx.ext.consul.MaintenanceOptions;
import io.vertx.ext.consul.NodeList;
import io.vertx.ext.consul.NodeQueryOptions;
import io.vertx.ext.consul.PreparedQueryDefinition;
import io.vertx.ext.consul.PreparedQueryExecuteOptions;
import io.vertx.ext.consul.PreparedQueryExecuteResponse;
import io.vertx.ext.consul.Service;
import io.vertx.ext.consul.ServiceEntryList;
import io.vertx.ext.consul.ServiceList;
import io.vertx.ext.consul.ServiceOptions;
import io.vertx.ext.consul.ServiceQueryOptions;
import io.vertx.ext.consul.Session;
import io.vertx.ext.consul.SessionList;
import io.vertx.ext.consul.SessionOptions;
import io.vertx.ext.consul.TxnRequest;
import io.vertx.ext.consul.TxnResponse;
import io.vertx.lang.reactivex.RxGen;
import io.vertx.lang.reactivex.TypeArg;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.core.impl.AsyncResultCompletable;
import io.vertx.reactivex.core.impl.AsyncResultSingle;
import java.util.List;

@RxGen(value=io.vertx.ext.consul.ConsulClient.class)
public class ConsulClient {
    public static final TypeArg<ConsulClient> __TYPE_ARG = new TypeArg(obj -> new ConsulClient((io.vertx.ext.consul.ConsulClient)obj), ConsulClient::getDelegate);
    private final io.vertx.ext.consul.ConsulClient delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConsulClient that = (ConsulClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public ConsulClient(io.vertx.ext.consul.ConsulClient delegate) {
        this.delegate = delegate;
    }

    public io.vertx.ext.consul.ConsulClient getDelegate() {
        return this.delegate;
    }

    public static ConsulClient create(Vertx vertx) {
        ConsulClient ret = ConsulClient.newInstance(io.vertx.ext.consul.ConsulClient.create(vertx.getDelegate()));
        return ret;
    }

    public static ConsulClient create(Vertx vertx, ConsulClientOptions options) {
        ConsulClient ret = ConsulClient.newInstance(io.vertx.ext.consul.ConsulClient.create(vertx.getDelegate(), options));
        return ret;
    }

    public ConsulClient agentInfo(Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.agentInfo(resultHandler);
        return this;
    }

    public Single<JsonObject> rxAgentInfo() {
        return new AsyncResultSingle(handler -> this.agentInfo((Handler<AsyncResult<JsonObject>>)handler));
    }

    public ConsulClient coordinateNodes(Handler<AsyncResult<CoordinateList>> resultHandler) {
        this.delegate.coordinateNodes(resultHandler);
        return this;
    }

    public Single<CoordinateList> rxCoordinateNodes() {
        return new AsyncResultSingle(handler -> this.coordinateNodes((Handler<AsyncResult<CoordinateList>>)handler));
    }

    public ConsulClient coordinateNodesWithOptions(BlockingQueryOptions options, Handler<AsyncResult<CoordinateList>> resultHandler) {
        this.delegate.coordinateNodesWithOptions(options, resultHandler);
        return this;
    }

    public Single<CoordinateList> rxCoordinateNodesWithOptions(BlockingQueryOptions options) {
        return new AsyncResultSingle(handler -> this.coordinateNodesWithOptions(options, (Handler<AsyncResult<CoordinateList>>)handler));
    }

    public ConsulClient coordinateDatacenters(Handler<AsyncResult<List<DcCoordinates>>> resultHandler) {
        this.delegate.coordinateDatacenters(resultHandler);
        return this;
    }

    public Single<List<DcCoordinates>> rxCoordinateDatacenters() {
        return new AsyncResultSingle(handler -> this.coordinateDatacenters((Handler<AsyncResult<List<DcCoordinates>>>)handler));
    }

    public ConsulClient getKeys(String keyPrefix, Handler<AsyncResult<List<String>>> resultHandler) {
        this.delegate.getKeys(keyPrefix, resultHandler);
        return this;
    }

    public Single<List<String>> rxGetKeys(String keyPrefix) {
        return new AsyncResultSingle(handler -> this.getKeys(keyPrefix, (Handler<AsyncResult<List<String>>>)handler));
    }

    public ConsulClient getKeysWithOptions(String keyPrefix, BlockingQueryOptions options, Handler<AsyncResult<List<String>>> resultHandler) {
        this.delegate.getKeysWithOptions(keyPrefix, options, resultHandler);
        return this;
    }

    public Single<List<String>> rxGetKeysWithOptions(String keyPrefix, BlockingQueryOptions options) {
        return new AsyncResultSingle(handler -> this.getKeysWithOptions(keyPrefix, options, (Handler<AsyncResult<List<String>>>)handler));
    }

    public ConsulClient getValue(String key, Handler<AsyncResult<KeyValue>> resultHandler) {
        this.delegate.getValue(key, resultHandler);
        return this;
    }

    public Single<KeyValue> rxGetValue(String key) {
        return new AsyncResultSingle(handler -> this.getValue(key, (Handler<AsyncResult<KeyValue>>)handler));
    }

    public ConsulClient getValueWithOptions(String key, BlockingQueryOptions options, Handler<AsyncResult<KeyValue>> resultHandler) {
        this.delegate.getValueWithOptions(key, options, resultHandler);
        return this;
    }

    public Single<KeyValue> rxGetValueWithOptions(String key, BlockingQueryOptions options) {
        return new AsyncResultSingle(handler -> this.getValueWithOptions(key, options, (Handler<AsyncResult<KeyValue>>)handler));
    }

    public ConsulClient deleteValue(String key, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.deleteValue(key, resultHandler);
        return this;
    }

    public Completable rxDeleteValue(String key) {
        return new AsyncResultCompletable(handler -> this.deleteValue(key, (Handler<AsyncResult<Void>>)handler));
    }

    public ConsulClient getValues(String keyPrefix, Handler<AsyncResult<KeyValueList>> resultHandler) {
        this.delegate.getValues(keyPrefix, resultHandler);
        return this;
    }

    public Single<KeyValueList> rxGetValues(String keyPrefix) {
        return new AsyncResultSingle(handler -> this.getValues(keyPrefix, (Handler<AsyncResult<KeyValueList>>)handler));
    }

    public ConsulClient getValuesWithOptions(String keyPrefix, BlockingQueryOptions options, Handler<AsyncResult<KeyValueList>> resultHandler) {
        this.delegate.getValuesWithOptions(keyPrefix, options, resultHandler);
        return this;
    }

    public Single<KeyValueList> rxGetValuesWithOptions(String keyPrefix, BlockingQueryOptions options) {
        return new AsyncResultSingle(handler -> this.getValuesWithOptions(keyPrefix, options, (Handler<AsyncResult<KeyValueList>>)handler));
    }

    public ConsulClient deleteValues(String keyPrefix, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.deleteValues(keyPrefix, resultHandler);
        return this;
    }

    public Completable rxDeleteValues(String keyPrefix) {
        return new AsyncResultCompletable(handler -> this.deleteValues(keyPrefix, (Handler<AsyncResult<Void>>)handler));
    }

    public ConsulClient putValue(String key, String value, Handler<AsyncResult<Boolean>> resultHandler) {
        this.delegate.putValue(key, value, resultHandler);
        return this;
    }

    public Single<Boolean> rxPutValue(String key, String value) {
        return new AsyncResultSingle(handler -> this.putValue(key, value, (Handler<AsyncResult<Boolean>>)handler));
    }

    public ConsulClient putValueWithOptions(String key, String value, KeyValueOptions options, Handler<AsyncResult<Boolean>> resultHandler) {
        this.delegate.putValueWithOptions(key, value, options, resultHandler);
        return this;
    }

    public Single<Boolean> rxPutValueWithOptions(String key, String value, KeyValueOptions options) {
        return new AsyncResultSingle(handler -> this.putValueWithOptions(key, value, options, (Handler<AsyncResult<Boolean>>)handler));
    }

    public ConsulClient transaction(TxnRequest request, Handler<AsyncResult<TxnResponse>> resultHandler) {
        this.delegate.transaction(request, resultHandler);
        return this;
    }

    public Single<TxnResponse> rxTransaction(TxnRequest request) {
        return new AsyncResultSingle(handler -> this.transaction(request, (Handler<AsyncResult<TxnResponse>>)handler));
    }

    public ConsulClient createAclToken(AclToken token, Handler<AsyncResult<String>> idHandler) {
        this.delegate.createAclToken(token, idHandler);
        return this;
    }

    public Single<String> rxCreateAclToken(AclToken token) {
        return new AsyncResultSingle(handler -> this.createAclToken(token, (Handler<AsyncResult<String>>)handler));
    }

    public ConsulClient updateAclToken(AclToken token, Handler<AsyncResult<String>> idHandler) {
        this.delegate.updateAclToken(token, idHandler);
        return this;
    }

    public Single<String> rxUpdateAclToken(AclToken token) {
        return new AsyncResultSingle(handler -> this.updateAclToken(token, (Handler<AsyncResult<String>>)handler));
    }

    public ConsulClient cloneAclToken(String id, Handler<AsyncResult<String>> idHandler) {
        this.delegate.cloneAclToken(id, idHandler);
        return this;
    }

    public Single<String> rxCloneAclToken(String id) {
        return new AsyncResultSingle(handler -> this.cloneAclToken(id, (Handler<AsyncResult<String>>)handler));
    }

    public ConsulClient listAclTokens(Handler<AsyncResult<List<AclToken>>> resultHandler) {
        this.delegate.listAclTokens(resultHandler);
        return this;
    }

    public Single<List<AclToken>> rxListAclTokens() {
        return new AsyncResultSingle(handler -> this.listAclTokens((Handler<AsyncResult<List<AclToken>>>)handler));
    }

    public ConsulClient infoAclToken(String id, Handler<AsyncResult<AclToken>> tokenHandler) {
        this.delegate.infoAclToken(id, tokenHandler);
        return this;
    }

    public Single<AclToken> rxInfoAclToken(String id) {
        return new AsyncResultSingle(handler -> this.infoAclToken(id, (Handler<AsyncResult<AclToken>>)handler));
    }

    public ConsulClient destroyAclToken(String id, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.destroyAclToken(id, resultHandler);
        return this;
    }

    public Completable rxDestroyAclToken(String id) {
        return new AsyncResultCompletable(handler -> this.destroyAclToken(id, (Handler<AsyncResult<Void>>)handler));
    }

    public ConsulClient fireEvent(String name, Handler<AsyncResult<Event>> resultHandler) {
        this.delegate.fireEvent(name, resultHandler);
        return this;
    }

    public Single<Event> rxFireEvent(String name) {
        return new AsyncResultSingle(handler -> this.fireEvent(name, (Handler<AsyncResult<Event>>)handler));
    }

    public ConsulClient fireEventWithOptions(String name, EventOptions options, Handler<AsyncResult<Event>> resultHandler) {
        this.delegate.fireEventWithOptions(name, options, resultHandler);
        return this;
    }

    public Single<Event> rxFireEventWithOptions(String name, EventOptions options) {
        return new AsyncResultSingle(handler -> this.fireEventWithOptions(name, options, (Handler<AsyncResult<Event>>)handler));
    }

    public ConsulClient listEvents(Handler<AsyncResult<EventList>> resultHandler) {
        this.delegate.listEvents(resultHandler);
        return this;
    }

    public Single<EventList> rxListEvents() {
        return new AsyncResultSingle(handler -> this.listEvents((Handler<AsyncResult<EventList>>)handler));
    }

    public ConsulClient listEventsWithOptions(EventListOptions options, Handler<AsyncResult<EventList>> resultHandler) {
        this.delegate.listEventsWithOptions(options, resultHandler);
        return this;
    }

    public Single<EventList> rxListEventsWithOptions(EventListOptions options) {
        return new AsyncResultSingle(handler -> this.listEventsWithOptions(options, (Handler<AsyncResult<EventList>>)handler));
    }

    public ConsulClient registerService(ServiceOptions serviceOptions, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.registerService(serviceOptions, resultHandler);
        return this;
    }

    public Completable rxRegisterService(ServiceOptions serviceOptions) {
        return new AsyncResultCompletable(handler -> this.registerService(serviceOptions, (Handler<AsyncResult<Void>>)handler));
    }

    public ConsulClient maintenanceService(MaintenanceOptions maintenanceOptions, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.maintenanceService(maintenanceOptions, resultHandler);
        return this;
    }

    public Completable rxMaintenanceService(MaintenanceOptions maintenanceOptions) {
        return new AsyncResultCompletable(handler -> this.maintenanceService(maintenanceOptions, (Handler<AsyncResult<Void>>)handler));
    }

    public ConsulClient deregisterService(String id, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.deregisterService(id, resultHandler);
        return this;
    }

    public Completable rxDeregisterService(String id) {
        return new AsyncResultCompletable(handler -> this.deregisterService(id, (Handler<AsyncResult<Void>>)handler));
    }

    public ConsulClient catalogServiceNodes(String service, Handler<AsyncResult<ServiceList>> resultHandler) {
        this.delegate.catalogServiceNodes(service, resultHandler);
        return this;
    }

    public Single<ServiceList> rxCatalogServiceNodes(String service) {
        return new AsyncResultSingle(handler -> this.catalogServiceNodes(service, (Handler<AsyncResult<ServiceList>>)handler));
    }

    public ConsulClient catalogServiceNodesWithOptions(String service, ServiceQueryOptions options, Handler<AsyncResult<ServiceList>> resultHandler) {
        this.delegate.catalogServiceNodesWithOptions(service, options, resultHandler);
        return this;
    }

    public Single<ServiceList> rxCatalogServiceNodesWithOptions(String service, ServiceQueryOptions options) {
        return new AsyncResultSingle(handler -> this.catalogServiceNodesWithOptions(service, options, (Handler<AsyncResult<ServiceList>>)handler));
    }

    public ConsulClient catalogDatacenters(Handler<AsyncResult<List<String>>> resultHandler) {
        this.delegate.catalogDatacenters(resultHandler);
        return this;
    }

    public Single<List<String>> rxCatalogDatacenters() {
        return new AsyncResultSingle(handler -> this.catalogDatacenters((Handler<AsyncResult<List<String>>>)handler));
    }

    public ConsulClient catalogNodes(Handler<AsyncResult<NodeList>> resultHandler) {
        this.delegate.catalogNodes(resultHandler);
        return this;
    }

    public Single<NodeList> rxCatalogNodes() {
        return new AsyncResultSingle(handler -> this.catalogNodes((Handler<AsyncResult<NodeList>>)handler));
    }

    public ConsulClient catalogNodesWithOptions(NodeQueryOptions options, Handler<AsyncResult<NodeList>> resultHandler) {
        this.delegate.catalogNodesWithOptions(options, resultHandler);
        return this;
    }

    public Single<NodeList> rxCatalogNodesWithOptions(NodeQueryOptions options) {
        return new AsyncResultSingle(handler -> this.catalogNodesWithOptions(options, (Handler<AsyncResult<NodeList>>)handler));
    }

    public ConsulClient healthChecks(String service, Handler<AsyncResult<CheckList>> resultHandler) {
        this.delegate.healthChecks(service, resultHandler);
        return this;
    }

    public Single<CheckList> rxHealthChecks(String service) {
        return new AsyncResultSingle(handler -> this.healthChecks(service, (Handler<AsyncResult<CheckList>>)handler));
    }

    public ConsulClient healthChecksWithOptions(String service, CheckQueryOptions options, Handler<AsyncResult<CheckList>> resultHandler) {
        this.delegate.healthChecksWithOptions(service, options, resultHandler);
        return this;
    }

    public Single<CheckList> rxHealthChecksWithOptions(String service, CheckQueryOptions options) {
        return new AsyncResultSingle(handler -> this.healthChecksWithOptions(service, options, (Handler<AsyncResult<CheckList>>)handler));
    }

    public ConsulClient healthState(CheckStatus checkStatus, Handler<AsyncResult<CheckList>> resultHandler) {
        this.delegate.healthState(checkStatus, resultHandler);
        return this;
    }

    public Single<CheckList> rxHealthState(CheckStatus checkStatus) {
        return new AsyncResultSingle(handler -> this.healthState(checkStatus, (Handler<AsyncResult<CheckList>>)handler));
    }

    public ConsulClient healthStateWithOptions(CheckStatus checkStatus, CheckQueryOptions options, Handler<AsyncResult<CheckList>> resultHandler) {
        this.delegate.healthStateWithOptions(checkStatus, options, resultHandler);
        return this;
    }

    public Single<CheckList> rxHealthStateWithOptions(CheckStatus checkStatus, CheckQueryOptions options) {
        return new AsyncResultSingle(handler -> this.healthStateWithOptions(checkStatus, options, (Handler<AsyncResult<CheckList>>)handler));
    }

    public ConsulClient healthServiceNodes(String service, boolean passing, Handler<AsyncResult<ServiceEntryList>> resultHandler) {
        this.delegate.healthServiceNodes(service, passing, resultHandler);
        return this;
    }

    public Single<ServiceEntryList> rxHealthServiceNodes(String service, boolean passing) {
        return new AsyncResultSingle(handler -> this.healthServiceNodes(service, passing, (Handler<AsyncResult<ServiceEntryList>>)handler));
    }

    public ConsulClient healthServiceNodesWithOptions(String service, boolean passing, ServiceQueryOptions options, Handler<AsyncResult<ServiceEntryList>> resultHandler) {
        this.delegate.healthServiceNodesWithOptions(service, passing, options, resultHandler);
        return this;
    }

    public Single<ServiceEntryList> rxHealthServiceNodesWithOptions(String service, boolean passing, ServiceQueryOptions options) {
        return new AsyncResultSingle(handler -> this.healthServiceNodesWithOptions(service, passing, options, (Handler<AsyncResult<ServiceEntryList>>)handler));
    }

    public ConsulClient catalogServices(Handler<AsyncResult<ServiceList>> resultHandler) {
        this.delegate.catalogServices(resultHandler);
        return this;
    }

    public Single<ServiceList> rxCatalogServices() {
        return new AsyncResultSingle(handler -> this.catalogServices((Handler<AsyncResult<ServiceList>>)handler));
    }

    public ConsulClient catalogServicesWithOptions(BlockingQueryOptions options, Handler<AsyncResult<ServiceList>> resultHandler) {
        this.delegate.catalogServicesWithOptions(options, resultHandler);
        return this;
    }

    public Single<ServiceList> rxCatalogServicesWithOptions(BlockingQueryOptions options) {
        return new AsyncResultSingle(handler -> this.catalogServicesWithOptions(options, (Handler<AsyncResult<ServiceList>>)handler));
    }

    public ConsulClient catalogNodeServices(String node, Handler<AsyncResult<ServiceList>> resultHandler) {
        this.delegate.catalogNodeServices(node, resultHandler);
        return this;
    }

    public Single<ServiceList> rxCatalogNodeServices(String node) {
        return new AsyncResultSingle(handler -> this.catalogNodeServices(node, (Handler<AsyncResult<ServiceList>>)handler));
    }

    public ConsulClient catalogNodeServicesWithOptions(String node, BlockingQueryOptions options, Handler<AsyncResult<ServiceList>> resultHandler) {
        this.delegate.catalogNodeServicesWithOptions(node, options, resultHandler);
        return this;
    }

    public Single<ServiceList> rxCatalogNodeServicesWithOptions(String node, BlockingQueryOptions options) {
        return new AsyncResultSingle(handler -> this.catalogNodeServicesWithOptions(node, options, (Handler<AsyncResult<ServiceList>>)handler));
    }

    public ConsulClient localServices(Handler<AsyncResult<List<Service>>> resultHandler) {
        this.delegate.localServices(resultHandler);
        return this;
    }

    public Single<List<Service>> rxLocalServices() {
        return new AsyncResultSingle(handler -> this.localServices((Handler<AsyncResult<List<Service>>>)handler));
    }

    public ConsulClient localChecks(Handler<AsyncResult<List<Check>>> resultHandler) {
        this.delegate.localChecks(resultHandler);
        return this;
    }

    public Single<List<Check>> rxLocalChecks() {
        return new AsyncResultSingle(handler -> this.localChecks((Handler<AsyncResult<List<Check>>>)handler));
    }

    public ConsulClient registerCheck(CheckOptions checkOptions, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.registerCheck(checkOptions, resultHandler);
        return this;
    }

    public Completable rxRegisterCheck(CheckOptions checkOptions) {
        return new AsyncResultCompletable(handler -> this.registerCheck(checkOptions, (Handler<AsyncResult<Void>>)handler));
    }

    public ConsulClient deregisterCheck(String checkId, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.deregisterCheck(checkId, resultHandler);
        return this;
    }

    public Completable rxDeregisterCheck(String checkId) {
        return new AsyncResultCompletable(handler -> this.deregisterCheck(checkId, (Handler<AsyncResult<Void>>)handler));
    }

    public ConsulClient passCheck(String checkId, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.passCheck(checkId, resultHandler);
        return this;
    }

    public Completable rxPassCheck(String checkId) {
        return new AsyncResultCompletable(handler -> this.passCheck(checkId, (Handler<AsyncResult<Void>>)handler));
    }

    public ConsulClient passCheckWithNote(String checkId, String note, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.passCheckWithNote(checkId, note, resultHandler);
        return this;
    }

    public Completable rxPassCheckWithNote(String checkId, String note) {
        return new AsyncResultCompletable(handler -> this.passCheckWithNote(checkId, note, (Handler<AsyncResult<Void>>)handler));
    }

    public ConsulClient warnCheck(String checkId, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.warnCheck(checkId, resultHandler);
        return this;
    }

    public Completable rxWarnCheck(String checkId) {
        return new AsyncResultCompletable(handler -> this.warnCheck(checkId, (Handler<AsyncResult<Void>>)handler));
    }

    public ConsulClient warnCheckWithNote(String checkId, String note, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.warnCheckWithNote(checkId, note, resultHandler);
        return this;
    }

    public Completable rxWarnCheckWithNote(String checkId, String note) {
        return new AsyncResultCompletable(handler -> this.warnCheckWithNote(checkId, note, (Handler<AsyncResult<Void>>)handler));
    }

    public ConsulClient failCheck(String checkId, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.failCheck(checkId, resultHandler);
        return this;
    }

    public Completable rxFailCheck(String checkId) {
        return new AsyncResultCompletable(handler -> this.failCheck(checkId, (Handler<AsyncResult<Void>>)handler));
    }

    public ConsulClient failCheckWithNote(String checkId, String note, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.failCheckWithNote(checkId, note, resultHandler);
        return this;
    }

    public Completable rxFailCheckWithNote(String checkId, String note) {
        return new AsyncResultCompletable(handler -> this.failCheckWithNote(checkId, note, (Handler<AsyncResult<Void>>)handler));
    }

    public ConsulClient updateCheck(String checkId, CheckStatus status, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.updateCheck(checkId, status, resultHandler);
        return this;
    }

    public Completable rxUpdateCheck(String checkId, CheckStatus status) {
        return new AsyncResultCompletable(handler -> this.updateCheck(checkId, status, (Handler<AsyncResult<Void>>)handler));
    }

    public ConsulClient updateCheckWithNote(String checkId, CheckStatus status, String note, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.updateCheckWithNote(checkId, status, note, resultHandler);
        return this;
    }

    public Completable rxUpdateCheckWithNote(String checkId, CheckStatus status, String note) {
        return new AsyncResultCompletable(handler -> this.updateCheckWithNote(checkId, status, note, (Handler<AsyncResult<Void>>)handler));
    }

    public ConsulClient leaderStatus(Handler<AsyncResult<String>> resultHandler) {
        this.delegate.leaderStatus(resultHandler);
        return this;
    }

    public Single<String> rxLeaderStatus() {
        return new AsyncResultSingle(handler -> this.leaderStatus((Handler<AsyncResult<String>>)handler));
    }

    public ConsulClient peersStatus(Handler<AsyncResult<List<String>>> resultHandler) {
        this.delegate.peersStatus(resultHandler);
        return this;
    }

    public Single<List<String>> rxPeersStatus() {
        return new AsyncResultSingle(handler -> this.peersStatus((Handler<AsyncResult<List<String>>>)handler));
    }

    public ConsulClient createSession(Handler<AsyncResult<String>> idHandler) {
        this.delegate.createSession(idHandler);
        return this;
    }

    public Single<String> rxCreateSession() {
        return new AsyncResultSingle(handler -> this.createSession((Handler<AsyncResult<String>>)handler));
    }

    public ConsulClient createSessionWithOptions(SessionOptions options, Handler<AsyncResult<String>> idHandler) {
        this.delegate.createSessionWithOptions(options, idHandler);
        return this;
    }

    public Single<String> rxCreateSessionWithOptions(SessionOptions options) {
        return new AsyncResultSingle(handler -> this.createSessionWithOptions(options, (Handler<AsyncResult<String>>)handler));
    }

    public ConsulClient infoSession(String id, Handler<AsyncResult<Session>> resultHandler) {
        this.delegate.infoSession(id, resultHandler);
        return this;
    }

    public Single<Session> rxInfoSession(String id) {
        return new AsyncResultSingle(handler -> this.infoSession(id, (Handler<AsyncResult<Session>>)handler));
    }

    public ConsulClient infoSessionWithOptions(String id, BlockingQueryOptions options, Handler<AsyncResult<Session>> resultHandler) {
        this.delegate.infoSessionWithOptions(id, options, resultHandler);
        return this;
    }

    public Single<Session> rxInfoSessionWithOptions(String id, BlockingQueryOptions options) {
        return new AsyncResultSingle(handler -> this.infoSessionWithOptions(id, options, (Handler<AsyncResult<Session>>)handler));
    }

    public ConsulClient renewSession(String id, Handler<AsyncResult<Session>> resultHandler) {
        this.delegate.renewSession(id, resultHandler);
        return this;
    }

    public Single<Session> rxRenewSession(String id) {
        return new AsyncResultSingle(handler -> this.renewSession(id, (Handler<AsyncResult<Session>>)handler));
    }

    public ConsulClient listSessions(Handler<AsyncResult<SessionList>> resultHandler) {
        this.delegate.listSessions(resultHandler);
        return this;
    }

    public Single<SessionList> rxListSessions() {
        return new AsyncResultSingle(handler -> this.listSessions((Handler<AsyncResult<SessionList>>)handler));
    }

    public ConsulClient listSessionsWithOptions(BlockingQueryOptions options, Handler<AsyncResult<SessionList>> resultHandler) {
        this.delegate.listSessionsWithOptions(options, resultHandler);
        return this;
    }

    public Single<SessionList> rxListSessionsWithOptions(BlockingQueryOptions options) {
        return new AsyncResultSingle(handler -> this.listSessionsWithOptions(options, (Handler<AsyncResult<SessionList>>)handler));
    }

    public ConsulClient listNodeSessions(String nodeId, Handler<AsyncResult<SessionList>> resultHandler) {
        this.delegate.listNodeSessions(nodeId, resultHandler);
        return this;
    }

    public Single<SessionList> rxListNodeSessions(String nodeId) {
        return new AsyncResultSingle(handler -> this.listNodeSessions(nodeId, (Handler<AsyncResult<SessionList>>)handler));
    }

    public ConsulClient listNodeSessionsWithOptions(String nodeId, BlockingQueryOptions options, Handler<AsyncResult<SessionList>> resultHandler) {
        this.delegate.listNodeSessionsWithOptions(nodeId, options, resultHandler);
        return this;
    }

    public Single<SessionList> rxListNodeSessionsWithOptions(String nodeId, BlockingQueryOptions options) {
        return new AsyncResultSingle(handler -> this.listNodeSessionsWithOptions(nodeId, options, (Handler<AsyncResult<SessionList>>)handler));
    }

    public ConsulClient destroySession(String id, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.destroySession(id, resultHandler);
        return this;
    }

    public Completable rxDestroySession(String id) {
        return new AsyncResultCompletable(handler -> this.destroySession(id, (Handler<AsyncResult<Void>>)handler));
    }

    public ConsulClient createPreparedQuery(PreparedQueryDefinition definition, Handler<AsyncResult<String>> resultHandler) {
        this.delegate.createPreparedQuery(definition, resultHandler);
        return this;
    }

    public Single<String> rxCreatePreparedQuery(PreparedQueryDefinition definition) {
        return new AsyncResultSingle(handler -> this.createPreparedQuery(definition, (Handler<AsyncResult<String>>)handler));
    }

    public ConsulClient getPreparedQuery(String id, Handler<AsyncResult<PreparedQueryDefinition>> resultHandler) {
        this.delegate.getPreparedQuery(id, resultHandler);
        return this;
    }

    public Single<PreparedQueryDefinition> rxGetPreparedQuery(String id) {
        return new AsyncResultSingle(handler -> this.getPreparedQuery(id, (Handler<AsyncResult<PreparedQueryDefinition>>)handler));
    }

    public ConsulClient getAllPreparedQueries(Handler<AsyncResult<List<PreparedQueryDefinition>>> resultHandler) {
        this.delegate.getAllPreparedQueries(resultHandler);
        return this;
    }

    public Single<List<PreparedQueryDefinition>> rxGetAllPreparedQueries() {
        return new AsyncResultSingle(handler -> this.getAllPreparedQueries((Handler<AsyncResult<List<PreparedQueryDefinition>>>)handler));
    }

    public ConsulClient updatePreparedQuery(PreparedQueryDefinition definition, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.updatePreparedQuery(definition, resultHandler);
        return this;
    }

    public Completable rxUpdatePreparedQuery(PreparedQueryDefinition definition) {
        return new AsyncResultCompletable(handler -> this.updatePreparedQuery(definition, (Handler<AsyncResult<Void>>)handler));
    }

    public ConsulClient deletePreparedQuery(String id, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.deletePreparedQuery(id, resultHandler);
        return this;
    }

    public Completable rxDeletePreparedQuery(String id) {
        return new AsyncResultCompletable(handler -> this.deletePreparedQuery(id, (Handler<AsyncResult<Void>>)handler));
    }

    public ConsulClient executePreparedQuery(String query, Handler<AsyncResult<PreparedQueryExecuteResponse>> resultHandler) {
        this.delegate.executePreparedQuery(query, resultHandler);
        return this;
    }

    public Single<PreparedQueryExecuteResponse> rxExecutePreparedQuery(String query) {
        return new AsyncResultSingle(handler -> this.executePreparedQuery(query, (Handler<AsyncResult<PreparedQueryExecuteResponse>>)handler));
    }

    public ConsulClient executePreparedQueryWithOptions(String query, PreparedQueryExecuteOptions options, Handler<AsyncResult<PreparedQueryExecuteResponse>> resultHandler) {
        this.delegate.executePreparedQueryWithOptions(query, options, resultHandler);
        return this;
    }

    public Single<PreparedQueryExecuteResponse> rxExecutePreparedQueryWithOptions(String query, PreparedQueryExecuteOptions options) {
        return new AsyncResultSingle(handler -> this.executePreparedQueryWithOptions(query, options, (Handler<AsyncResult<PreparedQueryExecuteResponse>>)handler));
    }

    public void close() {
        this.delegate.close();
    }

    public static ConsulClient newInstance(io.vertx.ext.consul.ConsulClient arg) {
        return arg != null ? new ConsulClient(arg) : null;
    }
}

