/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.json.JsonCodec;
import io.vertx.ext.consul.Check;
import io.vertx.ext.consul.CheckList;
import java.util.ArrayList;
import java.util.Map;

public class CheckListConverter
implements JsonCodec<CheckList, JsonObject> {
    public static final CheckListConverter INSTANCE = new CheckListConverter();

    public JsonObject encode(CheckList value) {
        return value != null ? value.toJson() : null;
    }

    public CheckList decode(JsonObject value) {
        return value != null ? new CheckList(value) : null;
    }

    public Class<CheckList> getTargetClass() {
        return CheckList.class;
    }

    public static void fromJson(Iterable<Map.Entry<String, Object>> json, CheckList obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "index": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setIndex(((Number)member.getValue()).longValue());
                    break;
                }
                case "list": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Check> list = new ArrayList<Check>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            list.add(new Check((JsonObject)item));
                        }
                    });
                    obj.setList(list);
                }
            }
        }
    }

    public static void toJson(CheckList obj, JsonObject json) {
        CheckListConverter.toJson(obj, json.getMap());
    }

    public static void toJson(CheckList obj, Map<String, Object> json) {
        json.put("index", obj.getIndex());
        if (obj.getList() != null) {
            JsonArray array = new JsonArray();
            obj.getList().forEach(item -> array.add(item.toJson()));
            json.put("list", array);
        }
    }
}

